/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp.faceting;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.FacetsConfigurationFileNotFoundException;
import ro.sync.textsearch.TaxonomyIndexNotFoundException;
import ro.sync.textsearch.webhelp.faceting.Facet;

public class FacetsConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)FacetsConfigUtils.class.getName());
    private static final String FACETS_CONFIGURATION_FILE = "facets_config.ser";
    private static final String FACETS_CONFIGURATION_JSON_FILE = "search-facets.json";

    public static FacetsConfig getFacetsConfig(File taxonomyDirFile) {
        FacetsConfig facetsConfig = new FacetsConfig();
        File facetsConfiguration = new File(taxonomyDirFile, FACETS_CONFIGURATION_FILE);
        HashSet facets = new HashSet();
        if (facetsConfiguration.exists()) {
            try (FileInputStream fis = new FileInputStream(facetsConfiguration.toString());
                 ObjectInputStream ois = new ObjectInputStream(fis);){
                facets = (HashSet)ois.readObject();
            }
            catch (FileNotFoundException e) {
                logger.error("Facets configuration file couldn't be found: ", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("An IO exception occured while trying to read the facets configuration file: ", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error("An exception occured while trying to read the facets configuration file: ", (Throwable)e);
            }
            for (String facet : facets) {
                facetsConfig.setHierarchical(facet, true);
                facetsConfig.setMultiValued(facet, true);
            }
        }
        return facetsConfig;
    }

    public static void saveFacetsConfig(FacetsConfig facetsConfig, File taxonomyDirFile) {
        if (facetsConfig == null || facetsConfig.getDimConfigs().isEmpty()) {
            return;
        }
        File facetsConfiguration = new File(taxonomyDirFile, FACETS_CONFIGURATION_FILE);
        HashSet<String> facets = new HashSet<String>();
        for (String facet : facetsConfig.getDimConfigs().keySet()) {
            facets.add(facet);
        }
        if (facetsConfiguration.getParentFile().mkdirs() && logger.isDebugEnabled()) {
            logger.debug("Taxonomy directory was created.");
        }
        try (FileOutputStream fos = new FileOutputStream(facetsConfiguration.toString());
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(facets);
        }
        catch (FileNotFoundException e) {
            logger.error("Facets configuration file couldn't be found: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("An IO exception occured while trying to read the facets configuration file: ", (Throwable)e);
        }
    }

    public static String getFacetsAndValues(File taxonomyDirFile) {
        try {
            File facetsJSONFile = new File(taxonomyDirFile, FACETS_CONFIGURATION_JSON_FILE);
            if (!facetsJSONFile.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Facets JSON configuration doesn't exist, don't use faceted search.");
                }
                return "";
            }
            byte[] encoded = Files.readAllBytes(facetsJSONFile.toPath());
            String facetsJSON = new String(encoded, StandardCharsets.UTF_8);
            JsonFactory factory = new JsonFactory();
            ObjectMapper objectMapper = new ObjectMapper(factory);
            JsonNode facetsRootNode = objectMapper.readTree(facetsJSON);
            String content = facetsRootNode.toString();
            return content;
        }
        catch (IOException e) {
            logger.error("Facets JSON object couldn't be processed: ", (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterFacets(File taxonomyDirFile) throws TaxonomyIndexNotFoundException, FacetsConfigurationFileNotFoundException {
        Set<Facet> facetsFromTaxonomy = FacetsConfigUtils.getFacetsAndValuesFromTaxonomy(taxonomyDirFile);
        Set<Facet> facetsFromJSON = FacetsConfigUtils.getFacetsAndValuesFromJSON(taxonomyDirFile);
        LinkedList<Facet> facetsFromTaxonomyQueue = new LinkedList<Facet>();
        LinkedList<Facet> facetsFromJSONQueue = new LinkedList<Facet>();
        for (Facet facetFromTaxonomy : facetsFromTaxonomy) {
            facetsFromTaxonomyQueue.add(facetFromTaxonomy);
        }
        for (Facet facetFromJSON : facetsFromJSON) {
            facetsFromJSONQueue.add(facetFromJSON);
        }
        while (!facetsFromJSONQueue.isEmpty()) {
            Facet facetFromJSON = (Facet)facetsFromJSONQueue.poll();
            boolean isPresentInTaxonomy = false;
            for (Facet facetFromTaxonomy : facetsFromTaxonomyQueue) {
                if (!facetFromTaxonomy.getKey().equals(facetFromJSON.getKey())) continue;
                isPresentInTaxonomy = true;
                facetsFromJSONQueue.addAll(facetFromJSON.getCategories());
                facetsFromTaxonomyQueue.addAll(facetFromTaxonomy.getCategories());
                facetsFromJSONQueue.remove(facetFromJSON);
                facetsFromTaxonomyQueue.remove(facetFromTaxonomy);
                break;
            }
            if (isPresentInTaxonomy) continue;
            FacetsConfigUtils.removeFacetFromTree(facetsFromJSON, facetFromJSON);
            facetsFromJSONQueue.remove(facetFromJSON);
            for (Facet facetFromTaxonomy : facetsFromTaxonomy) {
                if (!facetFromTaxonomy.getKey().equals(facetFromJSON.getKey())) continue;
                facetsFromTaxonomyQueue.remove(facetFromTaxonomy);
            }
        }
        File facetsJSONFile = new File(taxonomyDirFile, FACETS_CONFIGURATION_JSON_FILE);
        try (PrintWriter printWriter = null;){
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            printWriter = new PrintWriter(facetsJSONFile.toString());
            printWriter.print(objectMapper.writeValueAsString(facetsFromJSON));
        }
    }

    private static void removeFacetFromTree(Set<Facet> facets, Facet facet) {
        for (Facet category : facets) {
            if (category.getKey().equals(facet.getKey())) {
                facets.remove(category);
                break;
            }
            FacetsConfigUtils.removeFacetFromTree(category.getCategories(), facet);
        }
    }

    private static Set<Facet> getFacetsAndValuesFromJSON(File taxonomyDirFile) throws FacetsConfigurationFileNotFoundException {
        try {
            File facetsJSONFile = new File(taxonomyDirFile, FACETS_CONFIGURATION_JSON_FILE);
            byte[] encoded = Files.readAllBytes(facetsJSONFile.toPath());
            String facetsJSON = new String(encoded, StandardCharsets.UTF_8);
            JsonFactory factory = new JsonFactory();
            ObjectMapper objectMapper = new ObjectMapper(factory);
            JsonNode facetsRootNode = objectMapper.readTree(facetsJSON).get("facets");
            String content = facetsRootNode.toString().replace("\"navtitle\"", "\"title\"");
            LinkedHashSet facets = (LinkedHashSet)objectMapper.readValue(content, (TypeReference)new TypeReference<LinkedHashSet<Facet>>(){});
            return facets;
        }
        catch (IOException e) {
            throw new FacetsConfigurationFileNotFoundException();
        }
    }

    private static Set<Facet> getFacetsAndValuesFromTaxonomy(File taxonomyDirFile) throws TaxonomyIndexNotFoundException {
        LinkedHashSet<Facet> facetsAndPaths = new LinkedHashSet<Facet>();
        LinkedHashSet<List<String>> facetsAndPathsRaw = new LinkedHashSet<List<String>>();
        try (DirectoryTaxonomyReader taxonomyReader = new DirectoryTaxonomyReader((Directory)FSDirectory.open((Path)taxonomyDirFile.toPath()));){
            ParallelTaxonomyArrays taxonomyTree = taxonomyReader.getParallelTaxonomyArrays();
            ParallelTaxonomyArrays.IntArray parents = taxonomyTree.parents();
            for (int i = 0; i < parents.length(); ++i) {
                int index = parents.get(i);
                if (index == -1) continue;
                TaxonomyReader.ChildrenIterator children = taxonomyReader.getChildren(index);
                int next = children.next();
                while (next != -1) {
                    String[] stringArray = taxonomyReader.getPath((int)next).components;
                    if (stringArray.length > 1) {
                        ArrayList<String> facetAndPathList = new ArrayList<String>();
                        for (String e : stringArray) {
                            facetAndPathList.add(e);
                        }
                        facetsAndPathsRaw.add(facetAndPathList);
                    }
                    next = children.next();
                }
            }
            List<String> facets = FacetsConfigUtils.getFacetsFromTaxonomyConfig(taxonomyDirFile);
            for (String facet : facets) {
                for (List list : facetsAndPathsRaw) {
                    Facet facetToAdd;
                    if (list.isEmpty() || !((String)list.get(0)).equals(facet) || (facetToAdd = FacetsConfigUtils.createFacetFromRawData(facet, facetsAndPathsRaw, taxonomyDirFile)) == null || !facets.contains(facetToAdd.getKey())) continue;
                    facetsAndPaths.add(facetToAdd);
                }
            }
        }
        catch (IOException e) {
            throw new TaxonomyIndexNotFoundException();
        }
        return facetsAndPaths;
    }

    private static List<String> getFacetsFromTaxonomyConfig(File taxonomyDirFile) {
        ArrayList<String> facets = new ArrayList<String>();
        FacetsConfig facetsConfig = FacetsConfigUtils.getFacetsConfig(taxonomyDirFile);
        Map dimConfigs = facetsConfig.getDimConfigs();
        for (Map.Entry dimConfig : dimConfigs.entrySet()) {
            facets.add((String)dimConfig.getKey());
        }
        return facets;
    }

    private static Facet createFacetFromRawData(String facetKey, Set<List<String>> facetsAndPathsRaw, File taxonomyDirFile) {
        Facet currentFacet = null;
        boolean isFromCurrentPath = false;
        LinkedHashSet<Facet> categories = new LinkedHashSet<Facet>();
        for (List<String> facetAndPathsRaw : facetsAndPathsRaw) {
            for (String facetAndPathRaw : facetAndPathsRaw) {
                if (facetAndPathRaw.equals(facetKey)) {
                    isFromCurrentPath = true;
                    continue;
                }
                if (!isFromCurrentPath) continue;
                isFromCurrentPath = false;
                categories.add(FacetsConfigUtils.createFacetFromRawData(facetAndPathRaw, facetsAndPathsRaw, taxonomyDirFile));
            }
            isFromCurrentPath = false;
        }
        currentFacet = new Facet(facetKey, facetKey, categories);
        return currentFacet;
    }
}

