/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import ro.sync.textsearch.SearchOptions;
import ro.sync.textsearch.collectors.TopDocsAndTotalHits;
import ro.sync.textsearch.webhelp.WebHelpResourcesCollector;

public class WebHelpResourcesCollectorManager
implements CollectorManager<Collector, TopDocsAndTotalHits> {
    private final SearchOptions searchOptions;
    private final boolean facetsEnabled;
    private final IndexSearcher indexSearcher;

    public WebHelpResourcesCollectorManager(IndexSearcher indexSearcher, SearchOptions searchOptions, boolean facetsEnabled) {
        this.searchOptions = searchOptions;
        this.facetsEnabled = facetsEnabled;
        this.indexSearcher = indexSearcher;
    }

    public Collector newCollector() {
        if (this.facetsEnabled) {
            return MultiCollector.wrap((Collector[])new Collector[]{new FacetsCollector(), new WebHelpResourcesCollector(this.indexSearcher)});
        }
        return new WebHelpResourcesCollector(this.indexSearcher);
    }

    public TopDocsAndTotalHits reduce(Collection<Collector> collectors) throws IOException {
        Map<Integer, Float> aggregatedScores = new HashMap<Integer, Float>();
        HashSet<Integer> facetDocIds = new HashSet<Integer>();
        boolean isSearchWithFacets = this.searchOptions.getFacets() != null && !"".equals(this.searchOptions.getFacets());
        for (Collector collector : collectors) {
            if (collector instanceof MultiCollector) {
                if (isSearchWithFacets) {
                    FacetsCollector facetsCollector = (FacetsCollector)((MultiCollector)collector).getCollectors()[0];
                    this.extractFacetDocs(facetsCollector, facetDocIds);
                }
                collector = ((MultiCollector)collector).getCollectors()[1];
            }
            if (!(collector instanceof WebHelpResourcesCollector)) continue;
            WebHelpResourcesCollector webHelpCollector = (WebHelpResourcesCollector)collector;
            aggregatedScores = webHelpCollector.getAggregatedScores();
        }
        if (isSearchWithFacets) {
            aggregatedScores.keySet().retainAll(facetDocIds);
        }
        return this.prepareTopResults(aggregatedScores);
    }

    private void extractFacetDocs(FacetsCollector facetsCollector, Set<Integer> facetDocIds) throws IOException {
        for (FacetsCollector.MatchingDocs matchingDoc : facetsCollector.getMatchingDocs()) {
            int docId;
            DocIdSetIterator iterator = matchingDoc.bits.iterator();
            while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
                facetDocIds.add(docId + matchingDoc.context.docBase);
            }
        }
    }

    private TopDocsAndTotalHits prepareTopResults(Map<Integer, Float> aggregatedScores) {
        List<ScoreDoc> scoreDocs = aggregatedScores.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(this.searchOptions.getMaximumHitsNumber()).map(entry -> new ScoreDoc(((Integer)entry.getKey()).intValue(), ((Float)entry.getValue()).floatValue())).collect(Collectors.toList());
        TotalHits totalHits = new TotalHits((long)aggregatedScores.size(), TotalHits.Relation.EQUAL_TO);
        TopDocs topDocs = new TopDocs(totalHits, scoreDocs.toArray(new ScoreDoc[0]));
        return new TopDocsAndTotalHits(topDocs, aggregatedScores.size());
    }
}

