/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;

public class WebHelpResourcesCollector
implements Collector {
    private final Map<Integer, Float> aggregatedScores = new HashMap<Integer, Float>();
    private Scorable scorer;
    private IndexSearcher searcher;

    public WebHelpResourcesCollector(IndexSearcher searcher) {
        this.searcher = searcher;
    }

    public LeafCollector getLeafCollector(final LeafReaderContext context) throws IOException {
        return new LeafCollector(){

            public void setScorer(Scorable scorer) throws IOException {
                WebHelpResourcesCollector.this.scorer = scorer;
            }

            public void collect(int doc) throws IOException {
                int documentId = doc + context.docBase;
                Document document = WebHelpResourcesCollector.this.searcher.storedFields().document(documentId);
                String uri = document.get("__uri__");
                String documentType = document.get("__document_type__");
                float score = WebHelpResourcesCollector.this.scorer.score();
                if ("keywords".equals(documentType) || documentType == null) {
                    WebHelpResourcesCollector.this.aggregatedScores.merge(documentId, Float.valueOf(score), Float::sum);
                } else {
                    int htmlDocId = this.findHtmlDocIdForUri(uri);
                    if (htmlDocId != -1) {
                        WebHelpResourcesCollector.this.aggregatedScores.merge(htmlDocId, Float.valueOf(score), Float::sum);
                    }
                }
            }

            private int findHtmlDocIdForUri(String uri) throws IOException {
                BooleanQuery.Builder compoundBuilder = new BooleanQuery.Builder();
                TermQuery termQuery = new TermQuery(new Term("__uri__", uri));
                compoundBuilder.add((Query)termQuery, BooleanClause.Occur.MUST);
                TermQuery termQuery2 = new TermQuery(new Term("__document_type__", "keywords"));
                compoundBuilder.add((Query)termQuery2, BooleanClause.Occur.MUST);
                TopDocs topDocs = WebHelpResourcesCollector.this.searcher.search((Query)compoundBuilder.build(), 1);
                if (topDocs.scoreDocs.length > 0) {
                    return topDocs.scoreDocs[0].doc;
                }
                return -1;
            }
        };
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    public Map<Integer, Float> getAggregatedScores() {
        return this.aggregatedScores;
    }
}

