/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.io;

import java.net.URI;
import java.net.URISyntaxException;

public class TextSearchURIUtil {
    public static String uncorrect(URI uri, boolean includeUserInfoInTheResult) {
        StringBuffer sb = new StringBuffer();
        String scheme = uri.getScheme();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        if (uri.isOpaque()) {
            sb.append(uri.getSchemeSpecificPart());
        } else {
            String query;
            if (uri.getHost() != null) {
                int port;
                String host;
                boolean needBrackets;
                sb.append("//");
                if (includeUserInfoInTheResult && uri.getUserInfo() != null) {
                    sb.append(uri.getUserInfo());
                    sb.append('@');
                }
                boolean bl = needBrackets = (host = uri.getHost()).indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
                if (needBrackets) {
                    sb.append('[');
                }
                sb.append(host);
                if (needBrackets) {
                    sb.append(']');
                }
                if ((port = uri.getPort()) != -1) {
                    sb.append(':');
                    sb.append(port);
                }
            } else if (uri.getAuthority() != null) {
                sb.append("//");
                sb.append(uri.getAuthority());
            }
            String path = uri.getPath();
            if (path != null) {
                sb.append(path);
            }
            if ((query = uri.getQuery()) != null) {
                sb.append('?');
                sb.append(query);
            }
        }
        String fragment = uri.getFragment();
        if (fragment != null) {
            sb.append('#');
            sb.append(fragment);
        }
        return sb.toString();
    }

    public static String maskPasswords(String message) {
        if (message == null) {
            return null;
        }
        if (message.indexOf("@") != -1) {
            return message.replaceAll("://([^\\:\\/\\@]*?):([^\\:\\/]*?)@", "://$1:******@");
        }
        return message;
    }

    public static URI removeUserAndPassword(URI uri) throws URISyntaxException {
        String uriStr = uri.toString();
        uriStr = uriStr.replaceAll("^" + uri.getScheme() + "://(.*)@", uri.getScheme() + "://");
        return new URI(uriStr);
    }
}

