/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.io;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.io.TextSearchURIUtil;

public class TextSearchIOUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)TextSearchIOUtil.class.getName());

    public static File fileFromURI(URI uri) {
        File file;
        try {
            file = new File(uri);
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not create a file from the uri: " + TextSearchURIUtil.maskPasswords(String.valueOf(uri)) + " because: " + e, (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Path is " + TextSearchURIUtil.maskPasswords(String.valueOf(uri.getPath())));
            }
            file = new File(uri.getPath());
        }
        return file;
    }

    public static String readFully(Reader reader) throws IOException {
        StringBuilder val = new StringBuilder();
        char[] buff = new char[512];
        int r = reader.read(buff);
        while (r > 0) {
            val.append(buff, 0, r);
            r = reader.read(buff);
        }
        return val.toString();
    }

    public static void deleteDir(File dir) throws IOException {
        boolean deleted;
        File[] listFiles;
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting Dir " + TextSearchURIUtil.maskPasswords(String.valueOf(dir)));
        }
        if ((listFiles = dir.listFiles()) != null) {
            for (File file : listFiles) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Deleting  " + TextSearchURIUtil.maskPasswords(String.valueOf(file)));
                }
                if (file.isDirectory()) {
                    TextSearchIOUtil.deleteDir(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new IOException("Could not delete file " + file);
            }
        }
        boolean bl = deleted = !dir.exists() || dir.delete();
        if (!deleted) {
            throw new IOException("Could not delete directory " + dir);
        }
    }

    public static String extractFileName(String path) {
        return TextSearchIOUtil.extractFileName(path, true);
    }

    public static String extractFileName(String path, boolean removeAnchors) {
        int index;
        if (path == null) {
            return null;
        }
        String fileName = null;
        if (removeAnchors) {
            path = TextSearchIOUtil.removeQueryOrAnchorFromName(path);
        }
        if ((index = path.lastIndexOf(47)) == -1) {
            index = path.lastIndexOf(92);
        }
        fileName = index != -1 ? path.substring(index + 1) : path;
        return fileName;
    }

    public static String removeQueryOrAnchorFromName(String name) {
        if (name != null) {
            int queryIndex = name.indexOf("?");
            if (queryIndex != -1) {
                name = name.substring(0, queryIndex);
            } else {
                int anchorIndex = name.indexOf("#");
                if (anchorIndex != -1) {
                    name = name.substring(0, anchorIndex);
                }
            }
        }
        return name;
    }
}

