/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.highlighter;

import org.apache.lucene.search.highlight.Encoder;

public class HTMLEncoder
implements Encoder {
    public String encodeText(String originalText) {
        return HTMLEncoder.htmlEncode(originalText);
    }

    public static final String htmlEncode(String plainText) {
        String ret = "";
        if (plainText != null) {
            StringBuilder result = HTMLEncoder.htmlEncodeIntoStringBuilder(plainText);
            ret = result == null ? plainText : result.toString();
        }
        return ret;
    }

    private static StringBuilder htmlEncodeIntoStringBuilder(String plainText) {
        StringBuilder result = null;
        int len = plainText.length();
        block8: for (int i = 0; i < len; ++i) {
            char ch = plainText.charAt(i);
            if (result == null && ch >= 'A') continue;
            switch (ch) {
                case '\"': {
                    result = HTMLEncoder.append(result, "&quot;", plainText, i);
                    continue block8;
                }
                case '&': {
                    result = HTMLEncoder.append(result, "&amp;", plainText, i);
                    continue block8;
                }
                case '<': {
                    result = HTMLEncoder.append(result, "&lt;", plainText, i);
                    continue block8;
                }
                case '>': {
                    result = HTMLEncoder.append(result, "&gt;", plainText, i);
                    continue block8;
                }
                case '\'': {
                    result = HTMLEncoder.append(result, "&#x27;", plainText, i);
                    continue block8;
                }
                case '/': {
                    result = HTMLEncoder.append(result, "&#x2F;", plainText, i);
                    continue block8;
                }
                default: {
                    if (result == null) continue block8;
                    result.append(ch);
                }
            }
        }
        return result;
    }

    private static StringBuilder append(StringBuilder result, String string, String plainText, int index) {
        if (result == null) {
            result = new StringBuilder();
            result.append(plainText, 0, index);
        }
        result.append(string);
        return result;
    }
}

