/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.completion.CompletionDumper;
import ro.sync.textsearch.completion.CompletionEngineUtil;
import ro.sync.textsearch.completion.CompletionOptions;
import ro.sync.textsearch.completion.CompletionWhitespaceAnalyzer;
import ro.sync.textsearch.completion.ScoredCompletion;

public final class WordCompletionEngine {
    private static final Logger logger = LoggerFactory.getLogger(WordCompletionEngine.class);
    private IndexSearcher searcher;
    private Analyzer searchingAnalyzer;

    public WordCompletionEngine(IndexSearcher searcher, Analyzer searchingAnalyzer) {
        this.searcher = searcher;
        this.searchingAnalyzer = searchingAnalyzer;
    }

    public List<ScoredCompletion> getCompletions(String prefix, CompletionOptions completionOptions) throws IOException {
        List<ScoredCompletion> contentCompletions = new ArrayList<ScoredCompletion>();
        if (prefix != null && prefix.length() > completionOptions.getMinimumPrefixSize()) {
            try (AnalyzingInfixSuggester infixSuggester = new AnalyzingInfixSuggester((Directory)new ByteBuffersDirectory(), (Analyzer)new CompletionWhitespaceAnalyzer());){
                contentCompletions.addAll(this.getCompletionsFromField(prefix, completionOptions, (Lookup)infixSuggester, "__lc_title_completion_terms__"));
                contentCompletions.addAll(this.getCompletionsFromField(prefix, completionOptions, (Lookup)infixSuggester, "__lc_completion_terms__"));
            }
        }
        if (contentCompletions.size() > completionOptions.getMaximumNumberOfCompletions()) {
            contentCompletions = contentCompletions.subList(0, completionOptions.getMaximumNumberOfCompletions());
        }
        CompletionDumper.dumpCompletions(logger, "Scored completions", contentCompletions);
        return contentCompletions;
    }

    private List<ScoredCompletion> getCompletionsFromField(String prefix, CompletionOptions completionOptions, Lookup suggester, String fieldName) throws IOException {
        Pattern checkPattern = Pattern.compile("[^a-zA-Z0-9]");
        ArrayList<ScoredCompletion> foundCompletions = new ArrayList<ScoredCompletion>();
        LuceneDictionary dictionary = new LuceneDictionary(this.searcher.getIndexReader(), fieldName);
        suggester.build((Dictionary)dictionary);
        List lookup = suggester.lookup((CharSequence)prefix, true, completionOptions.getMaximumNumberOfCompletions());
        for (Lookup.LookupResult lookupResult : lookup) {
            List<String> tokens;
            boolean hasSpecialChars;
            String result = lookupResult.key.toString();
            if (result.equals(prefix.trim())) continue;
            if (result.contains(prefix)) {
                result = result.substring(result.indexOf(prefix) + prefix.length());
            }
            if ((hasSpecialChars = checkPattern.matcher(result).find()) || (tokens = CompletionEngineUtil.tokenizeString(result, this.searchingAnalyzer)).isEmpty()) continue;
            foundCompletions.add(new ScoredCompletion(lookupResult.value, tokens, true));
        }
        return foundCompletions;
    }
}

