/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.spans.SpanScorer;
import org.apache.lucene.queries.spans.Spans;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class SpanPositionsCollector
implements Collector {
    private LinkedHashMap<Integer, List<Integer>> spansEndPositionsMap = new LinkedHashMap();

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafCollector getLeafCollector(final LeafReaderContext context) throws IOException {
        return new LeafCollector(){
            private Scorable scorer;

            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
                if (!(scorer instanceof SpanScorer)) {
                    throw new IllegalStateException("The scorer must be a span scorer.");
                }
            }

            public void collect(int doc) throws IOException {
                int absoluteDocId = doc + context.docBase;
                List spansForDoc = SpanPositionsCollector.this.spansEndPositionsMap.computeIfAbsent(absoluteDocId, k -> new ArrayList(2));
                Spans spans = ((SpanScorer)this.scorer).getSpans();
                while (spans.nextStartPosition() != Integer.MAX_VALUE) {
                    int ep = spans.endPosition();
                    spansForDoc.add(ep);
                }
            }
        };
    }

    public LinkedHashMap<Integer, List<Integer>> getSpansEndPositionsMap() {
        return this.spansEndPositionsMap;
    }
}

