/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.IndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.completion.Completion;
import ro.sync.textsearch.completion.CompletionExtractor;
import ro.sync.textsearch.completion.ContentReconstructor;
import ro.sync.textsearch.completion.RawCompletion;

public class CompletionExtractorUsingStringArray
extends CompletionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CompletionExtractorUsingStringArray.class);
    private String searchFieldName;

    public CompletionExtractorUsingStringArray(String searchFieldName, IndexSearcher searcher, int maximumCompletionSize) {
        super(searcher, maximumCompletionSize);
        this.searchFieldName = searchFieldName;
    }

    @Override
    protected List<Completion> getCompletionsFromDocumentInternal(int docId, List<Integer> endsOfSpans) throws IOException {
        String documentUri = this.getURI(docId);
        logger.debug("Getting completions from {} {}", (Object)docId, (Object)documentUri);
        ArrayList<Completion> completions = new ArrayList<Completion>(endsOfSpans.size());
        ContentReconstructor reconstructor = new ContentReconstructor(this.searchFieldName, this.searcher);
        String[] docTokens = reconstructor.reconstructDocument(docId);
        if (docTokens != null) {
            for (Integer endIndex : endsOfSpans) {
                int completionEndIndex = this.getCompletionEndIndex(docTokens.length, endIndex);
                int completionSize = completionEndIndex - endIndex;
                if (completionSize <= 0) continue;
                String[] completionTokens = new String[completionSize];
                int j = 0;
                for (int i = endIndex.intValue(); i < completionEndIndex; ++i) {
                    completionTokens[j++] = docTokens[i];
                }
                RawCompletion completion = new RawCompletion(documentUri, completionTokens);
                completions.add(completion);
            }
        }
        return completions;
    }
}

