/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.util.ArrayList;
import java.util.regex.Pattern;
import ro.sync.textsearch.util.RegExpUtil;

public class IgnoreHandler {
    private ArrayList<Pattern> patterns;

    public IgnoreHandler(String ignorePatterns) {
        if (ignorePatterns != null) {
            String[] split = ignorePatterns.split(",");
            this.patterns = new ArrayList();
            for (int i = 0; i < split.length; ++i) {
                split[i] = split[i].trim();
                if (split[i].length() <= 0) continue;
                String regex = RegExpUtil.convertWildcardToRegexp(split[i], true);
                this.patterns.add(Pattern.compile(regex));
            }
        } else {
            this.patterns = null;
        }
    }

    public boolean isIgnored(String uri) {
        boolean isIgnored = false;
        if (this.patterns != null) {
            for (Pattern p : this.patterns) {
                if (!p.matcher(uri).matches()) continue;
                isIgnored = true;
            }
        }
        return isIgnored;
    }
}

