/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.md.backmapping;

import com.oxygenxml.md.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionContextProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConversionContextProvider.class.getName());
    private final ThreadLocal<ConversionContext> systemIDTL = new ThreadLocal();
    private static ConversionContextProvider instance;

    private ConversionContextProvider() {
    }

    public void set(ConversionContext context) {
        this.systemIDTL.set(context);
    }

    public ConversionContext get() {
        ConversionContext conversionContext = this.systemIDTL.get();
        LOGGER.debug("Context: {}", (Object)conversionContext);
        return conversionContext;
    }

    public void remove() {
        this.systemIDTL.remove();
    }

    public static synchronized ConversionContextProvider getInstance() {
        if (instance == null) {
            instance = new ConversionContextProvider();
        }
        return instance;
    }

    public static void setInstanceFromTests(ConversionContextProvider instance) {
        ConversionContextProvider.instance = instance;
    }

    public static final class ConversionContext {
        public final boolean embedBackmappingData;
        public final String systemID;

        public ConversionContext(boolean embedBackmappingData, String systemID) {
            this.embedBackmappingData = embedBackmappingData;
            this.systemID = systemID;
        }

        public String toString() {
            return "embedBackmappingData: " + this.embedBackmappingData + ", systemID: " + URLUtil.filterPasswords(this.systemID);
        }
    }
}

