/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.ant.handlers;

import java.util.Stack;
import org.xml.sax.Attributes;
import ro.sync.exml.validate.external.ant.handlers.AntContextElement;

public class AntContext {
    private final Stack<AntContextElement> contextStack = new Stack();

    public void startElement(String localName, Attributes attrs) {
        this.contextStack.push(new AntContextElement(localName, attrs));
    }

    public void endElement(String localName) {
        AntContextElement topElement = this.contextStack.peek();
        if (topElement != null) {
            if (localName.equals(topElement.getLocalName())) {
                this.contextStack.pop();
            } else {
                int index;
                boolean found = false;
                for (index = this.getLevel() - 2; index >= 0 && !found; --index) {
                    AntContextElement element = (AntContextElement)this.contextStack.get(index);
                    if (element == null || !localName.equals(element.getLocalName())) continue;
                    found = true;
                    break;
                }
                if (found && index >= 0) {
                    this.contextStack.setSize(index);
                }
            }
        }
    }

    public int getLevel() {
        return this.contextStack.size();
    }

    public void clear() {
        this.contextStack.clear();
    }

    public boolean isInAntcall() {
        return this.getLevel() > 1 && "antcall".equals(((AntContextElement)this.contextStack.get(this.getLevel() - 2)).getLocalName());
    }
}

