/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.ant.handlers;

import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.exml.ant.core.project.AntProject;
import ro.sync.exml.validate.external.ant.handlers.AntContext;
import ro.sync.exml.validate.external.ant.handlers.Location;
import ro.sync.exml.validate.external.ant.handlers.TargetsReferencesCollector;

public class AdditionalContentHandler
extends DefaultHandler {
    AntContext context = new AntContext();
    private Locator locator;
    private final AntProject project;
    private final TargetsReferencesCollector targetsReferencesCollector;

    public AdditionalContentHandler(AntProject project, TargetsReferencesCollector targetsReferencesCollector) {
        this.project = project;
        this.targetsReferencesCollector = targetsReferencesCollector;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.context.clear();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String dependsAttr;
        this.context.startElement(localName, atts);
        if (this.context.getLevel() == 1 && "project".equals(localName)) {
            String defaultTarget;
            if (!this.isInImports() && (defaultTarget = atts.getValue("default")) != null) {
                TargetsReferencesCollector.TargetReference defaultTargetReference = new TargetsReferencesCollector.TargetReference(defaultTarget, TargetsReferencesCollector.TargetRefType.DEFAULT, "default", defaultTarget, 0, new Location(this.locator));
                this.targetsReferencesCollector.setDefaultTargetReference(defaultTargetReference);
            }
        } else if (this.context.getLevel() > 1 && "antcall".equals(localName)) {
            String target = atts.getValue("target");
            if (target != null) {
                TargetsReferencesCollector.TargetReference targetReference = new TargetsReferencesCollector.TargetReference(target, TargetsReferencesCollector.TargetRefType.ANTCALL, "target", target, 0, new Location(this.locator));
                this.targetsReferencesCollector.addTargetReference(targetReference);
            }
        } else if (this.context.isInAntcall() && "target".equals(localName)) {
            String target = atts.getValue("name");
            if (target != null) {
                TargetsReferencesCollector.TargetReference targetReference = new TargetsReferencesCollector.TargetReference(target, TargetsReferencesCollector.TargetRefType.ANTCALL_NESTED, "name", target, 0, new Location(this.locator));
                this.targetsReferencesCollector.addTargetReference(targetReference);
            }
        } else if (("target".equals(localName) || "extension-point".equals(localName)) && (dependsAttr = atts.getValue("depends")) != null) {
            int index = 0;
            String[] dependsList = dependsAttr.split(",");
            if (dependsList != null) {
                for (String dependency : dependsList) {
                    String targetName = dependency.trim();
                    if (!targetName.isEmpty()) {
                        int delta = dependency.indexOf(targetName);
                        TargetsReferencesCollector.TargetReference targetReference = new TargetsReferencesCollector.TargetReference(targetName, TargetsReferencesCollector.TargetRefType.DEPENDS, "depends", dependsAttr, index + delta, new Location(this.locator));
                        this.targetsReferencesCollector.addTargetReference(targetReference);
                    }
                    index += dependency.length() + 1;
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.context.endElement(localName);
    }

    private boolean isInImports() {
        return this.project.getProjectHandler().isInImports();
    }
}

