/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.sync.exml.ant.core.project.AntProjectHandler;
import ro.sync.exml.ant.core.util.AntUtil;
import ro.sync.exml.validate.external.api.ValidationException;
import ro.sync.exml.validate.external.api.ValidationSeverity;

public class ValidationProjectHandler
extends AntProjectHandler {
    private final List<ValidationException> exceptions = new ArrayList<ValidationException>();

    public ValidationProjectHandler(String initialSystemID) {
        super(initialSystemID);
    }

    public void error(Exception e) {
        this.exceptions.add(this.getValidationException(e));
    }

    private ValidationException getValidationException(Exception e) {
        ValidationException validationException;
        if (e instanceof ValidationException) {
            validationException = (ValidationException)e;
        } else {
            String message = e.getMessage();
            String systemID = null;
            int lineNumber = -1;
            int colNumber = -1;
            if (e instanceof SAXParseException) {
                SAXParseException saxParseException = (SAXParseException)e;
                systemID = saxParseException.getSystemId();
                lineNumber = saxParseException.getLineNumber();
                colNumber = saxParseException.getColumnNumber();
                e = saxParseException.getException();
            } else if (e instanceof SAXException) {
                e = ((SAXException)e).getException();
            }
            if (e instanceof BuildException) {
                BuildException buildException = (BuildException)((Object)e);
                message = e.getMessage();
                Location exLocation = buildException.getLocation();
                if (exLocation != null && exLocation != Location.UNKNOWN_LOCATION) {
                    systemID = AntUtil.getSystemID((Location)exLocation);
                    lineNumber = exLocation.getLineNumber();
                    colNumber = exLocation.getColumnNumber();
                }
            }
            if (systemID == null) {
                systemID = this.getSystemID();
            }
            validationException = new ValidationException(message, systemID, ValidationSeverity.ERROR, (Throwable)e);
            validationException.setLineNumber(lineNumber);
            validationException.setColumnNumber(colNumber);
        }
        return validationException;
    }

    public List<ValidationException> getExceptions() {
        return this.exceptions;
    }
}

