/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.ant;

import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.URIResolver;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelperRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.ant.core.project.AntParserInput;
import ro.sync.exml.ant.core.project.AntProject;
import ro.sync.exml.ant.core.project.AntProjectHandler;
import ro.sync.exml.ant.core.project.AntProjectHelper;
import ro.sync.exml.ant.core.util.AntUtil;
import ro.sync.exml.validate.external.ant.AntValidationProject;
import ro.sync.exml.validate.external.api.ExternalValidator;
import ro.sync.exml.validate.external.api.ValidationException;

public class AntValidator
implements ExternalValidator {
    private static final Logger logger = LoggerFactory.getLogger((String)AntValidator.class.getName());

    public List<ValidationException> validate(Reader reader, String systemID, URIResolver uriResolver, Map<String, String> additionalProperties) {
        AntValidationProject project = new AntValidationProject(systemID, uriResolver);
        if (additionalProperties != null) {
            Set<Map.Entry<String, String>> entries = additionalProperties.entrySet();
            for (Map.Entry<String, String> property : entries) {
                project.setProperty(property.getKey(), property.getValue());
            }
        }
        AntProjectHandler projectHandler = project.getProjectHandler();
        AntProjectHelper helper = new AntProjectHelper();
        try {
            AntUtil.prepareProject((AntProject)project, (String)systemID, (AntProjectHelper)helper);
            helper.parse((Project)project, (Object)new AntParserInput(reader, systemID));
        }
        catch (BuildException e) {
            projectHandler.error((Exception)((Object)e));
        }
        project.checkTargetReferences();
        return project.getExceptions();
    }

    static {
        try {
            ProjectHelperRepository projectHelperRepository = ProjectHelperRepository.getInstance();
            Iterator helpers = projectHelperRepository.getHelpers();
            if (helpers != null && helpers.hasNext() && !(helpers.next() instanceof AntProjectHelper)) {
                projectHelperRepository.registerProjectHelper(AntProjectHelper.class);
            }
        }
        catch (Exception e) {
            logger.error("Could not register project helper class! " + e.getMessage());
        }
    }
}

