/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.ant;

import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.xml.transform.URIResolver;
import ro.sync.exml.ant.core.project.AntProject;
import ro.sync.exml.ant.core.project.AntProjectHandler;
import ro.sync.exml.ant.core.project.handlers.AntHandlersFactory;
import ro.sync.exml.validate.external.ant.ValidationProjectHandler;
import ro.sync.exml.validate.external.ant.handlers.Location;
import ro.sync.exml.validate.external.ant.handlers.TargetsReferencesCollector;
import ro.sync.exml.validate.external.ant.handlers.ValidationHandlersFactory;
import ro.sync.exml.validate.external.api.ValidationException;
import ro.sync.exml.validate.external.api.ValidationSeverity;
import ro.sync.exml.validate.external.api.quickfix.ComponentQuickFixInfo;
import ro.sync.exml.validate.external.api.quickfix.InsertPosition;

public class AntValidationProject
extends AntProject {
    private TargetsReferencesCollector targetsReferencesCollector;

    public AntValidationProject(String initialSystemID, URIResolver uriResolver) {
        super(initialSystemID, uriResolver);
    }

    protected AntProjectHandler createHandler(String initialSystemID) {
        return new ValidationProjectHandler(initialSystemID);
    }

    public List<ValidationException> getExceptions() {
        return ((ValidationProjectHandler)this.getProjectHandler()).getExceptions();
    }

    protected AntHandlersFactory createHandlersFactory() {
        this.targetsReferencesCollector = new TargetsReferencesCollector();
        return new ValidationHandlersFactory(this.targetsReferencesCollector);
    }

    public void checkTargetReferences() {
        String defaultTarget;
        Hashtable targets = this.getTargets();
        Set targetNames = targets.keySet();
        TargetsReferencesCollector.TargetReference defaultTargetReference = this.targetsReferencesCollector.getDefaultTargetReference();
        if (defaultTargetReference != null && !targetNames.contains(defaultTarget = defaultTargetReference.getTargetName())) {
            Location defaultTargetLocation = defaultTargetReference.getLocation();
            ValidationException exception = new ValidationException("The default target '" + defaultTarget + "' does not exist in this project.", defaultTargetLocation.getSystemID(), ValidationSeverity.ERROR, null);
            exception.setLineNumber(defaultTargetLocation.getLine());
            exception.setColumnNumber(defaultTargetLocation.getColumn());
            exception.setComponentQuickFixInfo(new ComponentQuickFixInfo(defaultTarget, "default", defaultTarget, 0, InsertPosition.AS_LAST_CHILD, targetNames));
            this.getProjectHandler().error((Exception)exception);
        }
        List<TargetsReferencesCollector.TargetReference> targetReferences = this.targetsReferencesCollector.getTargetReferences();
        for (TargetsReferencesCollector.TargetReference targetReference : targetReferences) {
            String targetName = targetReference.getTargetName();
            if (targetNames.contains(targetName)) continue;
            Location location = targetReference.getLocation();
            ValidationException exception = new ValidationException("The referred '" + targetName + "' target/extension-point does not exist in this project.", location.getSystemID(), ValidationSeverity.ERROR, null);
            exception.setLineNumber(location.getLine());
            exception.setColumnNumber(location.getColumn());
            InsertPosition insertPosition = InsertPosition.AFTER;
            switch (targetReference.getType()) {
                case DEPENDS: {
                    insertPosition = InsertPosition.AFTER;
                    break;
                }
                case ANTCALL: 
                case ANTCALL_NESTED: {
                    insertPosition = InsertPosition.AFTER_FIRST_LEVEL_ELEM;
                    break;
                }
                default: {
                    insertPosition = InsertPosition.AFTER;
                }
            }
            exception.setComponentQuickFixInfo(new ComponentQuickFixInfo(targetName, targetReference.getAttributeName(), targetReference.getAttributeValue(), targetReference.getReferenceIndex(), insertPosition, targetNames));
            this.getProjectHandler().error((Exception)exception);
        }
    }
}

