/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.jats;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.ImageFileChooser;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class InsertGraphicOperation
implements AuthorOperation {
    private static final String ARGUMENT_REFERENCE_VALUE = "imageUrl";

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        String ref = (String)args.getArgumentValue(ARGUMENT_REFERENCE_VALUE);
        if (ref == null) {
            ref = ImageFileChooser.chooseImageFile((AuthorAccess)authorAccess);
        }
        if (ref != null) {
            InsertGraphicOperation.insertImageRef(authorAccess, ref);
        }
    }

    public static SchemaAwareHandlerResult insertImageRef(AuthorAccess authorAccess, String ref) throws AuthorOperationException {
        SchemaAwareHandlerResult result = null;
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        boolean insertImageRef = true;
        try {
            AuthorElement elementAtOffset;
            AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            if (nodeAtOffset.getType() == 0 && ("graphic".equals((elementAtOffset = (AuthorElement)nodeAtOffset).getLocalName()) || "inline-graphic".equals(elementAtOffset.getLocalName()))) {
                authorAccess.getDocumentController().setAttribute("xlink:href", new AttrValue(ref), elementAtOffset);
                insertImageRef = false;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (insertImageRef) {
            String inlineGraphFrag = InsertGraphicOperation.createFragmentToInsert(ref, "inline-graphic");
            AuthorDocumentFragment frag = authorAccess.getDocumentController().createNewDocumentFragmentInContext(inlineGraphFrag, caretOffset);
            if (frag != null && authorAccess.getDocumentController().getAuthorSchemaManager().canInsertDocumentFragment(frag, caretOffset, (short)1)) {
                result = authorAccess.getDocumentController().insertFragmentSchemaAware(caretOffset, frag);
            } else {
                String graphicFrag = InsertGraphicOperation.createFragmentToInsert(ref, "graphic");
                result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(graphicFrag, caretOffset);
            }
        }
        return result;
    }

    private static String createFragmentToInsert(String ref, String elemName) {
        StringBuffer fragment = new StringBuffer();
        fragment.append("<" + elemName + " ");
        fragment.append("xmlns:xlink=\"http://www.w3.org/1999/xlink\" ");
        fragment.append("xlink:href=\"");
        fragment.append(ref);
        fragment.append("\">");
        fragment.append("</" + elemName + ">");
        return fragment.toString();
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Insert a JATS image";
    }
}

