/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.sapling.SaplingElement;
import net.sf.saxon.sapling.SaplingNode;
import net.sf.saxon.sapling.SaplingText;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class SQLQuery
extends ExtensionInstruction {
    Expression connection;
    Expression column;
    Expression table;
    Expression where;
    String rowTag;
    String colTag;
    boolean disable = false;

    protected void prepareAttributes() {
        String disableAtt;
        AttributeMap atts = this.attributes();
        AttributeInfo dbCol = atts.get(NamespaceUri.NULL, "column");
        if (dbCol == null) {
            this.reportAbsence("column");
        } else {
            this.column = this.makeAttributeValueTemplate(dbCol.getValue(), dbCol);
        }
        AttributeInfo dbTab = atts.get(NamespaceUri.NULL, "table");
        if (dbTab == null) {
            this.reportAbsence("table");
            this.table = new StringLiteral("saxon-dummy-table");
        } else {
            this.table = this.makeAttributeValueTemplate(dbTab.getValue(), dbTab);
        }
        AttributeInfo dbWhere = atts.get(NamespaceUri.NULL, "where");
        this.where = dbWhere == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(dbWhere.getValue(), dbWhere);
        AttributeInfo connectAtt = atts.get(NamespaceUri.NULL, "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt.getValue(), connectAtt);
        }
        this.rowTag = this.getAttributeValue(NamespaceUri.NULL, "row-tag");
        if (this.rowTag == null) {
            this.rowTag = "#auto";
        }
        if (!"#auto".equals(this.rowTag) && !NameChecker.isValidNCName((String)this.rowTag)) {
            this.compileError("row-tag must not contain a colon");
        }
        this.colTag = this.getAttributeValue(NamespaceUri.NULL, "column-tag");
        if (this.colTag == null) {
            this.colTag = "#auto";
        }
        if (!"#auto".equals(this.colTag) && !NameChecker.isValidNCName((String)this.colTag)) {
            this.compileError("column-tag must be a valid NCName");
        }
        if ((disableAtt = this.getAttributeValue(NamespaceUri.NULL, "disable-output-escaping")) != null) {
            switch (disableAtt) {
                case "yes": {
                    this.disable = true;
                    break;
                }
                case "no": {
                    this.disable = false;
                    break;
                }
                default: {
                    this.compileError("disable-output-escaping attribute must be either yes or no");
                }
            }
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        super.validate(decl);
        this.column = this.typeCheck("column", this.column);
        this.table = this.typeCheck("table", this.table);
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new QueryInstruction(this.connection, this.column, this.table, this.where, this.rowTag, this.colTag, this.disable);
    }

    private static class QueryInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int COLUMN = 1;
        public static final int TABLE = 2;
        public static final int WHERE = 3;
        String rowTag;
        String colTag;
        int options = 0;

        public QueryInstruction(Expression connection, Expression column, Expression table, Expression where, String rowTag, String colTag, boolean disable) {
            Expression[] sub = new Expression[]{connection, column, table, where};
            this.setArguments(sub);
            this.rowTag = rowTag;
            this.colTag = colTag;
            this.options = disable ? 1 : 0;
        }

        private QueryInstruction() {
        }

        public int getImplementationMethod() {
            return 4;
        }

        public String getExpressionType() {
            return "sql:query";
        }

        public Expression copy(RebindingMap rebindings) {
            QueryInstruction qi2 = new QueryInstruction();
            qi2.copyOperandsFrom(this);
            qi2.rowTag = this.rowTag;
            qi2.colTag = this.colTag;
            qi2.options = this.options;
            return qi2;
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            boolean wasDEThrown;
            SequenceExtent.Of of;
            Controller controller = context.getController();
            Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
            String dbCol = arguments[1].head().getStringValue();
            String dbTab = arguments[2].head().getStringValue();
            String dbWhere = arguments[3].head().getStringValue();
            HashSet<String> validNames = new HashSet<String>();
            QName rowCode = this.rowTag.equals("#auto") ? (NameChecker.isValidNCName((String)dbTab) ? new QName(dbTab) : new QName("row")) : new QName(this.rowTag);
            QName colCode = "#auto".equals(this.colTag) ? null : new QName(this.colTag);
            Statement ps = null;
            ResultSet rs = null;
            XPathException de = null;
            try {
                StringBuilder statement = new StringBuilder();
                statement.append("SELECT ").append(dbCol).append(" FROM ").append(dbTab);
                if (!dbWhere.equals("")) {
                    statement.append(" WHERE ").append(dbWhere);
                }
                ps = connection.prepareStatement(statement.toString());
                controller.setUserData((Object)this.getLocation(), "sql:statement", (Object)ps);
                rs = ps.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                String result = "";
                int icol = rs.getMetaData().getColumnCount();
                ArrayList<NodeInfo> resultElements = new ArrayList<NodeInfo>();
                while (rs.next()) {
                    SaplingElement rowElem = new SaplingElement(rowCode);
                    for (int col = 1; col <= icol; ++col) {
                        result = rs.getString(col);
                        QName colName = colCode;
                        String sqlName = null;
                        boolean nameOK = false;
                        if (colName == null) {
                            sqlName = metaData.getColumnName(col);
                            if (validNames.contains(sqlName)) {
                                nameOK = true;
                            } else if (NameChecker.isValidNCName((String)sqlName)) {
                                nameOK = true;
                                validNames.add(sqlName);
                            }
                            colName = nameOK ? new QName(sqlName) : new QName("col");
                        } else {
                            nameOK = true;
                        }
                        SaplingElement colElem = new SaplingElement(colName);
                        if (sqlName != null && !nameOK) {
                            colElem = colElem.withAttr("name", sqlName);
                        }
                        if (result != null) {
                            colElem = colElem.withChild(new SaplingNode[]{new SaplingText(result)});
                        }
                        rowElem = rowElem.withChild(new SaplingNode[]{colElem});
                    }
                    resultElements.add(rowElem.toNodeInfo(this.getConfiguration()));
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                of = new SequenceExtent.Of(resultElements);
                boolean bl = wasDEThrown = de != null;
            }
            catch (SQLException ex) {
                try {
                    throw new XPathException("(SQL) " + ex.getMessage()).withXPathContext(context);
                }
                catch (Throwable throwable) {
                    boolean wasDEThrown2;
                    boolean bl = wasDEThrown2 = de != null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ex2) {
                            de = new XPathException("(SQL) " + ex2.getMessage()).withXPathContext(context);
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException ex3) {
                            de = new XPathException("(SQL) " + ex3.getMessage()).withXPathContext(context);
                        }
                    }
                    if (!wasDEThrown2 && de != null) {
                        throw de;
                    }
                    throw throwable;
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    de = new XPathException("(SQL) " + ex.getMessage()).withXPathContext(context);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {
                    de = new XPathException("(SQL) " + ex.getMessage()).withXPathContext(context);
                }
            }
            if (!wasDEThrown && de != null) {
                throw de;
            }
            return of;
        }
    }
}

