/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class SQLExecute
extends ExtensionInstruction {
    Expression connection;
    Expression statement;

    protected void prepareAttributes() {
        AttributeMap atts = this.attributes();
        AttributeInfo statementAtt = atts.get(NamespaceUri.NULL, "statement");
        if (statementAtt == null) {
            this.reportAbsence("statement");
        } else {
            this.statement = this.makeAttributeValueTemplate(statementAtt.getValue(), statementAtt);
        }
        AttributeInfo connectAtt = atts.get(NamespaceUri.NULL, "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt.getValue(), connectAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        super.validate(decl);
        this.statement = this.typeCheck("statement", this.statement);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new SqlStatementInstruction(this.connection, this.statement);
    }

    private static class SqlStatementInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int STATEMENT = 1;

        public SqlStatementInstruction(Expression connection, Expression statement) {
            Expression[] sub = new Expression[]{connection, statement};
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 4;
        }

        public String getExpressionType() {
            return "sql:statement";
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
            String statementText = arguments[1].head().getStringValue();
            try {
                switch (statementText) {
                    case "COMMIT WORK": {
                        connection.commit();
                        break;
                    }
                    case "ROLLBACK WORK": {
                        connection.rollback();
                        break;
                    }
                    default: {
                        Statement s = connection.createStatement();
                        s.execute(statementText);
                        s.close();
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                throw new XPathException("(SQL) " + ex.getMessage()).withXPathContext(context);
            }
            return EmptySequence.getInstance();
        }
    }
}

