/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.option.sql.SQLConnect;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SQLDelete
extends ExtensionInstruction {
    Expression connection;
    String table;
    Expression where;

    protected void prepareAttributes() {
        AttributeMap atts = this.attributes();
        this.table = atts.getValue(NamespaceUri.NULL, "table");
        if (this.table == null) {
            this.reportAbsence("table");
            this.table = "saxon-error-table";
        }
        this.table = SQLConnect.quoteSqlName(this.table);
        AttributeInfo dbWhere = atts.get(NamespaceUri.NULL, "where");
        this.where = dbWhere == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(dbWhere.getValue(), dbWhere);
        AttributeInfo connectAtt = atts.get(NamespaceUri.NULL, "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt.getValue(), connectAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        super.validate(decl);
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new DeleteInstruction(this.connection, "DELETE FROM " + this.table, this.where);
    }

    private static class DeleteInstruction
    extends SimpleExpression {
        private static final long serialVersionUID = -4234440812734827279L;
        public static final int CONNECTION = 0;
        public static final int WHERE = 1;
        String statement;

        public DeleteInstruction(Expression connection, String statement, Expression where) {
            Expression[] sub = new Expression[]{connection, where};
            this.statement = statement;
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:delete";
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
            String dbWhere = arguments[1].head().getStringValue();
            String localstmt = this.statement;
            if (!dbWhere.equals("")) {
                localstmt = localstmt + " WHERE " + dbWhere;
            }
            try (PreparedStatement ps = connection.prepareStatement(localstmt);){
                ps.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException ex) {
                this.dynamicError("SQL DELETE failed: " + ex.getMessage(), "SXSQ0004", context);
            }
            return EmptyAtomicSequence.getInstance();
        }
    }
}

