/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public class SQLTable
implements Sequence {
    private final Connection connection;
    private final String tableName;
    private final XPathContext context;

    SQLTable(Connection connection, String tableName, XPathContext context) {
        this.connection = connection;
        this.tableName = tableName;
        this.context = context;
    }

    public MapItem head() throws XPathException {
        return (MapItem)this.iterate().next();
    }

    public SequenceIterator iterate() {
        Statement ps = null;
        try {
            StringBuilder statement = new StringBuilder();
            statement.append("SELECT * FROM ").append(this.tableName);
            try {
                ps = this.connection.prepareStatement(statement.toString());
            }
            catch (SQLException e) {
                XPathException xpe = new XPathException("sql:table() failed: " + e.getMessage() + " Failed to prepare query {" + statement + '}', "SXSQ0004", this.context);
                throw new UncheckedXPathException(xpe);
            }
            ResultSet rs = ps.executeQuery();
            List<MapItem> out = SQLFunctionSet.sqlQueryResult(rs);
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
            ListIterator.Of of = new ZeroOrMore(out).iterate();
            return of;
        }
        catch (SQLException ex) {
            XPathException xpe2 = new XPathException("Failed to materialize sql:table(): " + ex.getMessage(), "SXSQ0004", this.context);
            throw new UncheckedXPathException(xpe2);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

