/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LookupExpression;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class SQLPreparedQueryFn
extends SystemFunction {
    public FunctionItem call(XPathContext context, Sequence[] arguments) throws XPathException {
        Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
        String query = arguments[1].head().getStringValue();
        PreparedStatement ps = null;
        try {
            try {
                ps = connection.prepareStatement(query);
            }
            catch (SQLException e) {
                throw new XPathException("sql:prepared-query() failed: " + e.getMessage() + " Failed to prepare query {" + query + '}', "SXSQ0004", context);
            }
            PreparedStatement ps2 = ps;
            Callable callable = (context1, arguments1) -> {
                for (int i = 0; i < arguments1.length; ++i) {
                    SQLFunctionSet.setSqlStatementParam(ps2, i + 1, arguments1[i], context1);
                }
                try {
                    ResultSet rs = ps2.executeQuery();
                    List<MapItem> out = SQLFunctionSet.sqlQueryResult(rs);
                    return new ZeroOrMore(out);
                }
                catch (SQLException e) {
                    throw new XPathException("Failure executing prepared SQL query", (Throwable)e);
                }
            };
            ParameterMetaData metaData = ps2.getParameterMetaData();
            int arity = metaData.getParameterCount();
            SequenceType[] parameterTypes = new SequenceType[arity];
            SQLFunctionSet.supplyParameters(metaData, parameterTypes);
            SpecificFunctionType type = new SpecificFunctionType(parameterTypes, MapType.SEQUENCE_OF_MAPS);
            return new CallableFunction(arity, callable, (FunctionItemType)type);
        }
        catch (SQLException ex) {
            throw new XPathException("sql:prepared-query() failed: " + ex.getMessage(), "SXSQ0004", context);
        }
    }

    public static Expression makePreparedQueryFunction(String tableName, Expression predicate) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Expression> params = new ArrayList<Expression>();
        boolean ok = SQLPreparedQueryFn.makeWhereClause(predicate, sb, params);
        if (ok) {
            String query = "SELECT * FROM " + tableName + " WHERE " + sb.toString();
            Callable callable = new Callable(){

                public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                    return null;
                }
            };
            return null;
        }
        return null;
    }

    public static boolean makeWhereClause(Expression predicate, StringBuilder sb, List<Expression> params) {
        boolean ok = false;
        if (predicate instanceof AndExpression) {
            ok = SQLPreparedQueryFn.makeWhereClause(((AndExpression)predicate).getLhsExpression(), sb, params);
            if (ok) {
                sb.append(" AND ");
                ok = SQLPreparedQueryFn.makeWhereClause(((AndExpression)predicate).getRhsExpression(), sb, params);
            }
        } else if (predicate instanceof OrExpression) {
            ok = SQLPreparedQueryFn.makeWhereClause(((OrExpression)predicate).getLhsExpression(), sb, params);
            if (ok) {
                sb.append(" OR ");
                ok = SQLPreparedQueryFn.makeWhereClause(((OrExpression)predicate).getRhsExpression(), sb, params);
            }
        } else if (predicate.isCallOn(NotFn.class)) {
            sb.append(" NOT (");
            ok = SQLPreparedQueryFn.makeWhereClause(((SystemFunctionCall)predicate).getArg(0), sb, params);
            sb.append(")");
        } else if (predicate instanceof ValueComparison && (ok = SQLPreparedQueryFn.makeComparisonOperand(((ValueComparison)predicate).getLhsExpression(), sb, params))) {
            sb.append(SQLPreparedQueryFn.makeOperator(((ValueComparison)predicate).getOperator()));
            ok = SQLPreparedQueryFn.makeComparisonOperand(((ValueComparison)predicate).getRhsExpression(), sb, params);
        }
        return ok;
    }

    private static String makeOperator(int op) {
        switch (op) {
            case 50: {
                return "=";
            }
            case 51: {
                return "<>";
            }
            case 55: {
                return "<=";
            }
            case 53: {
                return "<";
            }
            case 54: {
                return ">=";
            }
            case 52: {
                return ">";
            }
        }
        return "###";
    }

    private static boolean makeComparisonOperand(Expression exp, StringBuilder sb, List<Expression> params) {
        LookupExpression lookup;
        if (exp instanceof Literal) {
            GroundedValue val = ((Literal)exp).getGroundedValue();
            if (val instanceof StringValue) {
                sb.append("'").append(((StringValue)val).getStringValue().replace("'", "\\'")).append("'");
                return true;
            }
            if (val instanceof NumericValue) {
                sb.append(((NumericValue)val).getUnicodeStringValue());
                return true;
            }
        }
        if (exp instanceof LookupExpression && (lookup = (LookupExpression)exp).getLhsExpression() instanceof ContextItemExpression && lookup.getRhsExpression() instanceof StringLiteral) {
            sb.append(((StringLiteral)lookup.getRhsExpression()).getString());
            return true;
        }
        sb.append(" ? ");
        params.add(exp);
        return true;
    }
}

