/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class SQLInsertFn
extends SystemFunction {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
        String tableName = arguments[1].head().getStringValue();
        MapItem columns = (MapItem)arguments[2].head();
        StringBuilder statement = new StringBuilder(120);
        statement.append("INSERT INTO ").append(tableName).append(" (");
        StringBuilder valList = new StringBuilder(120);
        ArrayList<AtomicValue> values = new ArrayList<AtomicValue>();
        int cols = 0;
        for (KeyValuePair kvp : columns.keyValuePairs()) {
            if (cols++ > 0) {
                statement.append(',');
                valList.append(',');
            }
            statement.append(kvp.key.getUnicodeStringValue());
            valList.append('?');
            AtomicSequence as = Atomizer.atomize((Sequence)kvp.value);
            if (as.getLength() != 1) {
                throw new XPathException("sql:insert - new value must be a singleton - actual length = " + as.getLength());
            }
            values.add(as.head());
        }
        statement.append(") VALUES (").append((CharSequence)valList).append(')');
        try (PreparedStatement ps = connection.prepareStatement(statement.toString());){
            ParameterMetaData metaData = ps.getParameterMetaData();
            int col = 1;
            for (AtomicValue v : values) {
                Object value;
                String parameterClassName = null;
                try {
                    parameterClassName = metaData.getParameterClassName(col);
                }
                catch (SQLException ex) {
                    parameterClassName = "java.lang.String";
                }
                switch (parameterClassName) {
                    case "java.lang.String": {
                        value = v.getStringValue();
                        break;
                    }
                    case "java.sql.Date": {
                        value = Date.valueOf(v.getStringValue());
                        break;
                    }
                    default: {
                        try {
                            Class<?> targetClass = Class.forName(parameterClassName);
                            PJConverter converter = PJConverter.allocate((Configuration)context.getConfiguration(), (ItemType)v.getPrimitiveType(), (int)16384, targetClass);
                            value = converter.convert((Sequence)v, targetClass, context);
                            break;
                        }
                        catch (ClassNotFoundException err) {
                            throw new XPathException("sql:insert() - cannot convert value to required class " + parameterClassName);
                        }
                    }
                }
                ps.setObject(col++, value);
            }
            ps.executeUpdate();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException ex) {
            throw new XPathException("sql:insert() failed: " + ex.getMessage(), "SXSQ0004", context);
        }
        return EmptySequence.getInstance();
    }
}

