/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import com.saxonica.functions.sql.SQLFunctionSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class SQLExecuteFn
extends SystemFunction {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Connection connection = SQLFunctionSet.expectConnection(arguments[0], context);
        String statementText = arguments[1].head().getStringValue();
        try {
            if ("COMMIT WORK".equals(statementText)) {
                connection.commit();
            } else if ("ROLLBACK WORK".equals(statementText)) {
                connection.rollback();
            } else {
                Statement s = connection.createStatement();
                s.execute(statementText);
                s.close();
            }
        }
        catch (SQLException ex) {
            throw new XPathException("sql:execute() failed: " + ex.getMessage()).withXPathContext(context);
        }
        return EmptySequence.getInstance();
    }
}

