/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dynamic.resources.converter;

import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiToDITAConverter;
import com.oxygenxml.batch.converter.core.extensions.ExtensionGetter;
import com.oxygenxml.dynamic.resources.converter.ConverterReader;
import java.util.Arrays;

public class OpenAPIConverterReader
extends ConverterReader {
    private static final String OPENAPI_TO_DITA_FORMAT = "openapi-to-dita";

    public OpenAPIConverterReader() {
    }

    public OpenAPIConverterReader(boolean shouldCreateContentForPreview) {
        super(shouldCreateContentForPreview);
    }

    @Override
    public String determineConverterType(String inputFileExtension) {
        String toRet = null;
        if (Arrays.asList(ExtensionGetter.getInputExtension((String)"_openapi.to.dita")).contains(inputFileExtension)) {
            toRet = "_openapi.to.dita";
        }
        return toRet;
    }

    @Override
    public Converter customizeConverter(Converter converter) {
        if ((converter = super.customizeConverter(converter)) instanceof OpenApiToDITAConverter) {
            ((OpenApiToDITAConverter)converter).setShouldConvertExternalOpenApiReferences(false);
        }
        return converter;
    }

    @Override
    public String[] getAllowedInputExtensions() {
        return ExtensionGetter.getInputExtension((String)"_openapi.to.dita");
    }

    @Override
    public String getFormat() {
        return OPENAPI_TO_DITA_FORMAT;
    }
}

