/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dynamic.resources.converter;

import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.doctype.DoctypeGetter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.CatalogResourceResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ResourceResolver;
import org.dita.dost.util.CatalogUtils;
import org.xml.sax.EntityResolver;

public final class ConverterUtil {
    private ConverterUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String enrichWithDoctype(ConversionResult conversionResult, String converterType, EntityResolver resolver) throws TransformerException {
        String publicDocType;
        Transformer transformer = ConverterUtil.createTransformer(null, resolver);
        String systemDocType = DoctypeGetter.getSystemDoctype((ConversionResult)conversionResult, (String)converterType);
        if (!systemDocType.isEmpty()) {
            transformer.setOutputProperty("doctype-system", systemDocType);
        }
        if (!(publicDocType = DoctypeGetter.getPublicDoctype((ConversionResult)conversionResult, (String)converterType)).isEmpty()) {
            transformer.setOutputProperty("doctype-public", publicDocType);
        }
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(new StreamSource(new StringReader(conversionResult.getConvertedContent())), result);
        return sw.toString();
    }

    public static Transformer createTransformer(StreamSource stylesheetStreamSource, EntityResolver resolver) throws TransformerConfigurationException {
        Configuration config = new Configuration();
        if (resolver == null) {
            resolver = CatalogUtils.getCatalogResolver();
        }
        ParseOptions parserOptions = config.getParseOptions().withEntityResolver(resolver);
        config.setParseOptions(parserOptions);
        config.setResourceResolver((ResourceResolver)new CatalogResourceResolver(CatalogUtils.getCatalogResolver()));
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl(config);
        Transformer transformer = stylesheetStreamSource == null ? transformerFactory.newTransformer() : transformerFactory.newTransformer(stylesheetStreamSource);
        return transformer;
    }
}

