/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.FontFilesResource;
import com.jidesoft.utils.SystemInfo;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.plaf.FontUIResource;

public class SecurityUtils {
    public static final String BOLD = "Bold";
    public static final String ITALIC = "Italic";
    public static final String BOLD_ITALIC = "Bold Italic";
    private static boolean _AWTEventListenerDisabled = false;
    private static boolean _translucentWindowFeatureDisabled = !SystemInfo.isJdk6u10Above() || !SystemInfo.isWindows();

    public static FontUIResource createFontUIResource(String name, int style, int size) {
        Font font = SecurityUtils.createFont(name, style, size);
        if (font != null) {
            return new FontUIResource(font);
        }
        return null;
    }

    private static String createFontStrings(String font, int style) {
        Object fontString;
        switch (style) {
            case 1: {
                fontString = font + " Bold";
                break;
            }
            case 2: {
                fontString = font + " Italic";
                break;
            }
            case 3: {
                fontString = font + " Bold Italic";
                break;
            }
            default: {
                fontString = font;
            }
        }
        return ((String)fontString).replace(' ', '_');
    }

    public static Font createFont(String name, int style, int size) {
        try {
            return new Font(name, style, size);
        }
        catch (AccessControlException e) {
            ClassLoader cl = SecurityUtils.class.getClassLoader();
            try {
                String value = null;
                try {
                    value = FontFilesResource.getResourceBundle(Locale.getDefault()).getString(SecurityUtils.createFontStrings(name, style));
                }
                catch (MissingResourceException me1) {
                    try {
                        value = FontFilesResource.getResourceBundle(Locale.getDefault()).getString(name);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                if (value == null) {
                    return null;
                }
                Font font = Font.createFont(0, cl.getResourceAsStream(value));
                if (font != null) {
                    return font.deriveFont(style, size);
                }
            }
            catch (FontFormatException e1) {
                e1.printStackTrace();
                throw e;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw e;
            }
            return null;
        }
    }

    public static String getProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (AccessControlException e) {
            return defaultValue;
        }
    }

    public static boolean isAWTEventListenerDisabled() {
        return _AWTEventListenerDisabled;
    }

    public static void setAWTEventListenerDisabled(boolean AWTEventListenerDisabled) {
        _AWTEventListenerDisabled = AWTEventListenerDisabled;
    }

    public static boolean isTranslucentWindowFeatureDisabled() {
        return _translucentWindowFeatureDisabled;
    }

    public static void setTranslucentWindowFeatureDisabled(boolean translucentWindowFeatureDisabled) {
        _translucentWindowFeatureDisabled = translucentWindowFeatureDisabled;
    }

    static class FontStruct {
        String font;
        int style;

        FontStruct() {
        }
    }
}

