/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static void callSetBoolean(Object thisObject, String methodName, boolean value) throws Exception {
        Class[] argTypes = new Class[]{Boolean.TYPE};
        Object[] args = new Object[]{value ? Boolean.TRUE : Boolean.FALSE};
        Method method = thisObject.getClass().getMethod(methodName, argTypes);
        method.invoke(thisObject, args);
    }

    public static void callSetInt(Object thisObject, String methodName, int value) throws Exception {
        Class[] argTypes = new Class[]{Integer.TYPE};
        Object[] args = new Object[]{value};
        Method method = thisObject.getClass().getMethod(methodName, argTypes);
        method.invoke(thisObject, args);
    }

    public static void callSet(Object thisObject, String methodName, Object value) throws Exception {
        Class[] argTypes = new Class[]{value.getClass()};
        Object[] args = new Object[]{value};
        Method method = thisObject.getClass().getMethod(methodName, argTypes);
        method.invoke(thisObject, args);
    }

    public static Object callGet(Object thisObject, String methodName) throws Exception {
        Method method = thisObject.getClass().getMethod(methodName, null);
        return method.invoke(thisObject, (Object[])null);
    }

    public static void call(Object thisObject, String methodName) throws Exception {
        Method method = thisObject.getClass().getMethod(methodName, null);
        method.invoke(thisObject, (Object[])null);
    }

    public static Object callConstructor(Class<?> clazz, Class<?>[] argTypes, Object[] args) throws Exception {
        Constructor<?> constructor = clazz.getConstructor(argTypes);
        return constructor.newInstance(args);
    }

    public static Object callAny(Object thisObject, String methodName, Object[] args) throws Exception {
        Class[] argTypes = null;
        if (args != null) {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
        }
        return ReflectionUtils.callAny(thisObject, methodName, argTypes, args);
    }

    public static Object callAny(Object thisObject, String methodName, Class<?>[] argTypes, Object[] args) throws Exception {
        Method method = thisObject.getClass().getMethod(methodName, argTypes);
        return method.invoke(thisObject, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callAnyWithoutException(Object thisObject, Class<?> objectClass, String methodName, Class<?>[] argTypes, Object[] args) {
        Method m;
        try {
            m = objectClass.getDeclaredMethod(methodName, argTypes);
        }
        catch (Exception e) {
            m = null;
        }
        if (m != null) {
            try {
                m.setAccessible(true);
                Object e = m.invoke(thisObject, args);
                return e;
            }
            catch (Exception ignored) {
                Object var7_9 = null;
                return var7_9;
            }
            finally {
                m.setAccessible(false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callStatic(Class<?> thisClass, String methodName, Class<?>[] argTypes, Object[] args) throws Exception {
        Method method = thisClass.getMethod(methodName, argTypes);
        Object result = null;
        if (method != null) {
            try {
                method.setAccessible(true);
                result = method.invoke(null, args);
            }
            finally {
                method.setAccessible(false);
            }
        }
        return result;
    }

    public static Object createInstance(String className, Class<?>[] types, Object[] args) {
        Object instantiation = null;
        try {
            Class<?> cls = Class.forName(className);
            if (types != null && types.length != 0) {
                Constructor<?> constructor = cls.getConstructor(types);
                instantiation = constructor.newInstance(args);
            } else {
                instantiation = cls.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instantiation;
    }

    public static boolean isSubClassOf(Object o, String className) {
        if (o == null) {
            return false;
        }
        for (Class<?> aClass = o.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            if (!aClass.getName().contains(className)) continue;
            return true;
        }
        return false;
    }
}

