/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.range.IntegerRange;
import com.jidesoft.range.LongRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.List;

public final class MathUtils {
    protected MathUtils() {
    }

    public static double sum(List<Number> numbers) {
        double sum = 0.0;
        for (Number value : numbers) {
            sum += value.doubleValue();
        }
        return sum;
    }

    public static double mean(List<Number> numbers) {
        double sum = MathUtils.sum(numbers);
        return sum / (double)numbers.size();
    }

    public static double min(List<Number> numbers) {
        double min = Double.MAX_VALUE;
        for (Number value : numbers) {
            double v = value.doubleValue();
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public static double max(List<Number> numbers) {
        double max = Double.MIN_VALUE;
        for (Number value : numbers) {
            double v = value.doubleValue();
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static double stddev(List<Number> numbers, boolean biasCorrected) {
        double stddev = Double.NaN;
        int n = numbers.size();
        if (n > 0) {
            stddev = n > 1 ? Math.sqrt(MathUtils.var(numbers, biasCorrected)) : 0.0;
        }
        return stddev;
    }

    public static double var(List<Number> numbers, boolean biasCorrected) {
        int n = numbers.size();
        if (n == 0) {
            return Double.NaN;
        }
        if (n == 1) {
            return 0.0;
        }
        double mean = MathUtils.mean(numbers);
        ArrayList<Number> squares = new ArrayList<Number>();
        for (Number number : numbers) {
            double XminMean = number.doubleValue() - mean;
            squares.add(Math.pow(XminMean, 2.0));
        }
        double sum = MathUtils.sum(squares);
        return sum / (double)(biasCorrected ? n - 1 : n);
    }

    public static Range<Double> range(List<Number> numbers) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Number value : numbers) {
            double v = value.doubleValue();
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        return new NumericRange(min, max);
    }

    public static Range<Integer> rangeInteger(List<Number> numbers) {
        double min = 2.147483647E9;
        double max = -2.147483648E9;
        for (Number value : numbers) {
            double v = value.doubleValue();
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        return new IntegerRange((int)min, (int)max);
    }

    public static Range<Long> rangeLong(List<Number> numbers) {
        double min = 9.223372036854776E18;
        double max = -9.223372036854776E18;
        for (Number value : numbers) {
            double v = value.doubleValue();
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        return new LongRange((long)min, (long)max);
    }
}

