/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.AbstractLayoutPersistence;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.swing.RootPanePersistence;
import com.jidesoft.utils.PersistenceUtilsCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LayoutPersistenceManager
extends AbstractLayoutPersistence {
    private List<LayoutPersistence> _entries = new ArrayList<LayoutPersistence>();
    public static final String NODE_DOCKING_MANAGER = "DockingManager";
    public static final String NODE_DOCKABLE_BAR_MANAGER = "DockableBarManager";
    public static final String NODE_DOCUMENT_PANE = "DocumentPane";
    private boolean _loadDataSuccessful = true;

    public void addLayoutPersistence(LayoutPersistence layoutPersistence) {
        this._entries.add(layoutPersistence);
    }

    public void removeLayoutPersistence(LayoutPersistence layoutPersistence) {
        this._entries.remove(layoutPersistence);
    }

    public void clear() {
        this._entries.clear();
    }

    @Override
    public boolean loadLayoutFrom(Document document) {
        LayoutPersistence layoutPersistence;
        int i;
        this._loadDataSuccessful = true;
        if (document == null) {
            this._loadDataSuccessful = false;
            return this._loadDataSuccessful;
        }
        int lastIndex = -1;
        for (i = this._entries.size() - 1; i >= 0; --i) {
            layoutPersistence = this._entries.get(i);
            if (!(layoutPersistence instanceof RootPanePersistence)) continue;
            lastIndex = i;
            break;
        }
        for (i = 0; i < this._entries.size(); ++i) {
            boolean loadSuccessful;
            layoutPersistence = this._entries.get(i);
            boolean lastOne = i == lastIndex;
            boolean oldLastOne = layoutPersistence.isLast();
            String oldName = layoutPersistence.getLayoutPersistenceName();
            PersistenceUtilsCallback.Load oldLoadCallback = layoutPersistence.getLoadCallback();
            layoutPersistence.setLast(lastOne);
            if (oldName == null) {
                layoutPersistence.setLayoutPersistenceName("" + i);
            }
            if (oldLoadCallback == null) {
                layoutPersistence.setLoadCallback(this.getLoadCallback());
            }
            boolean bl = this._loadDataSuccessful = (loadSuccessful = layoutPersistence.loadLayoutFrom(document)) && this._loadDataSuccessful;
            if (!loadSuccessful) {
                layoutPersistence.resetToDefault();
            }
            layoutPersistence.setLast(oldLastOne);
            if (oldName == null) {
                layoutPersistence.setLayoutPersistenceName(oldName);
            }
            if (oldLoadCallback != null) continue;
            layoutPersistence.setLoadCallback(oldLoadCallback);
        }
        return this._loadDataSuccessful;
    }

    @Override
    public boolean loadLayoutFrom(InputStream in) {
        byte[] buffer;
        this._loadDataSuccessful = true;
        if (in == null) {
            this._loadDataSuccessful = false;
            return this._loadDataSuccessful;
        }
        try {
            buffer = PersistenceUtils.bufferStreamToArray(in);
        }
        catch (IOException e) {
            buffer = null;
        }
        if (buffer == null) {
            this._loadDataSuccessful = false;
            return this._loadDataSuccessful;
        }
        boolean isXmlFormat = PersistenceUtils.isXmlFormat(buffer);
        ByteArrayInputStream newStream = new ByteArrayInputStream(buffer);
        if (isXmlFormat) {
            try {
                Document document = PersistenceUtils.getDocument(newStream);
                return this.loadLayoutFrom(document);
            }
            catch (Exception e) {
                this._loadDataSuccessful = false;
                for (LayoutPersistence entry : this._entries) {
                    entry.resetToDefault();
                }
            }
        } else {
            LayoutPersistence layoutPersistence;
            int i;
            int lastIndex = -1;
            for (i = this._entries.size() - 1; i >= 0; --i) {
                layoutPersistence = this._entries.get(i);
                if (!(layoutPersistence instanceof RootPanePersistence)) continue;
                lastIndex = i;
                break;
            }
            for (i = 0; i < this._entries.size(); ++i) {
                layoutPersistence = this._entries.get(i);
                boolean lastOne = i == lastIndex;
                boolean oldLast = layoutPersistence.isLast();
                boolean oldNeedFormatCheck = layoutPersistence.isNeedFormatCheck();
                layoutPersistence.setLast(lastOne);
                layoutPersistence.setNeedFormatCheck(false);
                boolean loadSuccessful = layoutPersistence.loadLayoutFrom(newStream);
                boolean bl = this._loadDataSuccessful = loadSuccessful && this._loadDataSuccessful;
                if (!loadSuccessful) {
                    layoutPersistence.resetToDefault();
                }
                layoutPersistence.setLast(oldLast);
                layoutPersistence.setNeedFormatCheck(oldNeedFormatCheck);
            }
        }
        return this._loadDataSuccessful;
    }

    @Override
    public boolean isLoadDataSuccessful() {
        return this._loadDataSuccessful;
    }

    @Override
    public void saveLayoutTo(Document document) throws ParserConfigurationException {
        for (int i = 0; i < this._entries.size(); ++i) {
            LayoutPersistence layoutPersistence = this._entries.get(i);
            PersistenceUtilsCallback.Save oldSaveCallback = layoutPersistence.getSaveCallback();
            String oldEncoding = layoutPersistence.getXmlEncoding();
            String oldName = layoutPersistence.getLayoutPersistenceName();
            if (oldSaveCallback == null) {
                layoutPersistence.setSaveCallback(this.getSaveCallback());
            }
            if (oldEncoding == null) {
                layoutPersistence.setXmlEncoding(this.getXmlEncoding());
            }
            if (oldName == null) {
                layoutPersistence.setLayoutPersistenceName("" + i);
            }
            layoutPersistence.saveLayoutTo(document);
            if (oldSaveCallback == null) {
                layoutPersistence.setSaveCallback(oldSaveCallback);
            }
            if (oldEncoding == null) {
                layoutPersistence.setXmlEncoding(oldEncoding);
            }
            if (oldName != null) continue;
            layoutPersistence.setLayoutPersistenceName(oldName);
        }
    }

    @Override
    public void saveLayoutTo(OutputStream out) throws IOException {
        if (this.isXmlFormat()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                this.saveLayoutTo(document);
                PersistenceUtils.saveXMLDocumentToStream(document, out, this.getXmlEncoding() == null ? PersistenceUtils.getDefaultXmlEncoding() : this.getXmlEncoding());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            return;
        }
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.saveLayoutTo(out);
        }
    }

    @Override
    public void resetToDefault() {
        for (int i = 0; i < this._entries.size(); ++i) {
            LayoutPersistence layoutPersistence = this._entries.get(i);
            boolean old = layoutPersistence.isLast();
            layoutPersistence.setLast(i == this._entries.size() - 1);
            layoutPersistence.resetToDefault();
            layoutPersistence.setLast(old);
        }
    }

    @Override
    public void beginLoadLayoutData() {
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.beginLoadLayoutData();
        }
    }

    @Override
    public void loadInitialLayout(String layoutFile) throws ParserConfigurationException, SAXException, IOException {
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.loadInitialLayout(layoutFile);
        }
    }

    @Override
    public void loadInitialLayout(InputStream layoutStream) throws ParserConfigurationException, SAXException, IOException {
        int read;
        byte[] bytes = new byte[10240];
        int pos = 0;
        int length = bytes.length;
        while ((read = layoutStream.read(bytes, pos, length - pos)) != -1) {
            if ((pos += read) < length) continue;
            byte[] newBytes = new byte[length * 2];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            bytes = newBytes;
            length = bytes.length;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes, 0, pos);
        byteArrayInputStream.mark(0);
        for (LayoutPersistence layoutPersistence : this._entries) {
            byteArrayInputStream.reset();
            layoutPersistence.loadInitialLayout(byteArrayInputStream);
        }
    }

    @Override
    public void loadInitialLayout(Document layoutDocument) {
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.loadInitialLayout(layoutDocument);
        }
    }

    @Override
    public void setUseFrameBounds(boolean useFrameBounds) {
        super.setUseFrameBounds(useFrameBounds);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setUseFrameBounds(useFrameBounds);
        }
    }

    @Override
    public void setUseFrameState(boolean useFrameState) {
        super.setUseFrameState(useFrameState);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setUseFrameState(useFrameState);
        }
    }

    @Override
    public void setLayoutDirectory(String layoutDirectory) {
        super.setLayoutDirectory(layoutDirectory);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setLayoutDirectory(layoutDirectory);
        }
    }

    @Override
    public void setVersion(short version) {
        super.setVersion(version);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setVersion(version);
        }
    }

    @Override
    public void setUsePref(boolean usePref) {
        super.setUsePref(usePref);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setUsePref(usePref);
        }
    }

    @Override
    public void setProfileKey(String profileKey) {
        super.setProfileKey(profileKey);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setProfileKey(profileKey);
        }
    }

    @Override
    public boolean isLast() {
        return true;
    }

    @Override
    public void setLast(boolean last) {
    }
}

