/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.utils.PersistenceUtilsCallback;
import com.jidesoft.utils.SecurityUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractLayoutPersistence
implements LayoutPersistence {
    public static final short V2004 = 19;
    public static final short V2005_09 = 20;
    protected short _version = (short)20;
    protected static final String DEFAULT_PROFILE_NAME = "default";
    public static final String PROPERTY_PROFILE_KEY = "profileKey";
    public static final String PROPERTY_USE_PREF = "usePref";
    public static final String PROPERTY_VERSION = "version";
    protected String _profileKey = "profile";
    protected static final int MAX_PREF_BYTE_ARRAY_LENGTH = 6144;
    protected boolean _loadingLayoutData = false;
    protected boolean _useFrameBounds = true;
    protected boolean _useFrameBoundsSet = false;
    protected boolean _useFrameState = true;
    protected boolean _useFrameStateSet = false;
    protected boolean _usePref = true;
    protected static final String LAYOUT_COUNT_STRING = "_count";
    protected final String LAYOUT_POSTFIX = ".layout";
    protected String _layoutDirectory = null;
    private PropertyChangeSupport changeSupport;
    private boolean _xmlFormat = false;
    private PersistenceUtilsCallback.Save _saveCallback = null;
    private PersistenceUtilsCallback.Load _loadCallback = null;
    private String _xmlEncoding = null;
    private String _layoutPersistenceName = null;
    private boolean _needFormatCheck = true;
    private boolean _last = true;

    @Override
    public short getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(short version) {
        this._version = version;
    }

    public String getProfileKey() {
        return this._profileKey;
    }

    @Override
    public void setProfileKey(String profileKey) {
        if (profileKey == null || profileKey.trim().length() == 0) {
            throw new IllegalArgumentException("profileKey cannot be null or empty.");
        }
        String old = this._profileKey;
        if (!profileKey.equals(old)) {
            this._profileKey = profileKey;
            this.firePropertyChange(PROPERTY_PROFILE_KEY, old, profileKey);
        }
    }

    private static void setByteArrayToPref(Preferences pref, String key, byte[] value) {
        if (value.length <= 6144) {
            int oldCount = pref.getInt(key + LAYOUT_COUNT_STRING, -99);
            if (oldCount > 1) {
                for (int i = 0; i < oldCount; ++i) {
                    pref.remove(key + "_" + i);
                }
            }
            pref.putByteArray(key, value);
            pref.putInt(key + LAYOUT_COUNT_STRING, 1);
        } else {
            int oldCount = pref.getInt(key + LAYOUT_COUNT_STRING, -99);
            if (oldCount == 0 || oldCount == 1) {
                pref.remove(key);
            }
            int count = value.length / 6144 + 1;
            ByteBuffer byteBuffer = ByteBuffer.wrap(value, 0, value.length);
            byte[] subArray = new byte[6144];
            for (int i = 0; i < count; ++i) {
                if (i != count - 1) {
                    byteBuffer.get(subArray, 0, 6144);
                } else {
                    int remaining = value.length - i * 6144;
                    subArray = new byte[remaining];
                    byteBuffer.get(subArray, 0, remaining);
                }
                pref.putByteArray(key + "_" + i, subArray);
            }
            pref.putInt(key + LAYOUT_COUNT_STRING, count);
        }
    }

    private static byte[] getByteArrayFromPref(Preferences pref, String key) {
        byte[] emptyArray = new byte[]{};
        int count = pref.getInt(key + LAYOUT_COUNT_STRING, 0);
        if (count == 0 || count == 1) {
            return pref.getByteArray(key, emptyArray);
        }
        ByteBuffer buffer = ByteBuffer.allocate(count * 6144);
        for (int i = 0; i < count; ++i) {
            buffer.put(pref.getByteArray(key + "_" + i, emptyArray));
        }
        int bytesRead = buffer.position();
        byte[] result = new byte[bytesRead];
        buffer.position(0);
        buffer.get(result, 0, bytesRead);
        return result;
    }

    @Override
    public void loadLayoutData() {
        boolean previousLoadingData = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            this.loadLayoutDataFrom(DEFAULT_PROFILE_NAME);
        }
        finally {
            this._loadingLayoutData = previousLoadingData;
        }
    }

    @Override
    public boolean isLayoutAvailable(String layoutName) {
        if (this._usePref) {
            Preferences prefs;
            try {
                prefs = Preferences.userRoot();
            }
            catch (AccessControlException e) {
                return false;
            }
            byte[] layout = AbstractLayoutPersistence.getByteArrayFromPref(prefs.node(this._profileKey), layoutName);
            return layout.length != 0;
        }
        String settingsFile = this.getLayoutDirectory() + File.separator + layoutName + ".layout";
        File file = new File(settingsFile);
        return file.exists();
    }

    @Override
    public List<String> getAvailableLayouts() {
        ArrayList<String> layouts = new ArrayList<String>();
        if (this._usePref) {
            Preferences prefs;
            try {
                prefs = Preferences.userRoot();
            }
            catch (AccessControlException e) {
                return layouts;
            }
            try {
                String[] names;
                Preferences layoutNode = prefs.node(this._profileKey);
                for (String name : names = layoutNode.keys()) {
                    if (!name.endsWith(LAYOUT_COUNT_STRING)) continue;
                    layouts.add(name.substring(0, name.length() - LAYOUT_COUNT_STRING.length()));
                }
            }
            catch (BackingStoreException layoutNode) {
                // empty catch block
            }
            return layouts;
        }
        String settingsFile = this.getLayoutDirectory() + File.separator;
        File file = new File(settingsFile);
        if (!file.exists()) {
            return layouts;
        }
        File[] files = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".layout");
            }
        });
        if (files != null) {
            for (File f : files) {
                String fileName = f.getName();
                if (!fileName.endsWith(".layout")) continue;
                layouts.add(fileName.substring(0, fileName.length() - ".layout".length()));
            }
        }
        return layouts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeLayout(String layoutName) {
        if (this._usePref) {
            Preferences prefs;
            try {
                prefs = Preferences.userRoot();
            }
            catch (AccessControlException e) {
                return;
            }
            Preferences pref = prefs.node(this._profileKey);
            int count = pref.getInt(layoutName + LAYOUT_COUNT_STRING, 0);
            if (count > 1) {
                for (int i = 0; i < count; ++i) {
                    pref.remove(layoutName + "_" + i);
                }
            } else {
                pref.remove(layoutName);
            }
            pref.remove(layoutName + LAYOUT_COUNT_STRING);
            return;
        }
        String settingsFile = this.getLayoutDirectory() + File.separator + layoutName + ".layout";
        try {
            File file = new File(settingsFile);
            if (!file.exists()) {
                return;
            }
            if (!file.delete()) return;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadLayoutDataFrom(String layoutName) {
        boolean previousLoadingData = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            byte[] layout = new byte[]{};
            if (this._usePref) {
                try {
                    Preferences prefs = Preferences.userRoot();
                    layout = AbstractLayoutPersistence.getByteArrayFromPref(prefs.node(this._profileKey), layoutName);
                }
                catch (AccessControlException e) {
                    this.resetToDefault();
                }
            } else {
                String settingsFile = this.getLayoutDirectory() + File.separator + layoutName + ".layout";
                try {
                    File file = new File(settingsFile);
                    if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
                        throw new IOException("Cannot open " + settingsFile);
                    }
                    FileInputStream stream = new FileInputStream(file);
                    int byteCount = stream.available();
                    layout = new byte[byteCount];
                    int read = stream.read(layout);
                    stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (layout == null || layout.length == 0) {
                this.resetToDefault();
            } else {
                this.loadLayoutFrom(new ByteArrayInputStream(layout));
            }
        }
        finally {
            this._loadingLayoutData = previousLoadingData;
        }
    }

    @Override
    public boolean isLayoutDataVersionValid(String layoutName) {
        byte[] layout = new byte[]{};
        if (this._usePref) {
            try {
                Preferences prefs = Preferences.userRoot();
                layout = AbstractLayoutPersistence.getByteArrayFromPref(prefs.node(this._profileKey), layoutName);
            }
            catch (AccessControlException e) {
                this.resetToDefault();
            }
        } else {
            String settingsFile = this.getLayoutDirectory() + File.separator + layoutName + ".layout";
            try {
                File file = new File(settingsFile);
                if (!file.exists() && !file.createNewFile()) {
                    return false;
                }
                FileInputStream stream = new FileInputStream(file);
                int byteCount = stream.available();
                layout = new byte[byteCount];
                int read = stream.read(layout);
                stream.close();
            }
            catch (Exception e) {
                return false;
            }
        }
        if (layout == null || layout.length == 0) {
            return false;
        }
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(layout));
        try {
            short version = stream.readShort();
            return this.isVersionCompatible(version);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected boolean isVersionCompatible(int version) {
        return this._version == version || this._version == 20 && version == 19;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadLayoutDataFromFile(String fileName) {
        boolean previousLoadingData = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            byte[] layout = null;
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    FileInputStream stream = new FileInputStream(file);
                    int byteCount = stream.available();
                    layout = new byte[byteCount];
                    int read = stream.read(layout);
                    stream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (layout == null || layout.length == 0) {
                this.resetToDefault();
            } else {
                this.loadLayoutFrom(new ByteArrayInputStream(layout));
            }
        }
        finally {
            this._loadingLayoutData = previousLoadingData;
        }
    }

    @Override
    public void saveLayoutData() {
        if (this._loadingLayoutData) {
            return;
        }
        this.saveLayoutDataAs(DEFAULT_PROFILE_NAME);
    }

    @Override
    public String getLayoutDirectory() {
        if (this._layoutDirectory == null) {
            String home = SecurityUtils.getProperty("user.home", "") + File.separator + "." + this._profileKey;
            File setDir = new File(home);
            if (!setDir.isDirectory() && !setDir.mkdirs()) {
                System.err.println("Failed to create directory: " + home);
            }
            return home;
        }
        return this._layoutDirectory;
    }

    @Override
    public void setLayoutDirectory(String layoutDirectory) {
        this._layoutDirectory = layoutDirectory;
    }

    @Override
    public void saveLayoutDataAs(String layoutName) {
        if (this._loadingLayoutData) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(out);
            if (this._usePref) {
                Preferences prefs = Preferences.userRoot();
                AbstractLayoutPersistence.setByteArrayToPref(prefs.node(this._profileKey), layoutName, out.toByteArray());
            } else {
                String settingsFile = this.getLayoutDirectory() + File.separator + layoutName + ".layout";
                File file = new File(settingsFile);
                if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
                    throw new IOException("Cannot open " + settingsFile);
                }
                FileOutputStream stream = new FileOutputStream(file);
                stream.write(out.toByteArray());
                stream.close();
            }
        }
        catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Cannot open")) {
                System.err.println(e.getLocalizedMessage());
            }
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveLayoutDataToFile(String layoutFileName) {
        block15: {
            if (this._loadingLayoutData) {
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.saveLayoutTo(out);
                File file = new File(layoutFileName);
                if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
                    throw new IOException("Cannot open " + layoutFileName);
                }
                FileOutputStream stream = new FileOutputStream(file);
                stream.write(out.toByteArray());
                stream.close();
                out.close();
                out = null;
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().startsWith("Cannot open")) {
                    System.err.println(e.getLocalizedMessage());
                    break block15;
                }
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void setLayoutRawData(byte[] layoutData) {
        if (layoutData == null || layoutData.length == 0) {
            this.resetToDefault();
        } else {
            this.loadLayoutFrom(new ByteArrayInputStream(layoutData));
        }
    }

    @Override
    public byte[] getLayoutRawData() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(out);
            return out.toByteArray();
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
            return new byte[0];
        }
    }

    public boolean isUsePref() {
        return this._usePref;
    }

    @Override
    public void setUsePref(boolean usePref) {
        boolean old = this._usePref;
        if (usePref != old) {
            this._usePref = usePref;
            this.firePropertyChange(PROPERTY_USE_PREF, old, usePref);
        }
    }

    @Override
    public void setUseFrameState(boolean useFrameState) {
        this._useFrameState = useFrameState;
        this._useFrameStateSet = true;
    }

    @Override
    public void setUseFrameBounds(boolean useFrameBounds) {
        this._useFrameBounds = useFrameBounds;
        this._useFrameBoundsSet = true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null) {
            return;
        }
        changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null) {
            return;
        }
        changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null) {
            return;
        }
        changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void loadInitialLayout(String layoutFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(layoutFile));
        this.loadInitialLayout(document);
    }

    @Override
    public void loadInitialLayout(InputStream layoutStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(layoutStream);
        this.loadInitialLayout(document);
    }

    protected boolean shouldUseFrameState(boolean wasVisible) {
        if (this._useFrameStateSet) {
            return this._useFrameState;
        }
        return !wasVisible && this.isLast();
    }

    protected boolean shouldUseFrameBounds(boolean wasVisible) {
        if (this._useFrameBoundsSet) {
            return this._useFrameBounds;
        }
        return !wasVisible && this.isLast();
    }

    @Override
    public boolean isLast() {
        return this._last;
    }

    @Override
    public void setLast(boolean last) {
        this._last = last;
    }

    public boolean isLoadingLayoutData() {
        return this._loadingLayoutData;
    }

    public void setLoadingLayoutData(boolean loadingLayoutData) {
        this._loadingLayoutData = loadingLayoutData;
    }

    @Override
    public boolean isXmlFormat() {
        return this._xmlFormat;
    }

    @Override
    public void setXmlFormat(boolean xmlFormat) {
        this._xmlFormat = xmlFormat;
    }

    @Override
    public PersistenceUtilsCallback.Save getSaveCallback() {
        return this._saveCallback;
    }

    @Override
    public void setSaveCallback(PersistenceUtilsCallback.Save saveCallback) {
        this._saveCallback = saveCallback;
    }

    @Override
    public PersistenceUtilsCallback.Load getLoadCallback() {
        return this._loadCallback;
    }

    @Override
    public void setLoadCallback(PersistenceUtilsCallback.Load loadCallback) {
        this._loadCallback = loadCallback;
    }

    @Override
    public String getXmlEncoding() {
        return this._xmlEncoding;
    }

    @Override
    public void setXmlEncoding(String xmlEncoding) {
        this._xmlEncoding = xmlEncoding;
    }

    @Override
    public String getLayoutPersistenceName() {
        return this._layoutPersistenceName;
    }

    @Override
    public void setLayoutPersistenceName(String layoutPersistenceName) {
        this._layoutPersistenceName = layoutPersistenceName;
    }

    @Override
    public boolean isNeedFormatCheck() {
        return this._needFormatCheck;
    }

    @Override
    public void setNeedFormatCheck(boolean needFormatCheck) {
        this._needFormatCheck = needFormatCheck;
    }
}

