/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.plaf.SidePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SidePane;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class BasicSidePaneUI
extends SidePaneUI {
    public DropTarget _dt;
    protected SidePane _sidePane;
    protected int _size;
    protected Insets _margin;
    protected int _iconTextGap;
    protected int _textBorderGap;
    protected int _itemGap;
    protected int _groupGap;
    protected Color _lineColor;
    protected Color _background;
    protected Color _buttonBackground;
    protected Color _selectedButtonBackground;
    protected Color _selectedButtonForeground;
    protected Font _font;
    protected boolean _showText = true;
    protected boolean _alwaysShowText = true;
    protected boolean _highlightSelectedTab = false;
    protected Rectangle[] _rects;
    protected int _displayOrientation;
    private MouseInputListener _inputListener;
    private DropTargetListener _dropListener;
    private ThemePainter _painter;

    public static ComponentUI createUI(JComponent c) {
        return new BasicSidePaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this._sidePane = (SidePane)c;
        c.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        c.setLayout(null);
        this._sidePane = null;
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installColorsAndFont(this._sidePane, "SidePane.background", "SidePane.foreground", "SidePane.font");
        LookAndFeel.installBorder(this._sidePane, "SidePane.border");
        this._background = UIDefaultsLookup.getColor("SidePane.background");
        this._margin = UIDefaultsLookup.getInsets("SidePane.margin");
        this._iconTextGap = UIDefaultsLookup.getInt("SidePane.iconTextGap");
        this._textBorderGap = UIDefaultsLookup.getInt("SidePane.textBorderGap");
        this._itemGap = UIDefaultsLookup.getInt("SidePane.itemGap");
        this._groupGap = UIDefaultsLookup.getInt("SidePane.groupGap");
        this._lineColor = UIDefaultsLookup.getColor("SidePane.lineColor");
        this._buttonBackground = UIDefaultsLookup.getColor("SidePane.buttonBackground");
        this._selectedButtonBackground = UIDefaultsLookup.getColor("SidePane.selectedButtonBackground");
        this._selectedButtonForeground = UIDefaultsLookup.getColor("SidePane.selectedButtonForeground");
        this._font = UIDefaultsLookup.getFont("SidePane.font");
        this._displayOrientation = UIDefaultsLookup.getInt("SidePane.orientation");
        this._showText = UIDefaultsLookup.getBoolean("SidePane.showSelectedTabText");
        this._alwaysShowText = UIDefaultsLookup.getBoolean("SidePane.alwaysShowTabText");
        this._highlightSelectedTab = UIDefaultsLookup.getBoolean("SidePane.highlighSelectedTab");
        this._size = 6;
        this._size += this._margin.top;
        this._size += this._margin.bottom;
        this._size += Math.max(this.getFontMetrics().getHeight(), 16);
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._background = null;
        this._margin = null;
        this._lineColor = null;
        this._buttonBackground = null;
        this._selectedButtonBackground = null;
        this._selectedButtonForeground = null;
        this._font = null;
    }

    protected void installListeners() {
        this._inputListener = this.createMouseInputListener();
        this._dropListener = this.createDropListener();
        this._sidePane.addMouseListener(this._inputListener);
        this._sidePane.addMouseMotionListener(this._inputListener);
        this._dt = new DropTarget(this._sidePane, this._dropListener);
        this._sidePane.setDropTarget(this._dt);
    }

    protected MouseInputListener createMouseInputListener() {
        if (this._sidePane.isRollover()) {
            return new RolloverMouseInputListener();
        }
        return new NonrolloverMouseInputListener();
    }

    protected DropListener createDropListener() {
        return new DropListener();
    }

    protected void uninstallListeners() {
        this._sidePane.removeMouseListener(this._inputListener);
        this._sidePane.removeMouseMotionListener(this._inputListener);
        this._dt.removeDropTargetListener(this._dropListener);
        this._dropListener = null;
        this._dt = null;
        this._sidePane.setDropTarget(null);
        this._inputListener = null;
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    @Override
    public int getSelectedItemIndex(Point p) {
        if (this._rects != null) {
            for (int i = 0; i < this._rects.length; ++i) {
                Rectangle rect = this._rects[i];
                if (!rect.contains(p)) continue;
                return i;
            }
        }
        return -1;
    }

    public Rectangle getGroupRect(int index) {
        if (index >= 0 && index < this._rects.length) {
            return this._rects[index];
        }
        return null;
    }

    @Override
    public SidePaneGroup getGroupForIndex(int index) {
        int totalButtons = 0;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            if (index >= totalButtons && index < totalButtons + group.size()) {
                return group;
            }
            totalButtons += group.size();
        }
        return null;
    }

    @Override
    public SidePaneItem getItemForIndex(int index) {
        int totalButtons = 0;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            if (index >= totalButtons && index < totalButtons + group.size()) {
                return (SidePaneItem)group.get(index - totalButtons);
            }
            totalButtons += group.size();
        }
        return null;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this._sidePane.getFont();
        return this._sidePane.getFontMetrics(font);
    }

    protected void initButtonRects() {
        int i;
        int totalButtons = 0;
        for (i = 0; i < this._sidePane.getGroups().size(); ++i) {
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            totalButtons += group.size();
        }
        this._rects = new Rectangle[totalButtons];
        for (i = 0; i < this._rects.length; ++i) {
            this._rects[i] = new Rectangle(0, 0, 0, 0);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.paintBackground(g, c);
        g.setColor(this._lineColor);
        FontMetrics metrics = this.getFontMetrics();
        this.initButtonRects();
        boolean ltr = this._sidePane.getComponentOrientation().isLeftToRight();
        switch (this._sidePane.getAttachedSide()) {
            case 3: {
                if (ltr) {
                    this.drawEastPane(g, c, metrics);
                    break;
                }
                this.drawWestPane(g, c, metrics);
                break;
            }
            case 7: {
                if (ltr) {
                    this.drawWestPane(g, c, metrics);
                    break;
                }
                this.drawEastPane(g, c, metrics);
                break;
            }
            case 1: {
                this.drawNorthPane(g, c, metrics);
                break;
            }
            case 5: {
                this.drawSouthPane(g, c, metrics);
            }
        }
    }

    protected void paintItemBackground(SidePaneItem item, Graphics g, Rectangle rect, int side) {
        Color[] colors = this.getGradientColors(item);
        this.getPainter().paintSidePaneItemBackground(this._sidePane, g, rect, colors, side, 0);
    }

    protected Color[] getGradientColors(SidePaneItem item) {
        Color itemBackground = item.getBackground() != null ? item.getBackground() : (this.isItemHighlighted(item) && this._selectedButtonBackground != null ? this._selectedButtonBackground : this._buttonBackground);
        Color[] colors = new Color[]{itemBackground, "true".equals(SecurityUtils.getProperty("shadingtheme", "false")) ? this._background : itemBackground};
        return colors;
    }

    protected boolean isItemHighlighted(SidePaneItem item) {
        return this._highlightSelectedTab && item.getComponent() instanceof DockableFrame && ((DockableFrame)item.getComponent()).isActive();
    }

    protected void drawWestPane(Graphics g, JComponent c, FontMetrics metrics) {
        int indexOfButton = 0;
        int location = this._margin.top;
        int start = this._margin.left;
        int end = c.getWidth() - this._margin.right - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            int startLocation = location++;
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            int widthOfTitle = 0;
            if (!this._alwaysShowText) {
                String longestTitle = group.getLongestTitle();
                widthOfTitle = longestTitle.length() != 0 ? SwingUtilities.computeStringWidth(metrics, longestTitle) + this._textBorderGap : 0;
            }
            int heightOfTitle = metrics.getHeight();
            for (int j = 0; j < group.size(); ++j) {
                Graphics2D g2d;
                SidePaneItem item = (SidePaneItem)group.get(j);
                int oldLocation = location;
                if (this._alwaysShowText) {
                    widthOfTitle = item.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(metrics, item.getTitle()) + this._textBorderGap : 0;
                }
                int iconHeight = 0;
                if (item.getIcon() != null) {
                    iconHeight = this._displayOrientation == 0 ? item.getIcon().getIconHeight() : item.getIcon().getIconWidth();
                }
                int iconWidth = 0;
                if (item.getIcon() != null) {
                    int n = iconWidth = this._displayOrientation == 0 ? item.getIcon().getIconWidth() : item.getIcon().getIconHeight();
                }
                Rectangle rect = this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null ? new Rectangle(start, location, end - 1, 2 + this._itemGap + iconHeight + (widthOfTitle != 0 ? this._iconTextGap : 0) + widthOfTitle) : new Rectangle(start, location, end - 1, 2 + this._itemGap + iconHeight);
                this.paintItemBackground(item, g, rect, 7);
                if (this._displayOrientation == 0) {
                    if (item.getIcon() != null) {
                        item.getIcon().paintIcon(c, g, (end - iconWidth >> 1) + start, location += 2);
                        location += iconHeight;
                    }
                    location += this._itemGap;
                    if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null) {
                        if (item.getTitle().length() != 0) {
                            g2d = (Graphics2D)g.create();
                            g.setFont(item.getFont() == null ? this._font : item.getFont());
                            g2d.rotate(1.5707963267948966);
                            g2d.translate(location += this._iconTextGap, -end);
                            if (item.getForeground() != null) {
                                g2d.setColor(item.getForeground());
                            } else if (this.isItemHighlighted(item)) {
                                g2d.setColor(this._selectedButtonForeground);
                            } else {
                                g2d.setColor(c.getForeground());
                            }
                            JideSwingUtilities.drawString(c, g2d, item.getTitle(), 0, (end - heightOfTitle - start >> 1) + metrics.getAscent() - start);
                            g2d.dispose();
                        }
                        location += widthOfTitle;
                    }
                } else {
                    if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null) {
                        if (item.getTitle().length() != 0) {
                            g2d = (Graphics2D)g.create();
                            g2d.setFont(item.getFont() == null ? this._font : item.getFont());
                            g2d.rotate(-1.5707963267948966);
                            g2d.translate(-((location += this._iconTextGap) + widthOfTitle), 0);
                            if (item.getForeground() != null) {
                                g2d.setColor(item.getForeground());
                            } else if (this.isItemHighlighted(item)) {
                                g2d.setColor(this._selectedButtonForeground);
                            } else {
                                g2d.setColor(c.getForeground());
                            }
                            JideSwingUtilities.drawString(c, g2d, item.getTitle(), 0, (end - heightOfTitle - start >> 1) + metrics.getAscent() - start);
                            g2d.dispose();
                        }
                        location += widthOfTitle;
                    }
                    g2d = (Graphics2D)g.create();
                    g2d.rotate(-1.5707963267948966);
                    g2d.translate(-((location += this._itemGap) + iconHeight), -(location - (end - iconWidth >> 1) - start));
                    if (item.getIcon() != null) {
                        item.getIcon().paintIcon(c, g2d, end >> 1 - iconWidth + start, location);
                        location += iconHeight;
                        location += 2;
                    }
                    g2d.dispose();
                }
                g.setColor(this._lineColor);
                if (this.isRoundedCorner()) {
                    if (j == 0) {
                        g.drawLine(start, startLocation, end - 2, startLocation);
                        g.drawLine(end - 1, startLocation + 1, end - 1, startLocation + 1);
                    }
                    g.drawLine(end - 1, oldLocation, end - 1, oldLocation);
                    g.drawLine(end, oldLocation + 1, end, location - 2);
                    g.drawLine(end - 1, location - 1, end - 1, location - 1);
                    g.drawLine(start, location, end - 2, location);
                } else {
                    if (j == 0) {
                        g.drawLine(start, startLocation, end, startLocation);
                    }
                    g.drawLine(end, oldLocation, end, location);
                    g.drawLine(start, location, end, location);
                }
                this._rects[indexOfButton].x = start + 1;
                this._rects[indexOfButton].y = oldLocation;
                this._rects[indexOfButton].width = end - start + 1;
                this._rects[indexOfButton].height = location - oldLocation;
                ++indexOfButton;
                ++location;
            }
            location += this._groupGap;
        }
    }

    protected void drawEastPane(Graphics g, JComponent c, FontMetrics metrics) {
        int indexOfButton = 0;
        int location = this._margin.top;
        int start = this._margin.right;
        int end = c.getWidth() - this._margin.left - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            int startLocation = location++;
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            int widthOfTitle = 0;
            if (!this._alwaysShowText) {
                String longestTitle = group.getLongestTitle();
                widthOfTitle = longestTitle.length() != 0 ? SwingUtilities.computeStringWidth(metrics, longestTitle) + this._textBorderGap : 0;
            }
            int heightOfTitle = metrics.getHeight();
            for (int j = 0; j < group.size(); ++j) {
                Graphics2D g2d;
                SidePaneItem item = (SidePaneItem)group.get(j);
                int oldLocation = location;
                if (this._alwaysShowText) {
                    widthOfTitle = item.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(metrics, item.getTitle()) + this._textBorderGap : 0;
                }
                int iconHeight = 0;
                if (item.getIcon() != null) {
                    iconHeight = this._displayOrientation == 0 ? item.getIcon().getIconHeight() : item.getIcon().getIconWidth();
                }
                int iconWidth = 0;
                if (item.getIcon() != null) {
                    int n = iconWidth = this._displayOrientation == 0 ? item.getIcon().getIconWidth() : item.getIcon().getIconHeight();
                }
                Rectangle rect = this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null ? new Rectangle(start + 1, location, end, 2 + this._itemGap + iconHeight + (widthOfTitle != 0 ? this._iconTextGap : 0) + widthOfTitle) : new Rectangle(start + 1, location, end, 2 + this._itemGap + iconHeight);
                this.paintItemBackground(item, g, rect, 3);
                location += 2;
                if (item.getIcon() != null) {
                    if (this._displayOrientation == 0) {
                        item.getIcon().paintIcon(c, g, 1 + (end + start - iconWidth) >> 1, location);
                    } else {
                        g2d = (Graphics2D)g.create();
                        g2d.rotate(1.5707963267948966);
                        g2d.translate(location, -end);
                        item.getIcon().paintIcon(c, g2d, 0, end - start - iconWidth >> 1);
                        g2d.dispose();
                    }
                }
                location += iconHeight;
                location += this._itemGap;
                if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null) {
                    if (item.getTitle().length() != 0) {
                        g2d = (Graphics2D)g.create();
                        g2d.setFont(item.getFont() == null ? this._font : item.getFont());
                        g2d.rotate(1.5707963267948966);
                        g2d.translate(location += this._iconTextGap, -end);
                        if (item.getForeground() != null) {
                            g2d.setColor(item.getForeground());
                        } else if (this.isItemHighlighted(item)) {
                            g2d.setColor(this._selectedButtonForeground);
                        } else {
                            g2d.setColor(c.getForeground());
                        }
                        JideSwingUtilities.drawString(c, g2d, item.getTitle(), 0, (end - start - heightOfTitle >> 1) + metrics.getAscent());
                        g2d.dispose();
                    }
                    location += widthOfTitle;
                }
                g.setColor(this._lineColor);
                if (this.isRoundedCorner()) {
                    if (j == 0) {
                        g.drawLine(start + 2, startLocation, end, startLocation);
                        g.drawLine(start + 1, startLocation + 1, start + 1, startLocation + 1);
                    }
                    g.drawLine(start + 1, oldLocation, start + 1, oldLocation);
                    g.drawLine(start, oldLocation + 1, start, location - 2);
                    g.drawLine(start + 1, location - 1, start + 1, location - 1);
                    g.drawLine(start + 2, location, end, location);
                } else {
                    if (j == 0) {
                        g.drawLine(start, startLocation, end, startLocation);
                    }
                    g.drawLine(start, oldLocation, start, location);
                    g.drawLine(start, location, end, location);
                }
                this._rects[indexOfButton].x = start + 1;
                this._rects[indexOfButton].y = oldLocation;
                this._rects[indexOfButton].width = end - start + 1;
                this._rects[indexOfButton].height = location - oldLocation;
                ++indexOfButton;
                ++location;
            }
            location += this._groupGap;
        }
    }

    protected void drawNorthPane(Graphics g, JComponent c, FontMetrics metrics) {
        int indexOfButton = 0;
        int location = this._margin.top;
        int start = this._margin.left;
        int end = c.getHeight() - this._margin.right - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            int startLocation = location++;
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            int widthOfTitle = 0;
            if (!this._alwaysShowText) {
                String longestTitle = group.getLongestTitle();
                widthOfTitle = longestTitle.length() != 0 ? SwingUtilities.computeStringWidth(metrics, longestTitle) + this._textBorderGap : 0;
            }
            int heightOfTitle = metrics.getHeight();
            for (int j = 0; j < group.size(); ++j) {
                SidePaneItem item = (SidePaneItem)group.get(j);
                int oldLocation = location;
                if (this._alwaysShowText) {
                    int n = widthOfTitle = item.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(metrics, item.getTitle()) + this._textBorderGap : 0;
                }
                Rectangle rect = this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null ? new Rectangle(location, start, this._itemGap + (item.getIcon() == null ? 0 : item.getIcon().getIconWidth() + 2) + (widthOfTitle != 0 ? this._iconTextGap : 0) + widthOfTitle, end - 1) : new Rectangle(location, start, this._itemGap + (item.getIcon() == null ? 0 : item.getIcon().getIconWidth() + 2), end - 1);
                this.paintItemBackground(item, g, rect, 1);
                if (item.getIcon() != null) {
                    item.getIcon().paintIcon(c, g, location += 2, (end - item.getIcon().getIconHeight() >> 1) + start);
                    location += item.getIcon().getIconWidth();
                }
                location += this._itemGap;
                if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null) {
                    if (item.getTitle().length() != 0) {
                        location += this._iconTextGap;
                        g.setFont(item.getFont() == null ? this._font : item.getFont());
                        if (item.getForeground() != null) {
                            g.setColor(item.getForeground());
                        } else if (this.isItemHighlighted(item)) {
                            g.setColor(this._selectedButtonForeground);
                        } else {
                            g.setColor(c.getForeground());
                        }
                        JideSwingUtilities.drawString(c, g, item.getTitle(), location, (end + start - heightOfTitle >> 1) + metrics.getAscent());
                    }
                    location += widthOfTitle;
                }
                g.setColor(this._lineColor);
                if (this.isRoundedCorner()) {
                    if (j == 0) {
                        g.drawLine(startLocation, start, startLocation, end - 2);
                        g.drawLine(startLocation + 1, end - 1, startLocation + 1, end - 1);
                    }
                    g.drawLine(oldLocation, end - 1, oldLocation, end - 1);
                    g.drawLine(oldLocation + 1, end, location - 2, end);
                    g.drawLine(location - 1, end - 1, location - 1, end - 1);
                    g.drawLine(location, start, location, end - 2);
                } else {
                    if (j == 0) {
                        g.drawLine(startLocation, start, startLocation, end);
                    }
                    g.drawLine(oldLocation, end, location, end);
                    g.drawLine(location, start, location, end);
                }
                this._rects[indexOfButton].y = start + 1;
                this._rects[indexOfButton].x = oldLocation;
                this._rects[indexOfButton].height = end - start + 1;
                this._rects[indexOfButton].width = location - oldLocation;
                ++indexOfButton;
                ++location;
            }
            location += this._groupGap;
        }
    }

    protected void drawSouthPane(Graphics g, JComponent c, FontMetrics metrics) {
        int indexOfButton = 0;
        int location = this._margin.top;
        int start = this._margin.right;
        int end = c.getHeight() - this._margin.left - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            int startLocation = location++;
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            int widthOfTitle = 0;
            if (!this._alwaysShowText) {
                String longestTitle = group.getLongestTitle();
                widthOfTitle = longestTitle.length() != 0 ? SwingUtilities.computeStringWidth(metrics, longestTitle) + this._textBorderGap : 0;
            }
            int heightOfTitle = metrics.getHeight();
            for (int j = 0; j < group.size(); ++j) {
                SidePaneItem item = (SidePaneItem)group.get(j);
                int oldLocation = location;
                if (this._alwaysShowText) {
                    int n = widthOfTitle = item.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(metrics, item.getTitle()) + this._textBorderGap : 0;
                }
                Rectangle rect = this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null ? new Rectangle(location, start + 1, this._itemGap + (item.getIcon() == null ? 0 : item.getIcon().getIconWidth() + 2) + (widthOfTitle != 0 ? this._iconTextGap : 0) + widthOfTitle, end - 1) : new Rectangle(location, start + 1, this._itemGap + (item.getIcon() == null ? 0 : item.getIcon().getIconWidth() + 2), end - 1);
                this.paintItemBackground(item, g, rect, 5);
                if (item.getIcon() != null) {
                    item.getIcon().paintIcon(c, g, location += 2, (end + start - item.getIcon().getIconHeight() >> 1) + 1);
                    location += item.getIcon().getIconWidth();
                }
                location += this._itemGap;
                if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item) || item.getIcon() == null) {
                    if (item.getTitle().length() != 0) {
                        location += this._iconTextGap;
                        g.setFont(item.getFont() == null ? this._font : item.getFont());
                        if (item.getForeground() != null) {
                            g.setColor(item.getForeground());
                        } else if (this.isItemHighlighted(item)) {
                            g.setColor(this._selectedButtonForeground);
                        } else {
                            g.setColor(c.getForeground());
                        }
                        JideSwingUtilities.drawString(c, g, item.getTitle(), location, (end + start - heightOfTitle >> 1) + metrics.getAscent() + 1);
                    }
                    location += widthOfTitle;
                }
                g.setColor(this._lineColor);
                if (this.isRoundedCorner()) {
                    if (j == 0) {
                        g.drawLine(startLocation, start + 2, startLocation, end);
                        g.drawLine(startLocation + 1, start + 1, startLocation + 1, start + 1);
                    }
                    g.drawLine(oldLocation, start + 1, oldLocation, start + 1);
                    g.drawLine(oldLocation + 1, start, location - 2, start);
                    g.drawLine(location - 1, start + 1, location - 1, start + 1);
                    g.drawLine(location, start + 2, location, end);
                } else {
                    if (j == 0) {
                        g.drawLine(startLocation, start, startLocation, end);
                    }
                    g.drawLine(oldLocation, start, location, start);
                    g.drawLine(location, start, location, end);
                }
                this._rects[indexOfButton].y = start + 1;
                this._rects[indexOfButton].x = oldLocation;
                this._rects[indexOfButton].height = end - start + 1;
                this._rects[indexOfButton].width = location - oldLocation;
                ++indexOfButton;
                ++location;
            }
            location += this._groupGap;
        }
    }

    protected void paintBackground(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            int width = c.getWidth();
            int height = c.getHeight();
            g.setColor(this._background);
            g.fillRect(0, 0, width, height);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this._sidePane.getGroups() != null && this._sidePane.getGroups().size() > 0) {
            switch (this._sidePane.getAttachedSide()) {
                case 3: 
                case 7: {
                    return new Dimension(this._size, this.getPreferredHeightVertical());
                }
                case 1: 
                case 5: {
                    return new Dimension(this.getPreferredWidthHorizontal(), this._size);
                }
            }
        }
        return new Dimension(0, 0);
    }

    protected int getPreferredWidthHorizontal() {
        FontMetrics metrics = this.getFontMetrics();
        int location = this._margin.top;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            ++location;
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            int widthOfTitle = 0;
            if (!this._alwaysShowText) {
                String longestTitle = group.getLongestTitle();
                widthOfTitle = longestTitle.length() != 0 ? SwingUtilities.computeStringWidth(metrics, longestTitle) + this._textBorderGap : 0;
            }
            for (int j = 0; j < group.size(); ++j) {
                SidePaneItem item = (SidePaneItem)group.get(j);
                if (this._alwaysShowText) {
                    int n = widthOfTitle = item.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(metrics, item.getTitle()) + this._textBorderGap : 0;
                }
                if (item.getIcon() != null) {
                    location += 2;
                    location += item.getIcon().getIconWidth();
                }
                location += this._itemGap;
                if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item)) {
                    if (item.getTitle().length() != 0) {
                        location += this._iconTextGap;
                    }
                    location += widthOfTitle;
                }
                ++location;
            }
            location += this._groupGap;
        }
        return location;
    }

    protected int getPreferredHeightVertical() {
        FontMetrics metrics = this.getFontMetrics();
        int location = this._margin.top;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            ++location;
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            int widthOfTitle = 0;
            if (!this._alwaysShowText) {
                String longestTitle = group.getLongestTitle();
                widthOfTitle = longestTitle.length() != 0 ? SwingUtilities.computeStringWidth(metrics, longestTitle) + this._textBorderGap : 0;
            }
            for (int j = 0; j < group.size(); ++j) {
                SidePaneItem item = (SidePaneItem)group.get(j);
                if (this._alwaysShowText) {
                    int n = widthOfTitle = item.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(metrics, item.getTitle()) + this._textBorderGap : 0;
                }
                if (item.getIcon() != null) {
                    int iconHeight = this._displayOrientation == 0 ? item.getIcon().getIconHeight() : item.getIcon().getIconWidth();
                    location += 2;
                    location += iconHeight;
                }
                location += this._itemGap;
                if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item)) {
                    if (item.getTitle().length() != 0) {
                        location += this._iconTextGap;
                    }
                    location += widthOfTitle;
                }
                ++location;
            }
            location += this._groupGap;
        }
        return location;
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected boolean isRoundedCorner() {
        return "true".equals(SecurityUtils.getProperty("shadingtheme", "false"));
    }

    class DropListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            MouseEvent event = new MouseEvent(BasicSidePaneUI.this._sidePane, 506, 0L, 0, dtde.getLocation().x, dtde.getLocation().y, 0, false);
            BasicSidePaneUI.this._inputListener.mouseMoved(event);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
        }
    }

    class RolloverMouseInputListener
    implements MouseInputListener {
        private SidePaneItem _oldSelectedItem = null;

        RolloverMouseInputListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int index = BasicSidePaneUI.this.getSelectedItemIndex(e.getPoint());
            SidePaneItem item = BasicSidePaneUI.this.getItemForIndex(index);
            if (item != null) {
                item.getMouseListener().mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int index = BasicSidePaneUI.this.getSelectedItemIndex(e.getPoint());
            SidePaneItem item = BasicSidePaneUI.this.getItemForIndex(index);
            if (item != null) {
                item.getMouseListener().mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int index = BasicSidePaneUI.this.getSelectedItemIndex(e.getPoint());
            SidePaneItem item = BasicSidePaneUI.this.getItemForIndex(index);
            if (item != null) {
                item.getMouseListener().mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this._oldSelectedItem != null) {
                this._oldSelectedItem.getMouseListener().mouseExited(e);
                this._oldSelectedItem = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int index = BasicSidePaneUI.this.getSelectedItemIndex(e.getPoint());
            SidePaneItem item = BasicSidePaneUI.this.getItemForIndex(index);
            if (item == null) {
                this.resetOldSelectedItem(e);
                return;
            }
            if (!item.equals(this._oldSelectedItem)) {
                this.resetOldSelectedItem(e);
                item.getMouseListener().mouseEntered(e);
                this._oldSelectedItem = item;
            }
            item.getMouseListener().mouseMoved(e);
            SidePaneGroup group = BasicSidePaneUI.this.getGroupForIndex(index);
            group.setSelectedItem(item);
            BasicSidePaneUI.this._sidePane.repaint();
        }

        private void resetOldSelectedItem(MouseEvent e) {
            if (this._oldSelectedItem != null) {
                this._oldSelectedItem.getMouseListener().mouseExited(e);
                this._oldSelectedItem = null;
            }
        }
    }

    class NonrolloverMouseInputListener
    implements MouseInputListener {
        private SidePaneItem _oldSelectedItem = null;

        NonrolloverMouseInputListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int index = BasicSidePaneUI.this.getSelectedItemIndex(e.getPoint());
            SidePaneItem item = BasicSidePaneUI.this.getItemForIndex(index);
            if (item == null) {
                this.resetOldSelectedItem(e);
                return;
            }
            if (!item.equals(this._oldSelectedItem)) {
                this.resetOldSelectedItem(e);
                this._oldSelectedItem = item;
                SidePaneGroup group = BasicSidePaneUI.this.getGroupForIndex(index);
                group.setSelectedItem(item);
                BasicSidePaneUI.this._sidePane.repaint();
            }
            item.getMouseListener().mouseEntered(e);
            item.getMouseListener().mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int index = BasicSidePaneUI.this.getSelectedItemIndex(e.getPoint());
            SidePaneItem item = BasicSidePaneUI.this.getItemForIndex(index);
            if (item != null) {
                item.getMouseListener().mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int index = BasicSidePaneUI.this.getSelectedItemIndex(e.getPoint());
            SidePaneItem item = BasicSidePaneUI.this.getItemForIndex(index);
            if (item != null) {
                item.getMouseListener().mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void resetOldSelectedItem(MouseEvent e) {
            if (this._oldSelectedItem != null) {
                this._oldSelectedItem.getMouseListener().mouseExited(e);
                this._oldSelectedItem = null;
            }
        }
    }
}

