/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.plaf.DockableFrameUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.plaf.basic.ThemePainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;

public class BasicDockableFrameUI
extends DockableFrameUI {
    protected DockableFrame _frame;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _dockableFrameLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected BasicDockableFrameTitlePane _titlePane;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;
    private ThemePainter _painter;

    public static ComponentUI createUI(JComponent b) {
        return new BasicDockableFrameUI((DockableFrame)b);
    }

    public BasicDockableFrameUI() {
    }

    public BasicDockableFrameUI(DockableFrame f) {
        this._frame = f;
    }

    @Override
    public void installUI(JComponent c) {
        this._frame = (DockableFrame)c;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        this._frame.setOpaque(true);
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this._frame == null) {
            return;
        }
        if (c != this._frame) {
            throw new IllegalComponentStateException(this + " was asked to uninstall() " + c + " when it only knows about " + this._frame + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._frame = null;
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        Container contentPane = this._frame.getContentPane();
        if (contentPane instanceof JComponent) {
            ((JComponent)contentPane).setOpaque(false);
        }
        this._dockableFrameLayout = this.createLayoutManager();
        this._frame.setLayout(this._dockableFrameLayout);
        this._frame.setBackground(UIDefaultsLookup.getColor("DockableFrame.background"));
        LookAndFeel.installBorder(this._frame, "DockableFrame.border");
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._frame, actionMap);
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIDefaultsLookup.get("DockableFrame.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("DockableFrame.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        return new ActionMapUIResource();
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this._frame));
        this.setSouthPane(this.createSouthPane(this._frame));
        this.setEastPane(this.createEastPane(this._frame));
        this.setWestPane(this.createWestPane(this._frame));
    }

    protected void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._frame.addPropertyChangeListener(this._propertyChangeListener);
    }

    InputMap getInputMap(int condition) {
        if (condition == 2) {
            return this.createInputMap(condition);
        }
        return null;
    }

    InputMap createInputMap(int condition) {
        Object[] bindings;
        if (condition == 2 && (bindings = (Object[])UIDefaultsLookup.get("DockableFrame.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._frame, bindings);
        }
        return null;
    }

    protected void uninstallDefaults() {
        this._dockableFrameLayout = null;
        this._frame.setLayout(null);
        LookAndFeel.uninstallBorder(this._frame);
        this._painter = null;
    }

    protected void uninstallComponents() {
        if (this._titlePane != null) {
            this._titlePane.uninstallTitlePane();
            this._titlePane = null;
        }
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
    }

    protected void uninstallListeners() {
        this._frame.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this._frame, 2, null);
        SwingUtilities.replaceUIActionMap(this._frame, null);
    }

    @Override
    public Component getTitlePane() {
        return this._northPane;
    }

    protected LayoutManager createLayoutManager() {
        return new DockableFrameLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new DockableFramePropertyChangeListener();
    }

    @Override
    public Dimension getPreferredSize(JComponent x) {
        if (this._frame == x) {
            return this._frame.getLayout().preferredLayoutSize(x);
        }
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getMinimumSize(JComponent x) {
        if (this._frame == x) {
            return this._frame.getLayout().minimumLayoutSize(x);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent x) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent currentPane, JComponent newPane) {
        if (currentPane != null) {
            this.deinstallMouseHandlers(currentPane);
            this._frame.remove(currentPane);
        }
        if (newPane != null) {
            this._frame.add(newPane);
            this.installMouseHandlers(newPane);
        }
    }

    protected void deinstallMouseHandlers(JComponent c) {
    }

    protected void installMouseHandlers(JComponent c) {
    }

    protected JComponent createNorthPane(DockableFrame w) {
        this._titlePane = new BasicDockableFrameTitlePane(w);
        return this._titlePane;
    }

    protected JComponent createSouthPane(DockableFrame w) {
        return null;
    }

    protected JComponent createWestPane(DockableFrame w) {
        return null;
    }

    protected JComponent createEastPane(DockableFrame w) {
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingRegistered(boolean b) {
        this.keyBindingRegistered = b;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final void setKeyBindingActive(boolean b) {
        this.keyBindingActive = b;
    }

    protected void setupMenuOpenKey() {
        InputMap map = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this._frame, 2, map);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this._northPane;
    }

    protected void setNorthPane(JComponent c) {
        if (this._northPane != null && this._northPane instanceof BasicDockableFrameTitlePane) {
            ((BasicDockableFrameTitlePane)this._northPane).uninstallListeners();
        }
        this.replacePane(this._northPane, c);
        this._northPane = c;
    }

    public JComponent getSouthPane() {
        return this._southPane;
    }

    protected void setSouthPane(JComponent c) {
        this._southPane = c;
    }

    public JComponent getWestPane() {
        return this._westPane;
    }

    protected void setWestPane(JComponent c) {
        this._westPane = c;
    }

    public JComponent getEastPane() {
        return this._eastPane;
    }

    protected void setEastPane(JComponent c) {
        this._eastPane = c;
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        ThemePainter painter = this.getPainter();
        if (painter != null) {
            painter.paintDockableFrameBackground(c, g, new Rectangle(0, 0, c.getWidth(), c.getHeight()), 0, 0);
        }
    }

    public class DockableFrameLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Dimension d;
            Insets i = BasicDockableFrameUI.this._frame.getInsets();
            Dimension result = !BasicDockableFrameUI.this._frame.isShowContentPane() ? new Dimension(0, 0) : (BasicDockableFrameUI.this._frame.getRootPane() == null || !BasicDockableFrameUI.this._frame.getRootPane().isVisible() ? new Dimension() : BasicDockableFrameUI.this._frame.getRootPane().getPreferredSize());
            result.width += i.left + i.right;
            result.height += i.top + i.bottom;
            if (BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                d = BasicDockableFrameUI.this.getNorthPane().getPreferredSize();
                result.width = Math.max(d.width, result.width);
                result.height += d.height;
            }
            if (BasicDockableFrameUI.this.getSouthPane() != null) {
                d = BasicDockableFrameUI.this.getSouthPane().getPreferredSize();
                result.width = Math.max(d.width, result.width);
                result.height += d.height;
            }
            if (BasicDockableFrameUI.this.getEastPane() != null) {
                d = BasicDockableFrameUI.this.getEastPane().getPreferredSize();
                result.width += d.width;
                result.height = Math.max(d.height, result.height);
            }
            if (BasicDockableFrameUI.this.getWestPane() != null) {
                d = BasicDockableFrameUI.this.getWestPane().getPreferredSize();
                result.width += d.width;
                result.height = Math.max(d.height, result.height);
            }
            return result;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Dimension alter;
            Dimension result = new Dimension();
            if (BasicDockableFrameUI.this._frame.isShowTitleBar() && BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this.getNorthPane() instanceof BasicDockableFrameTitlePane) {
                result = new Dimension(BasicDockableFrameUI.this.getNorthPane().getMinimumSize());
            }
            Dimension dimension = !BasicDockableFrameUI.this._frame.isShowContentPane() ? new Dimension(0, 0) : (alter = BasicDockableFrameUI.this._frame.getRootPane() == null || !BasicDockableFrameUI.this._frame.getRootPane().isVisible() ? new Dimension() : BasicDockableFrameUI.this._frame.getRootPane().getMinimumSize());
            if (alter.width > result.width) {
                result.width = alter.width;
            }
            result.height += alter.height;
            Insets i = BasicDockableFrameUI.this._frame.getInsets();
            result.width += i.left + i.right;
            result.height += i.top + i.bottom;
            return result;
        }

        @Override
        public void layoutContainer(Container c) {
            Dimension size;
            Insets i = BasicDockableFrameUI.this._frame.getInsets();
            int cx = i.left;
            int cy = i.top;
            int cw = BasicDockableFrameUI.this._frame.getWidth() - i.left - i.right;
            int ch = BasicDockableFrameUI.this._frame.getHeight() - i.top - i.bottom;
            if (BasicDockableFrameUI.this.getNorthPane() != null && !BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                BasicDockableFrameUI.this.getNorthPane().setVisible(false);
            } else if (BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                BasicDockableFrameUI.this.getNorthPane().setVisible(true);
                size = BasicDockableFrameUI.this.getNorthPane().getPreferredSize();
                BasicDockableFrameUI.this.getNorthPane().setBounds(cx, cy, cw, size.height);
                cy += size.height;
                ch -= size.height;
            }
            if (BasicDockableFrameUI.this.getSouthPane() != null) {
                size = BasicDockableFrameUI.this.getSouthPane().getPreferredSize();
                BasicDockableFrameUI.this.getSouthPane().setBounds(cx, BasicDockableFrameUI.this._frame.getHeight() - i.bottom - size.height, cw, size.height);
                ch -= size.height;
            }
            if (BasicDockableFrameUI.this.getWestPane() != null) {
                size = BasicDockableFrameUI.this.getWestPane().getPreferredSize();
                BasicDockableFrameUI.this.getWestPane().setBounds(cx, cy, size.width, ch);
                cw -= size.width;
                cx += size.width;
            }
            if (BasicDockableFrameUI.this.getEastPane() != null) {
                size = BasicDockableFrameUI.this.getEastPane().getPreferredSize();
                BasicDockableFrameUI.this.getEastPane().setBounds(cw - size.width, cy, size.width, ch);
                cw -= size.width;
            }
            if (BasicDockableFrameUI.this._frame.getRootPane() != null) {
                if (BasicDockableFrameUI.this._frame.isShowContentPane() && BasicDockableFrameUI.this._frame.getRootPane().isVisible()) {
                    BasicDockableFrameUI.this._frame.getRootPane().setBounds(cx, cy, cw, ch);
                } else {
                    BasicDockableFrameUI.this._frame.getRootPane().setBounds(cx, cy, cw, 0);
                }
            }
        }
    }

    public class DockableFramePropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            Object source = evt.getSource();
            if (!(source instanceof DockableFrame)) {
                return;
            }
            DockableFrame f = (DockableFrame)source;
            Object newValue = evt.getNewValue();
            if ("docked".equals(prop)) {
                if (Boolean.TRUE.equals(newValue)) {
                    LookAndFeel.installBorder(BasicDockableFrameUI.this._frame, "DockableFrame.border");
                }
            } else if ("autohideShowing".equals(prop)) {
                if (Boolean.TRUE.equals(newValue) && f.isSlidingAutohide()) {
                    f.applyComponentOrientation(f.getDockingManager().getDockedFrameContainer().getComponentOrientation());
                    boolean ltr = f.getComponentOrientation().isLeftToRight();
                    switch (f.getContext().getCurrentDockSide()) {
                        case 1: {
                            LookAndFeel.installBorder(f, "DockableFrame.slidingNorthBorder");
                            break;
                        }
                        case 2: {
                            LookAndFeel.installBorder(f, "DockableFrame.slidingSouthBorder");
                            break;
                        }
                        case 4: {
                            LookAndFeel.installBorder(f, ltr ? "DockableFrame.slidingEastBorder" : "DockableFrame.slidingWestBorder");
                            break;
                        }
                        case 8: {
                            LookAndFeel.installBorder(f, ltr ? "DockableFrame.slidingWestBorder" : "DockableFrame.slidingEastBorder");
                        }
                    }
                }
            } else if ("title".equals(prop)) {
                Dimension dim = BasicDockableFrameUI.this._frame.getMinimumSize();
                Dimension frame_dim = BasicDockableFrameUI.this._frame.getSize();
                if (dim.width > frame_dim.width) {
                    BasicDockableFrameUI.this._frame.setSize(dim.width, frame_dim.height);
                }
            } else if ("showContentPane".equals(prop)) {
                BasicDockableFrameUI.this._frame.invalidate();
            }
        }
    }
}

