/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SlidingOverFrameContainer
extends JPanel {
    protected static boolean DEBUG = false;
    protected HashMap<Component, SlidingFrameConstraint> _constraints;
    protected Rectangle rectDebug = new Rectangle();
    protected Container _contentPane = null;
    protected static final Dimension MIN_DIM = new Dimension(0, 0);
    protected static final Dimension MAX_DIM = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public SlidingOverFrameContainer(Container contentPane) {
        super(null);
        this.setLayout(new SlidingFrameLayout());
        this.setOpaque(false);
        this._contentPane = contentPane;
        this._constraints = new HashMap();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(constraints instanceof SlidingFrameConstraint)) {
            throw new IllegalArgumentException("constraint must be of type " + SlidingFrameConstraint.class.getName());
        }
        this._constraints.put(comp, (SlidingFrameConstraint)constraints);
        super.addImpl(comp, constraints, index);
    }

    @Override
    public void remove(int index) {
        Component c = this.getComponent(index);
        super.remove(index);
        this.release(c);
    }

    private void release(Component comp) {
        this._constraints.remove(comp);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (DEBUG) {
            Graphics2D g2 = (Graphics2D)g;
            this.paintRect(g2);
        }
    }

    protected void paintRect(Graphics2D g2) {
        if (this.getComponentCount() < 1) {
            return;
        }
        Composite orgComposite = g2.getComposite();
        Color orgColor = g2.getColor();
        g2.setComposite(AlphaComposite.getInstance(3, 0.15f));
        g2.setColor(Color.BLUE);
        g2.fillRect(this.rectDebug.x, this.rectDebug.y, this.rectDebug.width, this.rectDebug.height);
        g2.setColor(Color.RED);
        g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
        Rectangle rectBounds = new Rectangle();
        for (int i = 0; i < this.getComponents().length; ++i) {
            Component comp = this.getComponent(i);
            rectBounds = comp.getBounds(rectBounds);
            g2.fillRoundRect(rectBounds.x, rectBounds.y, rectBounds.width, rectBounds.height, 4, 4);
        }
        g2.setColor(orgColor);
        g2.setComposite(orgComposite);
    }

    public Rectangle computeLayoutBounds(Component dockingComponent, DockableFrame f, int side, boolean ltr) {
        Container parentComponent = dockingComponent.getParent();
        Rectangle targetBounds = SwingUtilities.convertRectangle(parentComponent, parentComponent.getBounds(), parentComponent);
        if (DEBUG) {
            this.rectDebug = targetBounds;
            this.repaint();
        }
        switch (side) {
            case 4: {
                if (ltr) {
                    targetBounds.width = Math.min(parentComponent.getWidth(), f.getAutohideWidth());
                    targetBounds.x += parentComponent.getWidth() - targetBounds.width;
                    break;
                }
                targetBounds.width = Math.min(parentComponent.getWidth(), f.getAutohideWidth());
                break;
            }
            case 8: {
                if (ltr) {
                    targetBounds.width = Math.min(parentComponent.getWidth(), f.getAutohideWidth());
                    break;
                }
                targetBounds.width = Math.min(parentComponent.getWidth(), f.getAutohideWidth());
                targetBounds.x += parentComponent.getWidth() - targetBounds.width;
                break;
            }
            case 2: {
                targetBounds.height = Math.min(parentComponent.getHeight(), f.getAutohideHeight());
                targetBounds.y += parentComponent.getHeight() - targetBounds.height;
                break;
            }
            case 1: {
                targetBounds.height = Math.min(parentComponent.getHeight(), f.getAutohideHeight());
            }
        }
        return targetBounds;
    }

    @Override
    public boolean contains(int x, int y) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            Point p = SwingUtilities.convertPoint(this, x, y, comp);
            if (!comp.contains(p.x, p.y)) continue;
            return true;
        }
        return false;
    }

    protected class SlidingFrameLayout
    implements LayoutManager2 {
        protected Rectangle _stepBounds = new Rectangle();

        protected SlidingFrameLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateLayout(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Component[] comps;
                for (Component comp : comps = SlidingOverFrameContainer.this.getComponents()) {
                    this.setupContainer(target, comp, SlidingOverFrameContainer.this._constraints.get(comp));
                }
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return MAX_DIM;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return MIN_DIM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return SlidingOverFrameContainer.this.getSize();
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Component[] comps;
                for (Component comp : comps = SlidingOverFrameContainer.this.getComponents()) {
                    this.setupContainer(parent, comp, SlidingOverFrameContainer.this._constraints.get(comp));
                }
            }
        }

        public void setupContainer(Container parent, Component component, SlidingFrameConstraint constraint) {
            if (constraint == null) {
                return;
            }
            Rectangle targetBounds = SlidingOverFrameContainer.this.computeLayoutBounds(constraint.dockingComponent, constraint.frame, constraint.side, constraint.isLeftToRight);
            this._stepBounds.setBounds(targetBounds);
            switch (constraint.side) {
                case 4: {
                    if (constraint.isLeftToRight) {
                        this._stepBounds.width = constraint.currentStep * targetBounds.width / constraint.steps;
                        this._stepBounds.x = targetBounds.x + targetBounds.width - this._stepBounds.width;
                        break;
                    }
                    this._stepBounds.width = constraint.currentStep * targetBounds.width / constraint.steps;
                    break;
                }
                case 8: {
                    if (constraint.isLeftToRight) {
                        this._stepBounds.width = constraint.currentStep * targetBounds.width / constraint.steps;
                        break;
                    }
                    this._stepBounds.width = constraint.currentStep * targetBounds.width / constraint.steps;
                    this._stepBounds.x = targetBounds.x + targetBounds.width - this._stepBounds.width;
                    break;
                }
                case 2: {
                    this._stepBounds.height = constraint.currentStep * targetBounds.height / constraint.steps;
                    this._stepBounds.y = targetBounds.y + targetBounds.height - this._stepBounds.height;
                    break;
                }
                case 1: {
                    this._stepBounds.height = constraint.currentStep * targetBounds.height / constraint.steps;
                }
            }
            if (SystemInfo.isJdk6u14Above()) {
                Rectangle bounds = this._stepBounds;
                Point p = bounds.getLocation();
                try {
                    Window parentWindow = SwingUtilities.getWindowAncestor(SlidingOverFrameContainer.this);
                    p = SwingUtilities.convertPoint(SlidingOverFrameContainer.this, p, parentWindow);
                    Rectangle2D rectangle = new Rectangle();
                    if (constraint.frame.isAutohideShowing()) {
                        rectangle = new Rectangle2D.Float(p.x, p.y, bounds.width, bounds.height);
                    }
                    Class<?> awtUtilities = Class.forName("com.sun.awt.AWTUtilities");
                    Method method = awtUtilities.getMethod("setComponentMixingCutoutShape", Component.class, Shape.class);
                    method.invoke(null, SlidingOverFrameContainer.this, rectangle);
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            component.setBounds(this._stepBounds);
        }
    }

    public class SlidingFrameConstraint {
        public DockableFrame frame;
        public Component dockingComponent;
        public int steps;
        public int currentStep;
        public int side;
        public boolean isLeftToRight;
        public boolean opening;
    }
}

