/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.ContentContainer;
import java.awt.LayoutManager;
import javax.swing.RootPaneContainer;

public class DockableHolderPanel
extends ContentContainer
implements DockableHolder {
    private DockingManager _dockingManager;
    private boolean _outsideCallChecking = false;

    public DockableHolderPanel() {
        this((RootPaneContainer)null);
    }

    public DockableHolderPanel(RootPaneContainer container) {
        try {
            this.setOutsideCallChecking(true);
            this._dockingManager = this.createDockingManager(container);
        }
        finally {
            this.setOutsideCallChecking(false);
        }
    }

    private boolean isOutsideCallChecking() {
        return this._outsideCallChecking;
    }

    private void setOutsideCallChecking(boolean outsideCallChecking) {
        this._outsideCallChecking = outsideCallChecking;
    }

    protected DockingManager createDockingManager(RootPaneContainer container) {
        return new DefaultDockingManager(container, this);
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public void dispose() {
        if (this._dockingManager != null) {
            this._dockingManager.dispose();
            this._dockingManager = null;
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.isOutsideCallChecking()) {
            super.setLayout(mgr);
        }
    }
}

