/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.LayoutPersistence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class DefaultWindowDockableHolder
extends JWindow
implements DockableHolder {
    private DockingManager _dockingManager;
    private JPanel _contentContainer;
    protected boolean _autoDispose = true;

    public DefaultWindowDockableHolder() {
        this.initFrame(this.getContentPane());
    }

    public DefaultWindowDockableHolder(GraphicsConfiguration gc) {
        super(gc);
        this.initFrame(this.getContentPane());
    }

    public DefaultWindowDockableHolder(Frame owner) {
        super(owner);
        this.initFrame(this.getContentPane());
    }

    public DefaultWindowDockableHolder(Window owner) {
        super(owner);
        this.initFrame(this.getContentPane());
    }

    public DefaultWindowDockableHolder(Window owner, GraphicsConfiguration gc) {
        super(owner, gc);
        this.initFrame(this.getContentPane());
    }

    private void initFrame(Container container) {
        this.setRootPaneCheckingEnabled(false);
        try {
            container.setLayout(new BorderLayout());
            this._contentContainer = new JPanel();
            container.add((Component)this._contentContainer, "Center");
            this._dockingManager = this.createDockingManager(this._contentContainer);
        }
        finally {
            this.setRootPaneCheckingEnabled(true);
        }
    }

    protected DockingManager createDockingManager(Container contentContainer) {
        return new DefaultDockingManager(this, contentContainer);
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public LayoutPersistence getLayoutPersistence() {
        return this._dockingManager;
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this.isRootPaneCheckingEnabled();
    }

    protected void setContentPaneCheckingEnabled(boolean contentPaneCheckingEnabled) {
        this.setRootPaneCheckingEnabled(contentPaneCheckingEnabled);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isAutoDispose()) {
            this._contentContainer = null;
            if (this._dockingManager != null) {
                this._dockingManager.dispose();
                this._dockingManager = null;
            }
        }
    }

    public boolean isAutoDispose() {
        return this._autoDispose;
    }

    public void setAutoDispose(boolean autoDispose) {
        this._autoDispose = autoDispose;
    }
}

