/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.FloatingDockableBarContainer;
import com.jidesoft.action.MainContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;

public class PreviousState {
    int mode;
    int dockID;
    Rectangle rcBounds;
    public int side;
    boolean newRow;
    public int start;
    public int row;
    int fcID;
    ArrayList fcChildren;
    ArrayList parentStates;

    public static PreviousState createPreviousState(DockableBar f) {
        Container rootContainer;
        PreviousState state = new PreviousState();
        state.mode = f.getContext().getCurrentMode();
        state.dockID = f.getDockID();
        Container parent = f.getParent();
        if (parent instanceof DockableBarContainer) {
            DockableBarContainer dc = (DockableBarContainer)parent;
            DockableBarItem item = dc.getDockableBarList().getDockableBarItemOf(f);
            state.start = item.getStart();
            state.row = item.getRow();
            state.newRow = item.isOnlyOne();
            state.side = dc.getSide();
        }
        if ((rootContainer = PreviousState.getRootContainer(f)) != null) {
            state.rcBounds = rootContainer.getBounds();
        }
        return state;
    }

    public static void disposePreviousState(PreviousState state) {
        if (state == null) {
            return;
        }
        state = null;
    }

    static Container getRootContainer(Component c) {
        if (c instanceof MainContainer) {
            return (MainContainer)c;
        }
        if (c instanceof FloatingDockableBarContainer) {
            return (FloatingDockableBarContainer)c;
        }
        Container parent = c.getParent();
        do {
            if (parent == null) {
                return null;
            }
            if (parent instanceof MainContainer) {
                return parent;
            }
            if (!(parent instanceof FloatingDockableBarContainer)) continue;
            return parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public String toString() {
        return "[" + super.toString() + " \n\tdockID:\t" + this.dockID + " \n\tfcChildren:\t" + this.fcChildren + " \n\tmode:\t" + this.mode + " \n\tnewRow:\t" + this.newRow + " \n\tparentStates:\t" + this.parentStates + " \n\trcBounds:\t" + this.rcBounds + " \n\trow:\t" + this.row + " \n\tside:\t" + this.side + " \n\tstart:\t" + this.start + "]";
    }

    static class ParentState {
        int ccID;
        int myID;
        int orientation;
        ArrayList ccChildren;

        ParentState() {
        }
    }
}

