/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

class DockableBarListList
extends ArrayList<DockableBarList> {
    private static final long serialVersionUID = -8698250099505639117L;
    private Container _target;

    public DockableBarListList(Container target) {
        this._target = target;
    }

    protected DockableBarItem getDockableBarItemOf(Component component) {
        for (int i = 0; i < this.size(); ++i) {
            List row = (List)this.get(i);
            for (int j = 0; j < row.size(); ++j) {
                DockableBarItem item = (DockableBarItem)row.get(j);
                if (!item.getComponent().equals(component)) continue;
                item.setRow(i);
                item.setOnlyOne(row.size() == 1);
                return item;
            }
        }
        return null;
    }

    protected DockableBarItem removeDockableBarItemOf(Component component) {
        for (int i = 0; i < this.size(); ++i) {
            List row = (List)this.get(i);
            for (int j = 0; j < row.size(); ++j) {
                DockableBarItem item = (DockableBarItem)row.get(j);
                if (!item.getComponent().equals(component)) continue;
                row.remove(item);
                return item;
            }
        }
        return null;
    }

    public void setStartLocation(Component component, int newX) {
        DockableBarItem item = this.getDockableBarItemOf(component);
        if (item != null) {
            item.setStart(newX);
            this.doLayout();
        }
    }

    public void removeComponent(Component component) {
        DockableBarItem item = this.removeDockableBarItemOf(component);
        if (item == null) {
            return;
        }
        this.doLayout();
    }

    public DockableBarItem addComponent(Component component, int start) {
        int newRowIndex = this.prepareRows(this.size(), true);
        DockableBarList row = (DockableBarList)this.get(newRowIndex);
        DockableBarItem item = new DockableBarItem(component, start);
        row.add(item);
        item.setRow(newRowIndex);
        return item;
    }

    public DockableBarItem insertComponent(Component component, int newRowIndex, int start) {
        newRowIndex = this.prepareRows(newRowIndex, true);
        DockableBarList row = (DockableBarList)this.get(newRowIndex);
        DockableBarItem item = new DockableBarItem(component, start);
        row.add(item);
        item.setRow(newRowIndex);
        return item;
    }

    public void changeComponentRow(Component component, int newRowIndex, boolean createNewRow, int start) {
        DockableBarItem item = this.getDockableBarItemOf(component);
        item.setDragging(true);
        item.setResizing(false);
        if (start < 0) {
            start = 0;
        }
        int currentRow = item.getRow();
        if (!createNewRow && (currentRow == newRowIndex || ((DockableBarList)this.get(currentRow)).size() == 1 && newRowIndex - currentRow == 1)) {
            item.setStart(start);
            this.doLayout();
        } else {
            ((DockableBarList)this.get(currentRow)).remove(item);
            if (!createNewRow && item.getComponent() instanceof DockableBar && ((DockableBar)item.getComponent()).isStretch()) {
                createNewRow = true;
            }
            if (!createNewRow) {
                Component comp;
                List list;
                if (newRowIndex >= this.size()) {
                    newRowIndex = this.size() - 1;
                }
                if (newRowIndex < 0) {
                    this.add(new DockableBarList(this));
                    newRowIndex = 0;
                }
                if ((list = (List)this.get(newRowIndex)).size() > 0 && (comp = ((DockableBarItem)list.get(0)).getComponent()) instanceof DockableBar && ((DockableBar)comp).isStretch()) {
                    createNewRow = true;
                }
            }
            newRowIndex = this.prepareRows(newRowIndex, createNewRow);
            item.setStart(start);
            if (newRowIndex < this.size()) {
                ((DockableBarList)this.get(newRowIndex)).add(item);
            }
            this.doLayout();
        }
    }

    public void changeComponentStart(Component component, int start) {
        DockableBarItem item = this.getDockableBarItemOf(component);
        item.setDragging(true);
        item.setResizing(true);
        if (start < 0) {
            start = 0;
        }
        item.setStart(start);
        this.doLayout();
    }

    private void doLayout() {
        ((JComponent)this._target).revalidate();
    }

    private int prepareRows(int newRowIndex, boolean newRow) {
        DockableBarList row;
        if (newRowIndex < 0) {
            newRowIndex = 0;
            if (newRow) {
                row = this.createDockableBarList();
                this.add(newRowIndex, row);
            }
        }
        if (newRowIndex >= this.size()) {
            if (newRow) {
                row = this.createDockableBarList();
                this.add(row);
            }
            newRowIndex = this.size() - 1;
        } else if (newRow) {
            row = this.createDockableBarList();
            this.add(newRowIndex, row);
        }
        return newRowIndex;
    }

    private DockableBarList createDockableBarList() {
        return new DockableBarList(this);
    }
}

