/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.Dockable;
import com.jidesoft.action.DockableBarContext;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.event.DockableBarEvent;
import com.jidesoft.action.event.DockableBarListener;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuBar;
import javax.swing.SwingConstants;
import org.w3c.dom.Element;

public abstract class DockableBar
extends JMenuBar
implements Dockable,
SwingConstants,
Alignable {
    private static final Logger LOGGER_EVENT;
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_FLOATABLE = "floatable";
    public static final String PROPERTY_REARRANGABLE = "rearrangable";
    public static final String PROPERTY_STRETCH = "stretch";
    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_HIDDEN = "hidden";
    public static final String PROPERTY_HORI_DOCKED = "horiDocked";
    public static final String PROPERTY_VERT_DOCKED = "vertDocked";
    public static final String PROPERTY_FLOATED = "floating";
    public static final String PROPERTY_INIT_SIDE = "initSide";
    public static final String PROPERTY_INIT_MODE = "initMode";
    public static final String PROPERTY_INIT_INDEX = "initIndex";
    public static final String PROPERTY_INIT_SUBINDEX = "initSubindex";
    public static final String PROPERTY_ALLOWED_DOCK_SIDES = "allowedDockSides";
    public static final String PROPERTY_UNDOCKED_BOUNDS = "undockedBounds";
    private String _key;
    private String _title;
    private DockableBarContext _context;
    private DockableBarManager _dockableBarManager;
    private boolean _floatable = true;
    private boolean _hidable = true;
    private boolean _rearrangeable = true;
    private boolean _stretch = false;
    private int _allowedDockSides = 15;
    protected int _orientation = 0;
    private boolean _duringLayout;
    public static final String PROPERTY_CHEVRON_ALWAYS_VISIBLE = "chevronAlwaysVisible";
    private boolean _chevronAlwaysVisible = true;
    private boolean _paintBackground = true;
    public static final String PROPERTY_PAINT_BACKGROUND = "paintBackground";
    private boolean _menuBar;
    public static final String PROPERTY_MENU_BAR = "menuBar";
    public static final String PROPERTY_AVAILABLE = "available";

    public DockableBar() {
        this("", "");
    }

    public DockableBar(String key) {
        this(key, key);
    }

    public DockableBar(String key, String title) {
        this.setTitle(title);
        this._key = key;
        this._context = new DockableBarContext();
    }

    public DockableBarContext getContext() {
        return this._context;
    }

    public void setContext(DockableBarContext context) {
        this._context = context;
        if (this._context.isFloating()) {
            this.firePropertyChange(PROPERTY_FLOATED, false, true);
        } else if (this._context.isHoriDocked()) {
            this.firePropertyChange(PROPERTY_HORI_DOCKED, false, true);
        } else if (this._context.isVertDocked()) {
            this.firePropertyChange(PROPERTY_VERT_DOCKED, false, true);
        } else if (this._context.isHidden()) {
            this.firePropertyChange(PROPERTY_HIDDEN, false, true);
        }
    }

    public void setKey(String key) {
        String oldKey = this._key;
        this._key = key;
        this.firePropertyChange(PROPERTY_KEY, oldKey, this._key);
        if (this._title == null) {
            this.firePropertyChange(PROPERTY_TITLE, oldKey, key);
        }
    }

    public String getKey() {
        return this._key;
    }

    public void setTitle(String title) {
        String old = this._title;
        if (!JideSwingUtilities.equals(title, this._title)) {
            this._title = title;
            this.firePropertyChange(PROPERTY_TITLE, old, this._title);
        }
    }

    public String getTitle() {
        if (this._title != null) {
            return this._title;
        }
        return this.getKey();
    }

    @Override
    public DockableBarManager getDockableBarManager() {
        return this._dockableBarManager;
    }

    @Override
    public void setDockableBarManager(DockableBarManager dockingManager) {
        this._dockableBarManager = dockingManager;
        if (this._dockableBarManager != null) {
            this.fireDockableBarEvent(4999);
        }
    }

    public boolean isHidden() {
        return this.getContext().isHidden();
    }

    public void setHidden() throws PropertyVetoException {
        Boolean oldValue = this.getContext().isHidden() ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(PROPERTY_HIDDEN, oldValue, Boolean.TRUE);
        this.getContext().setCurrentMode(0);
        this.firePropertyChange(PROPERTY_HIDDEN, oldValue, Boolean.TRUE);
        this.setVisible(false);
        this.fireDockableBarEvent(5002);
    }

    public boolean isFloating() {
        return this.getContext().isFloating();
    }

    public void setFloating() throws PropertyVetoException {
        this.fireVetoableChange(PROPERTY_FLOATED, Boolean.FALSE, Boolean.TRUE);
        boolean wasHidden = this.getContext().isHidden();
        this.getContext().setCurrentMode(1);
        if (wasHidden) {
            this.fireDockableBarEvent(5001);
        }
        this.fireDockableBarEvent(5005);
        this.firePropertyChange(PROPERTY_FLOATED, Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isVertDocked() {
        return this.getContext().isVertDocked();
    }

    public void setVertDocked() throws PropertyVetoException {
        this.fireVetoableChange(PROPERTY_VERT_DOCKED, Boolean.FALSE, Boolean.TRUE);
        boolean wasHidden = this.getContext().isHidden();
        this.getContext().setCurrentMode(3);
        if (wasHidden) {
            this.fireDockableBarEvent(5001);
        }
        this.fireDockableBarEvent(5004);
        this.firePropertyChange(PROPERTY_VERT_DOCKED, Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isHoriDocked() {
        return this.getContext().isHoriDocked();
    }

    public void setHoriDocked() throws PropertyVetoException {
        this.fireVetoableChange(PROPERTY_HORI_DOCKED, Boolean.FALSE, Boolean.TRUE);
        boolean wasHidden = this.getContext().isHidden();
        this.getContext().setCurrentMode(2);
        if (wasHidden) {
            this.fireDockableBarEvent(5001);
        }
        this.fireDockableBarEvent(5003);
        this.firePropertyChange(PROPERTY_HORI_DOCKED, Boolean.FALSE, Boolean.TRUE);
    }

    public void addDockableBarListener(DockableBarListener l) {
        this.listenerList.add(DockableBarListener.class, l);
        this.enableEvents(0L);
    }

    public void removeDockableBarListener(DockableBarListener l) {
        this.listenerList.remove(DockableBarListener.class, l);
    }

    public DockableBarListener[] getDockableBarListeners() {
        return (DockableBarListener[])this.listenerList.getListeners(DockableBarListener.class);
    }

    protected void fireDockableBarEvent(int id) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (id) {
                case 4999: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is added");
                    break;
                }
                case 5000: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is removed");
                    break;
                }
                case 5003: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is horizontally docked");
                    break;
                }
                case 5004: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is vertically docked");
                    break;
                }
                case 5005: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is floating");
                    break;
                }
                case 5001: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is shown");
                    break;
                }
                case 5002: {
                    LOGGER_EVENT.fine("DockableBar \"" + this.getKey() + "\" is hidden");
                    break;
                }
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        AWTEvent e = null;
        block18: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DockableBarListener.class) continue;
            if (e == null) {
                e = new DockableBarEvent(this, id);
            }
            switch (e.getID()) {
                case 4999: {
                    ((DockableBarListener)listeners[i + 1]).dockableBarAdded((DockableBarEvent)e);
                    continue block18;
                }
                case 5000: {
                    ((DockableBarListener)listeners[i + 1]).dockableBarRemoved((DockableBarEvent)e);
                    continue block18;
                }
                case 5003: {
                    ((DockableBarListener)listeners[i + 1]).dockableBarHoriDocked((DockableBarEvent)e);
                    continue block18;
                }
                case 5004: {
                    ((DockableBarListener)listeners[i + 1]).dockableBarVertDocked((DockableBarEvent)e);
                    continue block18;
                }
                case 5005: {
                    ((DockableBarListener)listeners[i + 1]).dockableBarFloating((DockableBarEvent)e);
                    continue block18;
                }
                case 5001: {
                    ((DockableBarListener)listeners[i + 1]).dockableBarShown((DockableBarEvent)e);
                    continue block18;
                }
                case 5002: {
                    ((DockableBarListener)listeners[i + 1]).dockableBarHidden((DockableBarEvent)e);
                    continue block18;
                }
            }
        }
    }

    @Override
    public int getDockID() {
        return this.getContext().getDockID();
    }

    @Override
    public void setDockID(int id) {
        this.getContext().setDockID(id);
    }

    @Override
    public void resetDockID() {
        this.getContext().resetDockID();
        this.getContext().setInitPosition(false);
    }

    public boolean isFloatable() {
        return this._floatable;
    }

    public void setFloatable(boolean b) {
        if (this._floatable != b) {
            boolean old = this._floatable;
            this._floatable = b;
            this.firePropertyChange(PROPERTY_FLOATABLE, old, b);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isRearrangable() {
        return this._rearrangeable;
    }

    public void setRearrangable(boolean b) {
        if (this._rearrangeable != b) {
            boolean old = this._rearrangeable;
            this._rearrangeable = b;
            this.firePropertyChange(PROPERTY_REARRANGABLE, old, b);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isHidable() {
        return this._hidable;
    }

    public void setHidable(boolean b) {
        if (this._hidable != b) {
            boolean old = this._hidable;
            this._hidable = b;
            this.firePropertyChange(PROPERTY_HIDABLE, old, b);
            this.revalidate();
            this.repaint();
        }
    }

    public Rectangle getUndockedBounds() {
        Rectangle bounds = this._context.getUndockedBounds();
        if (bounds == null) {
            bounds = new Rectangle(this.getX() + 10, this.getY() + 10, 0, 0);
            this._context.setUndockedBounds(bounds);
        }
        return bounds;
    }

    public void setUndockedBounds(Rectangle undockedBounds) {
        Rectangle old = this.getContext().getUndockedBounds();
        if (!undockedBounds.equals(old)) {
            this.getContext().setUndockedBounds(undockedBounds);
            this.firePropertyChange(PROPERTY_UNDOCKED_BOUNDS, old, undockedBounds);
        }
    }

    public boolean isStretch() {
        return this._stretch;
    }

    public void setStretch(boolean stretch) {
        if (this._stretch != stretch) {
            boolean old = this._stretch;
            this._stretch = stretch;
            this.firePropertyChange(PROPERTY_STRETCH, old, stretch);
        }
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    @Override
    public void setOrientation(int orientation) {
        this.checkOrientation(orientation);
        if (this._orientation != orientation) {
            int old = this._orientation;
            this._orientation = orientation;
            this.firePropertyChange("orientation", old, orientation);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        LayoutManager oldMgr = this.getLayout();
        if (oldMgr instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)oldMgr));
        }
        super.setLayout(mgr);
    }

    @Override
    public boolean supportVerticalOrientation() {
        return true;
    }

    @Override
    public boolean supportHorizontalOrientation() {
        return true;
    }

    protected void checkOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public int getAllowedDockSides() {
        return this._allowedDockSides;
    }

    public void setAllowedDockSides(int allowedDockSides) {
        int old = this._allowedDockSides;
        if (old != allowedDockSides) {
            this._allowedDockSides = allowedDockSides;
            this.firePropertyChange(PROPERTY_ALLOWED_DOCK_SIDES, old, allowedDockSides);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        JideSwingUtilities.setOrientationOf(comp, this.getOrientation());
        super.addImpl(comp, constraints, index);
    }

    boolean isDuringLayout() {
        return this._duringLayout;
    }

    void setDuringLayout(boolean duringLayout) {
        this._duringLayout = duringLayout;
    }

    public int getInitMode() {
        return this.getContext().getInitMode();
    }

    public void setInitMode(int initMode) {
        int old = this.getContext().getInitMode();
        if (old != initMode) {
            this.getContext().setInitMode(initMode);
            this.firePropertyChange(PROPERTY_INIT_MODE, old, initMode);
        }
    }

    public int getInitSide() {
        return this.getContext().getInitSide();
    }

    public void setInitSide(int initSide) {
        int old = this.getContext().getInitSide();
        if (old != initSide) {
            this.getContext().setInitSide(initSide);
            this.firePropertyChange(PROPERTY_INIT_SIDE, old, initSide);
        }
    }

    public int getInitIndex() {
        return this.getContext().getInitIndex();
    }

    public void setInitIndex(int initIndex) {
        int old = this.getContext().getInitIndex();
        if (old != initIndex) {
            this.getContext().setInitIndex(initIndex);
            this.firePropertyChange(PROPERTY_INIT_INDEX, old, initIndex);
        }
    }

    public int getInitSubindex() {
        return this.getContext().getInitSubindex();
    }

    public void setInitSubindex(int initSubindex) {
        int old = this.getContext().getInitSubindex();
        if (old != initSubindex) {
            this.getContext().setInitSubindex(initSubindex);
            this.firePropertyChange(PROPERTY_INIT_SUBINDEX, old, initSubindex);
        }
    }

    public void readElement(Element element) {
    }

    public void adjustChildrenOrientation(int orientation) {
        JideSwingUtilities.setChildrenOrientationOf(this, orientation);
    }

    public boolean isAvailable() {
        return this.getContext().isAvailable();
    }

    public void setAvailable(boolean avail) {
        if (avail != this.isAvailable()) {
            boolean old = this.isAvailable();
            this.getContext().setAvailable(avail);
            this.firePropertyChange(PROPERTY_AVAILABLE, old, avail);
        }
    }

    public boolean isChevronAlwaysVisible() {
        return this._chevronAlwaysVisible;
    }

    public void setChevronAlwaysVisible(boolean chevronAlwaysVisible) {
        boolean old = this._chevronAlwaysVisible;
        if (chevronAlwaysVisible != this._chevronAlwaysVisible) {
            this._chevronAlwaysVisible = chevronAlwaysVisible;
            this.firePropertyChange(PROPERTY_CHEVRON_ALWAYS_VISIBLE, old, this._chevronAlwaysVisible);
        }
    }

    public boolean isPaintBackground() {
        return this._paintBackground;
    }

    public void setPaintBackground(boolean paintBackground) {
        boolean old = this._paintBackground;
        if (paintBackground != old) {
            this._paintBackground = paintBackground;
            this.firePropertyChange(PROPERTY_PAINT_BACKGROUND, old, paintBackground);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        this.setPaintBackground(isOpaque);
    }

    public boolean isMenuBar() {
        return this._menuBar;
    }

    public void setMenuBar(boolean menuBar) {
        boolean old = this._menuBar;
        if (menuBar != old) {
            this._menuBar = menuBar;
            this.firePropertyChange(PROPERTY_MENU_BAR, old, menuBar);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.exit(-1);
        }
        if (!Q.zz(16)) {
            Lm.showInvalidProductMessage(DockableBar.class.getName(), 16);
        }
        LOGGER_EVENT = Logger.getLogger(DockableBarEvent.class.getName());
    }
}

