/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBarPane;
import com.jidesoft.action.CommandBarSeparator;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.SwingConstants;

class CommandBarPaneLayout
implements LayoutManager2,
Serializable,
SwingConstants {
    private HashMap _hiddenOrder = new HashMap();
    private Dimension _savePreferredDimension;
    private int[] _splits;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private Container _target;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;
    private List<Result> _result = null;

    public Rectangle getActualSize(Container target, int x, int y, int width, int height, int orientation, boolean start, boolean shrink) {
        CommandBarPane commandBarPane = (CommandBarPane)target;
        Insets insets = target.getInsets();
        width = (int)Math.min((long)width - (long)insets.left - (long)insets.right, Integer.MAX_VALUE);
        height = (int)Math.min((long)height - (long)insets.top - (long)insets.bottom, Integer.MAX_VALUE);
        this.checkRequests();
        if (orientation == 0) {
            int index = this.retrieveByWidth(width, shrink);
            Result result = this._result.get(index);
            width = result.width;
            height = result.height;
            this._splits = result.splits;
            commandBarPane.setPreferredRowCount(result.rowCount);
        } else {
            int index = this.retrieveByHeight(height, shrink);
            Result result = this._result.get(index);
            width = result.width;
            height = result.height;
            this._splits = result.splits;
            commandBarPane.setPreferredRowCount(result.rowCount);
        }
        width = (int)Math.min((long)width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        height = (int)Math.min((long)height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        this._savePreferredDimension = new Dimension(width, height);
        return new Rectangle(x, y, width, height);
    }

    private int getMinWidth(SizeRequirements[] sizes) {
        int minWidth = 0;
        for (int i = 0; i < sizes.length; ++i) {
            SizeRequirements sizeRequirements = sizes[i];
            if (minWidth >= sizeRequirements.preferred) continue;
            minWidth = sizeRequirements.preferred;
        }
        return minWidth;
    }

    public CommandBarPaneLayout(Container target) {
        this._target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void invalidateLayout(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this.checkContainer(target);
            this.xChildren = null;
            this.yChildren = null;
            this.xTotal = null;
            this.yTotal = null;
            this._savePreferredDimension = null;
            this._result = null;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            this._hiddenOrder.remove(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints instanceof Integer) {
                this._hiddenOrder.put(comp, constraints);
            } else {
                this._hiddenOrder.put(comp, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        if (this._savePreferredDimension != null) {
            return this._savePreferredDimension;
        }
        Dimension size = new Dimension(0, 0);
        Object object = target.getTreeLock();
        synchronized (object) {
            this.checkContainer(target);
            this.checkRequests();
            if (this._target instanceof CommandBarPane) {
                CommandBarPane commandBarPane = (CommandBarPane)this._target;
                if (commandBarPane.isUsePreferredRowCount()) {
                    if (this._splits == null) {
                        int index = this.retrieveByWidth(200, true);
                        Result result = this._result.get(index);
                        this._splits = result.splits;
                        commandBarPane.setPreferredRowCount(result.rowCount);
                    }
                    int rowCount = commandBarPane.getPreferredRowCount();
                    size = this.getPreferredSizeByRowCount(rowCount);
                } else {
                    size = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
                }
            }
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension size = new Dimension(0, 0);
        Object object = target.getTreeLock();
        synchronized (object) {
            this.checkRequests();
            this.checkContainer(target);
            Vector components = this.sortComponentByOrder();
            this.checkRequests();
            if (this._target instanceof CommandBarPane) {
                CommandBarPane commandBarPane = (CommandBarPane)this._target;
                size = commandBarPane.getOrientation() == 0 ? new Dimension(components.size() == 0 ? 0 : ((Component)components.get((int)0)).getPreferredSize().width, this.yTotal.minimum) : new Dimension(this.xTotal.minimum, components.size() == 0 ? 0 : ((Component)components.get((int)0)).getPreferredSize().height);
            }
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container target) {
        Dimension size;
        Object object = target.getTreeLock();
        synchronized (object) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        if (!target.isVisible()) {
            return;
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            this.checkContainer(target);
            CommandBarPane commandBarPane = (CommandBarPane)target;
            Dimension alloc = this._target.getSize();
            Insets in = this._target.getInsets();
            alloc.width -= in.left + in.right;
            alloc.height -= in.top + in.bottom;
            int width = alloc.width;
            int height = alloc.height;
            int y = in.top;
            int x = in.left;
            if (commandBarPane.isUsePreferredRowCount()) {
                Vector component = this.getComponents();
                int saveX = x;
                int j = 0;
                int maxHeight = 0;
                this.checkRequests();
                if (this._splits == null) {
                    int index = this.retrieveByWidth(200, true);
                    Result result = this._result.get(index);
                    width = result.width;
                    height = result.height;
                    this._splits = result.splits;
                    commandBarPane.setPreferredRowCount(result.rowCount);
                }
                for (int i = 0; i < component.size(); ++i) {
                    if (this._splits != null && j <= this._splits.length - 1 && i == this._splits[j]) {
                        maxHeight = 0;
                        y += this.yTotal.preferred;
                        x = saveX;
                        ++j;
                    }
                    if (maxHeight == 0) {
                        int lastOne = this._splits != null && j <= this._splits.length - 1 ? this._splits[j] : component.size();
                        for (int k = i; k < lastOne; ++k) {
                            if (maxHeight >= this.yChildren[k].preferred) continue;
                            maxHeight = this.yChildren[k].preferred;
                        }
                    }
                    Component comp = (Component)component.get(i);
                    Dimension compSize = comp.getPreferredSize();
                    comp.setBounds(x, y, compSize.width, maxHeight);
                    x += compSize.width;
                }
            } else {
                Vector components = this.getComponents();
                int count = components.size();
                if (commandBarPane.getOrientation() == 0) {
                    Dimension compSize;
                    int i;
                    for (i = 0; i < components.size(); ++i) {
                        Component comp = (Component)components.get(i);
                        compSize = comp.getPreferredSize();
                        if ((width -= compSize.width) == 0) {
                            count = i;
                            break;
                        }
                        if (width >= 0) continue;
                        count = i - 1;
                        break;
                    }
                    if (this._target instanceof CommandBarPane) {
                        ((CommandBarPane)this._target).removeAllHiddenComponents();
                    }
                    for (i = 0; i < components.size(); ++i) {
                        Component c = (Component)components.get(i);
                        if (components.indexOf(c) == -1) continue;
                        if (components.indexOf(c) > count) {
                            if (!(this._target instanceof CommandBarPane)) continue;
                            ((CommandBarPane)this._target).addHiddenComponent(c);
                            continue;
                        }
                        if (c.getParent() != this._target && this._target instanceof CommandBarPane) {
                            ((CommandBarPane)this._target).removeHiddenComponent(c);
                        }
                        c.setVisible(true);
                        compSize = c.getPreferredSize();
                        c.setBounds(x, y, compSize.width, height);
                        x += compSize.width;
                    }
                } else {
                    Dimension compSize;
                    int i;
                    for (i = 0; i < components.size(); ++i) {
                        Component comp = (Component)components.get(i);
                        compSize = comp.getPreferredSize();
                        if ((height -= compSize.height) == 0) {
                            count = i;
                            break;
                        }
                        if (height >= 0) continue;
                        count = i - 1;
                        break;
                    }
                    if (this._target instanceof CommandBarPane) {
                        ((CommandBarPane)this._target).removeAllHiddenComponents();
                    }
                    for (i = 0; i < components.size(); ++i) {
                        Component c = (Component)components.get(i);
                        if (components.indexOf(c) == -1) continue;
                        if (components.indexOf(c) > count) {
                            if (!(this._target instanceof CommandBarPane)) continue;
                            ((CommandBarPane)this._target).addHiddenComponent(c);
                            continue;
                        }
                        if (c.getParent() != this._target && this._target instanceof CommandBarPane) {
                            ((CommandBarPane)this._target).removeHiddenComponent(c);
                        }
                        c.setVisible(true);
                        compSize = c.getPreferredSize();
                        c.setBounds(x, y, width, compSize.height);
                        y += compSize.height;
                    }
                }
            }
        }
    }

    int getHiddenOrder(Object o) {
        Object order = this._hiddenOrder.get(o);
        if (order != null) {
            return (Integer)order;
        }
        return 0;
    }

    Vector sortComponentByOrder() {
        Vector components = this.getComponents();
        Collections.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (CommandBarPaneLayout.this.getHiddenOrder(o1) > CommandBarPaneLayout.this.getHiddenOrder(o2)) {
                    return -1;
                }
                if (CommandBarPaneLayout.this.getHiddenOrder(o1) < CommandBarPaneLayout.this.getHiddenOrder(o2)) {
                    return 1;
                }
                return -1;
            }
        });
        return components;
    }

    protected Vector getComponents() {
        Vector<Component> components = new Vector<Component>();
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (i == 0 && component instanceof CommandBarSeparator) continue;
            components.add(component);
        }
        return components;
    }

    void checkContainer(Container target) {
        if (this._target != target) {
            throw new AWTError("CommandBarLayout can't be shared");
        }
    }

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            Vector components = this.getComponents();
            int n = components.size();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            for (int i = 0; i < n; ++i) {
                Component component = (Component)components.get(i);
                Dimension min = component.getMinimumSize();
                Dimension pre = component.getPreferredSize();
                Dimension max = component.getMaximumSize();
                this.xChildren[i] = new SizeRequirements(min.width, pre.width, max.width, 0.0f);
                this.yChildren[i] = new SizeRequirements(min.height, pre.height, max.height, 0.0f);
            }
            this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
            this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
        }
        this.calculateResult(this.xChildren);
    }

    private void calculateResult(SizeRequirements[] sizes) {
        int totalMaxWidth;
        if (this._result != null) {
            return;
        }
        this._result = new Vector<Result>();
        int totalMinWidth = this.getMinWidth(sizes);
        for (int width = totalMaxWidth = this.xTotal.preferred; width >= totalMinWidth; --width) {
            int estimateRowCount = this.getEstimateRowCount(sizes, width);
            int maxWidth = width;
            int minWidth = this.xTotal.preferred / estimateRowCount;
            int split = 0;
            int[] splits = new int[sizes.length];
            for (int rowWidth = minWidth; rowWidth <= maxWidth; ++rowWidth) {
                split = 0;
                int accuWidth = 0;
                int maxRowWidth = 0;
                for (int i = 0; i < sizes.length; ++i) {
                    if (split < estimateRowCount - 1 && accuWidth + sizes[i].preferred > rowWidth) {
                        splits[split] = i;
                        ++split;
                        if (maxRowWidth < accuWidth) {
                            maxRowWidth = accuWidth;
                        }
                        accuWidth = 0;
                    }
                    accuWidth += sizes[i].preferred;
                }
                if (maxRowWidth < accuWidth) {
                    maxRowWidth = accuWidth;
                }
                maxWidth = maxRowWidth;
            }
            if (split + 1 <= this._result.size() || this._result.size() != 0 && split < this._result.get((int)(this._result.size() - 1)).rowCount) continue;
            Result result = new Result();
            result.rowCount = split + 1;
            result.width = maxWidth;
            result.splits = new int[split];
            System.arraycopy(splits, 0, result.splits, 0, split);
            result.width = maxWidth;
            result.height = result.rowCount * this.yTotal.preferred;
            this._result.add(result);
        }
    }

    private int retrieveByWidth(int totalWidth, boolean shrink) {
        if (shrink) {
            for (int i = 0; i < this._result.size(); ++i) {
                Result result = this._result.get(i);
                if (totalWidth < result.width) continue;
                return i;
            }
        } else {
            for (int i = this._result.size() - 1; i >= 0; --i) {
                Result result = this._result.get(i);
                if (result.width <= totalWidth) continue;
                return i;
            }
        }
        return shrink ? this._result.size() - 1 : 0;
    }

    private int retrieveByHeight(int totalHeight, boolean shrink) {
        if (shrink) {
            for (int i = this._result.size() - 1; i >= 0; --i) {
                Result result = this._result.get(i);
                if (totalHeight < result.height) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._result.size(); ++i) {
                Result result = this._result.get(i);
                if (result.height <= totalHeight) continue;
                return i;
            }
        }
        return shrink ? 0 : this._result.size() - 1;
    }

    private int getEstimateRowCount(SizeRequirements[] sizes, int totalWidth) {
        for (int i = 1; i < sizes.length; ++i) {
            int estimateWidth = this.xTotal.preferred / i;
            if (totalWidth < estimateWidth) continue;
            return i;
        }
        return -1;
    }

    Dimension getPreferredSizeByRowCount(int rowCount) {
        if (rowCount < 1) {
            rowCount = 1;
        }
        for (Result result : this._result) {
            if (result.rowCount != rowCount) continue;
            return new Dimension(result.width, result.height);
        }
        return new Dimension(0, 0);
    }

    private static class Result {
        int rowCount;
        int[] splits;
        int width;
        int height;

        private Result() {
        }
    }
}

