/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.Chevron;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandBarTitleBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.Gripper;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SizeRequirements;
import javax.swing.SwingConstants;

class CommandBarLayout
implements LayoutManager2,
Serializable,
SwingConstants {
    private HashMap<Component, Integer> _hiddenOrder = new HashMap();
    private Gripper _gripper;
    private CommandBarTitleBar _titleBar;
    private Chevron _chevron;
    private Dimension _savePreferredDimension;
    private int[] _splits;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private boolean _reset = true;
    private static final long serialVersionUID = 3568625581768530323L;
    private int _axis;
    private Container _target;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;
    private List<Result> _result = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getActualSize(Container target, int x, int y, int width, int height, int orientation, boolean start, boolean shrink) {
        Object object = target.getTreeLock();
        synchronized (object) {
            DockableBar dockableBar = (DockableBar)target;
            if (dockableBar.isFloating()) {
                height -= this._titleBar != null ? this._titleBar.getPreferredSize().height : 0;
            } else {
                width -= (this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().width : 0) + (this._chevron != null ? this._chevron.getPreferredSize().width : 0);
            }
            Insets insets = target.getInsets();
            width = (int)Math.min((long)width - (long)insets.left - (long)insets.right, Integer.MAX_VALUE);
            height = (int)Math.min((long)height - (long)insets.top - (long)insets.bottom, Integer.MAX_VALUE);
            this.checkRequests();
            if (orientation == 0) {
                int index = this.retrieveByWidth(width, shrink);
                Result result = this._result.get(index);
                width = result.width;
                height = result.height;
                this._splits = result.splits;
                if (dockableBar instanceof CommandBar) {
                    ((CommandBar)dockableBar).setPreferredRowCount(this._splits.length + 1);
                }
            } else {
                int index = this.retrieveByHeight(height, shrink);
                Result result = this._result.get(index);
                width = result.width;
                height = result.height;
                this._splits = result.splits;
                if (dockableBar instanceof CommandBar) {
                    ((CommandBar)dockableBar).setPreferredRowCount(this._splits.length + 1);
                }
            }
            if (dockableBar.isFloating()) {
                height += this._titleBar != null ? this._titleBar.getPreferredSize().height + 2 : 0;
            } else {
                width += (this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().width : 0) + (this._chevron != null ? this._chevron.getPreferredSize().width : 0);
            }
            width = (int)Math.min((long)width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            height = (int)Math.min((long)height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
            return new Rectangle(x, y, width, height);
        }
    }

    private boolean shouldShowGripper(DockableBar dockableBar) {
        return dockableBar.getDockableBarManager() != null && dockableBar.getDockableBarManager().isRearrangable() && dockableBar.isRearrangable();
    }

    private int getMinWidth(SizeRequirements[] sizes) {
        int minWidth = 0;
        for (SizeRequirements sizeRequirements : sizes) {
            if (minWidth >= sizeRequirements.preferred) continue;
            minWidth = sizeRequirements.preferred;
        }
        return minWidth;
    }

    public CommandBarLayout(Container target, int axis) {
        if (axis != 0 && axis != 1 && axis != 2 && axis != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = axis;
        this._target = target;
    }

    @Override
    public synchronized void invalidateLayout(Container target) {
        this._savePreferredDimension = null;
        this._splits = null;
        this.reset();
    }

    protected synchronized void reset() {
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
        this._savePreferredDimension = null;
        this._result = null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            this._hiddenOrder.remove(comp);
            if (this._reset) {
                this._result = null;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            if (constraints instanceof Integer) {
                this._hiddenOrder.put(comp, (Integer)constraints);
            } else {
                this._hiddenOrder.put(comp, 0);
            }
            if (this._reset) {
                this._result = null;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (this._savePreferredDimension != null) {
                return this._savePreferredDimension;
            }
            Dimension size = new Dimension(0, 0);
            CommandBarLayout commandBarLayout = this;
            synchronized (commandBarLayout) {
                this.checkContainer(target);
                this.checkRequests();
                if (this._target instanceof DockableBar) {
                    DockableBar dockableBar = (DockableBar)this._target;
                    if (dockableBar.isFloating()) {
                        if (dockableBar instanceof CommandBar) {
                            int rowCount = ((CommandBar)dockableBar).getPreferredRowCount();
                            size = this.getPreferredSizeByRowCount(rowCount);
                        } else {
                            size = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
                        }
                        if (this._titleBar != null) {
                            size.height += this._titleBar.getPreferredSize().height + 2;
                        }
                    } else {
                        size = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
                        if (dockableBar.getOrientation() == 0) {
                            size.width = size.width + ((this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().width : 0) + (dockableBar.isStretch() ? 0 : (this._chevron != null ? this._chevron.getPreferredSize().width : 0)));
                        } else {
                            size.height = size.height + ((this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().height : 0) + (dockableBar.isStretch() ? 0 : (this._chevron != null ? this._chevron.getPreferredSize().height : 0)));
                        }
                    }
                }
            }
            Insets insets = target.getInsets();
            size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
            this._savePreferredDimension = size;
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension size = new Dimension(0, 0);
        Object object = target.getTreeLock();
        synchronized (object) {
            this.checkRequests();
            this.checkContainer(target);
            List<Component> components = this.sortComponentByOrder();
            this.checkRequests();
            if (this._target instanceof DockableBar) {
                DockableBar dockableBar = (DockableBar)this._target;
                size = dockableBar.getOrientation() == 0 ? new Dimension((this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getMinimumSize().width : 0) + (this._chevron != null ? this._chevron.getMinimumSize().width : 0) + (components.size() != 0 ? components.get((int)0).getMinimumSize().width : 0), this.yTotal.minimum) : new Dimension(this.xTotal.minimum, (this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getMinimumSize().height : 0) + (this._chevron != null ? this._chevron.getMinimumSize().height : 0) + (components.size() != 0 ? components.get((int)0).getMinimumSize().height : 0));
            }
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container target) {
        Dimension size;
        Object object = target.getTreeLock();
        synchronized (object) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (!target.isVisible()) {
                return;
            }
            Dimension alloc = this._target.getSize();
            if (alloc.width == 0 || alloc.height == 0) {
                return;
            }
            this.checkContainer(target);
            DockableBar dockableBar = (DockableBar)target;
            Insets in = this._target.getInsets();
            alloc.width -= in.left + in.right;
            alloc.height -= in.top + in.bottom;
            boolean ltr = dockableBar.getOrientation() == 1 || this._target.getComponentOrientation().isLeftToRight();
            int width = alloc.width;
            int height = alloc.height;
            int y = in.top;
            int x = ltr ? in.left : width;
            dockableBar.setDuringLayout(true);
            List<Component> components = this.getComponents();
            List<Component> unsupportComponents = this.getUnsupportedComponents();
            for (Component c : unsupportComponents) {
                c.setBounds(0, 0, 0, 0);
            }
            int componentCount = components.size();
            if (dockableBar.isFloating()) {
                Result result;
                int index;
                if (this._gripper != null) {
                    this._gripper.setVisible(false);
                    this._gripper.setEnabled(this._gripper.isVisible());
                }
                if (this._chevron != null) {
                    this._chevron.setVisible(false);
                    this._chevron.setEnabled(false);
                }
                if (this._titleBar != null) {
                    this._titleBar.setVisible(true);
                    this._titleBar.setEnabled(true);
                    this._titleBar.setBounds(in.left, y, alloc.width, this._titleBar.getPreferredSize().height);
                    Dimension size = this._titleBar.getPreferredSize();
                    y += size.height + 1;
                    height -= size.height;
                }
                --height;
                int saveX = x;
                int j = 0;
                this.checkRequests();
                if (this._target instanceof CommandBar && (index = ((CommandBar)this._target).getPreferredRowCount() - 1) >= 0 && index < this._result.size() && (result = this._result.get(index)) != null) {
                    this._splits = result.splits;
                }
                int compHeight = this.yTotal.preferred;
                this._reset = false;
                for (int i = 0; i < componentCount; ++i) {
                    Component comp;
                    if (this._splits != null && j <= this._splits.length - 1 && i == this._splits[j]) {
                        y += this.yTotal.preferred;
                        x = saveX;
                        ++j;
                    }
                    if ((comp = components.get(i)).getParent() != this._target && this._target instanceof CommandBar) {
                        ((CommandBar)this._target).removeHiddenComponent(comp);
                    }
                    if (!comp.isVisible()) continue;
                    Dimension compSize = this.getPreferredSize(comp);
                    comp.setBounds(ltr ? x : x - compSize.width, y, compSize.width, compHeight);
                    if (ltr) {
                        x += compSize.width;
                        continue;
                    }
                    x -= compSize.width;
                }
                this._reset = true;
            } else {
                Component cc;
                int i;
                Dimension compSize;
                int chevronSize;
                Dimension preferredSize;
                Dimension compSize2;
                Component comp;
                int i2;
                if (this._gripper != null) {
                    this._gripper.setVisible(this.shouldShowGripper(dockableBar));
                    this._gripper.setEnabled(this._gripper.isVisible());
                }
                if (this._chevron != null) {
                    this._chevron.setVisible(!dockableBar.isStretch());
                    this._chevron.setEnabled(!dockableBar.isStretch());
                }
                if (this._titleBar != null) {
                    this._titleBar.setVisible(false);
                    this._titleBar.setEnabled(false);
                }
                int count = componentCount;
                int widthLeft = width;
                int heightLeft = height;
                Dimension[] layoutSize = new Dimension[componentCount];
                if (dockableBar.getOrientation() == 0) {
                    widthLeft -= this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().width : 0;
                    widthLeft -= this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().width : 0;
                    int totalWidth = 0;
                    for (i2 = 0; i2 < componentCount; ++i2) {
                        comp = components.get(i2);
                        compSize2 = this.getPreferredSize(comp);
                        totalWidth += compSize2.width;
                        layoutSize[i2] = compSize2;
                    }
                    if (totalWidth > widthLeft) {
                        for (i2 = componentCount - 1; i2 >= 0; --i2) {
                            comp = components.get(i2);
                            preferredSize = this.getPreferredSize(comp);
                            Dimension minimunSize = this.getMinimumSize(comp);
                            if (preferredSize.width > minimunSize.width) {
                                totalWidth -= preferredSize.width - minimunSize.width;
                                layoutSize[i2] = minimunSize;
                            }
                            if (totalWidth > widthLeft) continue;
                            layoutSize[i2].width += widthLeft - totalWidth;
                            break;
                        }
                    }
                    widthLeft += this._chevron != null && this._chevron.isVisible() ? this.getPreferredSize((Component)this._chevron).width : 0;
                } else {
                    heightLeft -= this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().height : 0;
                    heightLeft -= this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().height : 0;
                    int totalHeight = 0;
                    for (i2 = 0; i2 < componentCount; ++i2) {
                        comp = components.get(i2);
                        compSize2 = this.getPreferredSize(comp);
                        totalHeight += compSize2.height;
                        layoutSize[i2] = compSize2;
                    }
                    if (totalHeight > heightLeft) {
                        for (i2 = componentCount - 1; i2 >= 0; --i2) {
                            comp = components.get(i2);
                            preferredSize = this.getPreferredSize(comp);
                            Dimension minimumSize = this.getMinimumSize(comp);
                            if (preferredSize.height > minimumSize.height) {
                                totalHeight -= preferredSize.height - minimumSize.height;
                                layoutSize[i2] = minimumSize;
                            }
                            if (totalHeight > heightLeft) continue;
                            layoutSize[i2].height += heightLeft - totalHeight;
                            break;
                        }
                    }
                    heightLeft += this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().height : 0;
                }
                if (dockableBar.getOrientation() == 0) {
                    chevronSize = this._chevron != null ? this._chevron.getPreferredSize().width : 0;
                    for (i2 = 0; i2 < componentCount; ++i2) {
                        compSize = layoutSize[i2];
                        if ((widthLeft -= compSize.width) >= 0 && (widthLeft >= chevronSize || i2 == componentCount - 1)) continue;
                        widthLeft += compSize.width;
                        while (widthLeft < 0) {
                            widthLeft -= chevronSize;
                            if (--i2 < 0) break;
                            compSize = layoutSize[i2];
                            widthLeft += compSize.width;
                        }
                        count = i2 - 1;
                        break;
                    }
                } else {
                    chevronSize = this._chevron != null ? this._chevron.getPreferredSize().height : 0;
                    for (i2 = 0; i2 < componentCount; ++i2) {
                        compSize = layoutSize[i2];
                        if ((heightLeft -= compSize.height) >= 0 && (heightLeft >= chevronSize || i2 == componentCount - 1)) continue;
                        heightLeft += compSize.height;
                        while (heightLeft < 0) {
                            heightLeft -= chevronSize;
                            if (--i2 < 0) break;
                            compSize = layoutSize[i2];
                            heightLeft += compSize.height;
                        }
                        count = i2 - 1;
                        break;
                    }
                }
                if (this._chevron != null) {
                    boolean newShowMore;
                    boolean oldShowMore = this._chevron.isShowMore();
                    boolean bl = newShowMore = count < componentCount - 1;
                    if (oldShowMore != newShowMore) {
                        this._chevron.setShowMore(newShowMore);
                    }
                    if (this._target instanceof DockableBar && ((DockableBar)this._target).isStretch()) {
                        this._chevron.setVisible(newShowMore);
                        this._chevron.setEnabled(newShowMore);
                    }
                }
                if (dockableBar.getOrientation() == 0) {
                    if (this._gripper != null && this.shouldShowGripper(dockableBar)) {
                        this._gripper.setBounds(ltr ? x : x - this._gripper.getPreferredSize().width, y, this._gripper.getPreferredSize().width, height);
                        x = ltr ? (x += this._gripper.getPreferredSize().width) : (x -= this._gripper.getPreferredSize().width);
                    }
                    if (this._target instanceof CommandBar) {
                        ((CommandBar)this._target).removeAllHiddenComponents();
                    }
                    for (i = 0; i < componentCount; ++i) {
                        Component c = components.get(i);
                        if (components.indexOf(c) == -1) continue;
                        if (components.indexOf(c) > count) {
                            if (!(this._target instanceof CommandBar)) continue;
                            ((CommandBar)this._target).addHiddenComponent(c);
                            continue;
                        }
                        if (c.getParent() != this._target && this._target instanceof CommandBar) {
                            ((CommandBar)this._target).removeHiddenComponent(c);
                        }
                        if (!c.isVisible()) continue;
                        if (i < componentCount && this._target instanceof DockableBar && ((DockableBar)this._target).isStretch() && this.shouldExpand(c)) {
                            int left = this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().width : 0;
                            for (int j = i + 1; j < componentCount; ++j) {
                                cc = components.get(j);
                                if (components.indexOf(cc) > count) continue;
                                left += layoutSize[j].width;
                            }
                            c.setBounds(ltr ? x : left, y, ltr ? width - left - x : x - left, height);
                            if (ltr) {
                                x = width - left + in.left;
                                continue;
                            }
                            x = left + in.left;
                            continue;
                        }
                        Dimension compSize3 = layoutSize[i];
                        c.setBounds(ltr ? x : x - compSize3.width, y, compSize3.width, height);
                        if (ltr) {
                            x += compSize3.width;
                            continue;
                        }
                        x -= compSize3.width;
                    }
                    if (this._chevron != null && this._chevron.isVisible()) {
                        this._chevron.setBounds(ltr ? this._target.getWidth() - this._chevron.getPreferredSize().width : 0, 0, this._chevron.getPreferredSize().width, this._target.getHeight());
                    }
                } else {
                    if (this._gripper != null && this.shouldShowGripper(dockableBar)) {
                        this._gripper.setBounds(x, y, width, this._gripper.getPreferredSize().height);
                        y += this._gripper.getPreferredSize().height;
                    }
                    if (this._target instanceof CommandBar) {
                        ((CommandBar)this._target).removeAllHiddenComponents();
                    }
                    for (i = 0; i < componentCount; ++i) {
                        Component c = components.get(i);
                        if (components.indexOf(c) == -1) continue;
                        if (components.indexOf(c) > count) {
                            if (!(this._target instanceof CommandBar)) continue;
                            ((CommandBar)this._target).addHiddenComponent(c);
                            continue;
                        }
                        if (c.getParent() != this._target && this._target instanceof CommandBar) {
                            ((CommandBar)this._target).removeHiddenComponent(c);
                        }
                        if (!c.isVisible()) continue;
                        if (i < componentCount - 1 && this._target instanceof DockableBar && ((DockableBar)this._target).isStretch() && this.shouldExpand(c)) {
                            int down = this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().height : 0;
                            for (int j = i + 1; j < componentCount; ++j) {
                                cc = components.get(j);
                                if (components.indexOf(cc) > count) continue;
                                down += layoutSize[j].height;
                            }
                            c.setBounds(x, y, width, height - down - y);
                            y = height - down + in.top;
                            continue;
                        }
                        Dimension compSize4 = layoutSize[i];
                        c.setBounds(x, y, width, compSize4.height);
                        y += compSize4.height;
                    }
                    if (this._chevron != null && this._chevron.isVisible()) {
                        this._chevron.setBounds(0, this._target.getHeight() - this._chevron.getPreferredSize().height, this._target.getWidth(), this._chevron.getPreferredSize().height);
                    }
                }
            }
            dockableBar.setDuringLayout(false);
        }
    }

    protected Dimension getPreferredSize(Component comp) {
        return comp.isVisible() ? comp.getPreferredSize() : new Dimension(0, 0);
    }

    protected Dimension getMinimumSize(Component comp) {
        return comp.isVisible() ? comp.getMinimumSize() : new Dimension(0, 0);
    }

    protected boolean shouldExpand(Component c) {
        Object clientProperty = ((JComponent)c).getClientProperty("CommandBar.expandable");
        if ("false".equals(clientProperty)) {
            return false;
        }
        if ("true".equals(clientProperty)) {
            return true;
        }
        return c instanceof CommandBar.Expansion || c instanceof JTextField || c instanceof JComboBox;
    }

    int getHiddenOrder(Object o) {
        if (!(o instanceof Component)) {
            return 0;
        }
        Component comp = (Component)o;
        Integer order = this._hiddenOrder.get(comp);
        if (order != null) {
            return order;
        }
        return 0;
    }

    List<Component> sortComponentByOrder() {
        List<Component> components = this.getComponents();
        Collections.sort(components, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (CommandBarLayout.this.getHiddenOrder(o1) > CommandBarLayout.this.getHiddenOrder(o2)) {
                    return -1;
                }
                if (CommandBarLayout.this.getHiddenOrder(o1) < CommandBarLayout.this.getHiddenOrder(o2)) {
                    return 1;
                }
                return -1;
            }
        });
        return components;
    }

    protected List<Component> getComponents() {
        Vector<Component> components = new Vector<Component>();
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (component instanceof Gripper) {
                this._gripper = (Gripper)component;
                continue;
            }
            if (component instanceof CommandBarTitleBar) {
                this._titleBar = (CommandBarTitleBar)component;
                continue;
            }
            if (component instanceof Chevron) {
                this._chevron = (Chevron)component;
                continue;
            }
            if (!this.isOrientationSupport(component)) continue;
            components.add(component);
        }
        if (this._target instanceof CommandBar) {
            Component[] hiddenComponents;
            for (Component hiddenComponent : hiddenComponents = ((CommandBar)this._target).getHiddenComponents()) {
                if (!this.isOrientationSupport(hiddenComponent)) continue;
                components.add(hiddenComponent);
            }
        }
        return components;
    }

    protected List<Component> getUnsupportedComponents() {
        Vector<Component> components = new Vector<Component>();
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (component instanceof Gripper || component instanceof CommandBarTitleBar || component instanceof Chevron || this.isOrientationSupport(component)) continue;
            components.add(component);
        }
        if (this._target instanceof CommandBar) {
            Component[] hiddenComponents;
            for (Component hiddenComponent : hiddenComponents = ((CommandBar)this._target).getHiddenComponents()) {
                if (this.isOrientationSupport(hiddenComponent)) continue;
                components.add(hiddenComponent);
            }
        }
        return components;
    }

    private boolean isOrientationSupport(Component component) {
        if (this._target instanceof DockableBar) {
            if (((DockableBar)this._target).getOrientation() == 0) {
                return !(component instanceof Alignable) || ((Alignable)((Object)component)).supportHorizontalOrientation();
            }
            if (component instanceof Alignable && ((Alignable)((Object)component)).supportVerticalOrientation()) {
                return true;
            }
        }
        return false;
    }

    void checkContainer(Container target) {
        if (this._target != target) {
            throw new AWTError("CommandBarLayout can't be shared");
        }
    }

    void checkRequests() {
        DockableBar dockableBar;
        if (this.xChildren == null || this.yChildren == null) {
            List<Component> components = this.getComponents();
            int n = components.size();
            SizeRequirements[] xC = new SizeRequirements[n];
            SizeRequirements[] yC = new SizeRequirements[n];
            for (int i = 0; i < n; ++i) {
                Component component = components.get(i);
                if (!component.isVisible()) {
                    xC[i] = new SizeRequirements(0, 0, 0, 0.0f);
                    yC[i] = new SizeRequirements(0, 0, 0, 0.0f);
                    continue;
                }
                Dimension min = component.getMinimumSize();
                Dimension pre = component.getPreferredSize();
                Dimension max = component.getMaximumSize();
                xC[i] = new SizeRequirements(min.width, pre.width, max.width, 0.0f);
                yC[i] = new SizeRequirements(min.height, pre.height, max.height, 0.0f);
            }
            int absoluteAxis = this.resolveAxis(this._axis, this._target.getComponentOrientation());
            if (absoluteAxis == 0) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(xC);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(yC);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(xC);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(yC);
            }
            Dimension minimumSize = UIDefaultsLookup.getDimension("CommandBar.minimumSize");
            if (minimumSize != null) {
                if (this.xTotal.preferred == 0) {
                    this.xTotal.preferred = minimumSize.width;
                }
                if (this.yTotal.preferred == 0) {
                    this.yTotal.preferred = minimumSize.height;
                }
            }
            this.xChildren = xC;
            this.yChildren = yC;
        }
        if (this._target instanceof DockableBar && ((dockableBar = (DockableBar)this._target).getOrientation() == 0 || dockableBar.isFloating())) {
            this.calculateResult(this.xChildren);
        }
    }

    private int resolveAxis(int axis, ComponentOrientation o) {
        int absoluteAxis = axis == 2 ? (o.isHorizontal() ? 0 : 1) : (axis == 3 ? (o.isHorizontal() ? 1 : 0) : axis);
        return absoluteAxis;
    }

    private void calculateResult(SizeRequirements[] sizes) {
        if (this._result != null) {
            return;
        }
        this._result = new Vector<Result>();
        int totalMinWidth = this.getMinWidth(sizes);
        int compWidthTotal = 0;
        int[] runningWidths = new int[sizes.length];
        for (int i = 0; i < sizes.length; ++i) {
            runningWidths[i] = compWidthTotal += sizes[i].preferred;
        }
        int[] splits = new int[sizes.length];
        boolean skipOnce = false;
        for (int rowCt = 1; rowCt <= sizes.length; ++rowCt) {
            int rowWidth = compWidthTotal / rowCt;
            if (rowWidth < totalMinWidth) {
                if (skipOnce) continue;
                rowWidth = totalMinWidth;
                skipOnce = true;
            }
            boolean allCompsFit = false;
            while (!allCompsFit) {
                int split = 0;
                int rowStart = 0;
                int previousSplitWidth = 0;
                block3: do {
                    for (int i = rowStart; i < sizes.length; ++i) {
                        rowStart = i;
                        if (runningWidths[i] - previousSplitWidth > rowWidth) {
                            previousSplitWidth = runningWidths[splits[split] - 1];
                            ++split;
                            allCompsFit = false;
                            continue block3;
                        }
                        splits[split] = i + 1;
                        allCompsFit = true;
                    }
                } while (split < rowCt && !allCompsFit);
                if (allCompsFit) continue;
                ++rowWidth;
            }
            splits[rowCt - 1] = 0;
            Result result = new Result();
            result.rowCount = rowCt;
            result.width = rowWidth;
            result.splits = new int[rowCt - 1];
            System.arraycopy(splits, 0, result.splits, 0, rowCt - 1);
            result.height = result.rowCount * this.yTotal.preferred;
            this._result.add(result);
        }
    }

    private int retrieveByWidth(int totalWidth, boolean shrink) {
        if (shrink) {
            for (int i = 0; i < this._result.size(); ++i) {
                Result result = this._result.get(i);
                if (totalWidth < result.width) continue;
                return i;
            }
        } else {
            for (int i = this._result.size() - 1; i >= 0; --i) {
                Result result = this._result.get(i);
                if (result.width <= totalWidth) continue;
                return i;
            }
        }
        return shrink ? this._result.size() - 1 : 0;
    }

    private int retrieveByHeight(int totalHeight, boolean shrink) {
        if (shrink) {
            for (int i = this._result.size() - 1; i >= 0; --i) {
                Result result = this._result.get(i);
                if (totalHeight < result.height) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._result.size(); ++i) {
                Result result = this._result.get(i);
                if (result.height <= totalHeight) continue;
                return i;
            }
        }
        return shrink ? 0 : this._result.size() - 1;
    }

    Dimension getPreferredSizeByRowCount(int rowCount) {
        if (this._result != null && this._result.size() > 0) {
            int minRowCount = this._result.get((int)0).rowCount;
            int maxRowCount = this._result.get((int)(this._result.size() - 1)).rowCount;
            if (rowCount < minRowCount) {
                rowCount = minRowCount;
            }
            if (rowCount > maxRowCount) {
                rowCount = maxRowCount;
            }
            for (Result result : this._result) {
                if (result.rowCount != rowCount) continue;
                return new Dimension(result.width, result.height);
            }
        }
        return new Dimension(0, 0);
    }

    private static class Result {
        int rowCount;
        int[] splits;
        int width;
        int height;

        private Result() {
        }
    }
}

