/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarHolder;
import com.jidesoft.action.Resource;
import com.jidesoft.docking.DefaultDockableHolder;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.plaf.office2003.Office2003Theme;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideComboBox;
import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideToggleSplitButton;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyleFactory;

public class CommandBarFactory {
    static final String[] SYNTHETICA_LAFS = new String[]{"de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaWhiteVisionLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaSkyMetallicLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaMauveMetallicLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaOrangeMetallicLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlueSteelLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlueMoonLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlackMoonLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaSilverMoonLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlueIceLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaGreenDreamLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlackStarLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlackEyeLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaSimple2DLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaClassyLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaAluOxideLookAndFeel"};

    public static CommandBar createMenuCommandBar(JMenuBar menuBar) {
        CommandMenuBar commandBar = new CommandMenuBar("Menu Bar");
        commandBar.getContext().setInitSide(1);
        commandBar.setPaintBackground(false);
        commandBar.setStretch(true);
        commandBar.setFloatable(true);
        commandBar.add(menuBar);
        return commandBar;
    }

    protected static AbstractButton createButton(Icon icon) {
        return CommandBarFactory.createButton(null, icon);
    }

    protected static AbstractButton createButton(String text) {
        return CommandBarFactory.createButton(text, null);
    }

    protected static AbstractButton createButton(String text, Icon icon) {
        JideButton button = new JideButton(text, icon);
        button.setOpaque(false);
        button.setFocusable(false);
        return button;
    }

    protected static JideSplitButton createSplitButton(Icon icon) {
        return CommandBarFactory.createSplitButton(null, icon);
    }

    protected static JideSplitButton createSplitButton(String text) {
        return CommandBarFactory.createSplitButton(text, null);
    }

    protected static JideSplitButton createSplitButton(String text, Icon icon) {
        JideSplitButton splitButton = new JideSplitButton(text);
        splitButton.setIcon(icon);
        splitButton.setOpaque(true);
        splitButton.setFocusable(false);
        return splitButton;
    }

    protected static JideToggleSplitButton createToggleSplitButton(String text, Icon icon) {
        JideToggleSplitButton splitButton = new JideToggleSplitButton(text);
        splitButton.setIcon(icon);
        splitButton.setOpaque(true);
        splitButton.setFocusable(false);
        return splitButton;
    }

    protected static JideMenu createMenu(Icon icon) {
        JideMenu menu = new JideMenu("");
        menu.setIcon(icon);
        menu.setOpaque(false);
        return menu;
    }

    protected static JideMenu createMenu(String text, char mnemonic) {
        JideMenu menu = new JideMenu(text);
        menu.setMnemonic(mnemonic);
        menu.setOpaque(false);
        return menu;
    }

    protected static JideMenu createMenu(String text, char mnemonic, Icon icon) {
        JideMenu menu = new JideMenu(text);
        menu.setIcon(icon);
        menu.setMnemonic(mnemonic);
        menu.setOpaque(false);
        return menu;
    }

    protected static JComboBox createComboBox(String value) {
        JideComboBox comboBox = new JideComboBox(new Object[]{value});
        comboBox.setEditable(true);
        comboBox.setPrototypeDisplayValue(value + "    ");
        comboBox.setOpaque(false);
        return comboBox;
    }

    public static void addDemoMenus(JComponent menuBar, String[] menus) {
        for (String s : menus) {
            JideMenu menu = new JideMenu(s);
            menu.setMnemonic(s.charAt(0));
            JMenuItem item = new JMenuItem("<< Empty >>");
            menu.add(item);
            menuBar.add(menu);
        }
    }

    private static void updateComponentTreeUI(final Container container) {
        if (container == null) {
            return;
        }
        final ArrayList<String> floatingFrames = new ArrayList<String>();
        if (container instanceof DockableHolder) {
            List<String> keys = ((DockableHolder)((Object)container)).getDockingManager().getAllFrameNames();
            for (String key : keys) {
                DockableFrame frame = ((DockableHolder)((Object)container)).getDockingManager().getFrame(key);
                if (!frame.isFloated()) continue;
                floatingFrames.add(key);
            }
        }
        if (container instanceof JFrame) {
            if (container instanceof DefaultDockableHolder) {
                ((DefaultDockableHolder)container).setAutoDispose(false);
            }
            if (!LookAndFeelFactory.isCurrentLnfDecorated()) {
                ((JFrame)container).dispose();
                ((JFrame)container).setUndecorated(true);
                ((JFrame)container).getRootPane().setWindowDecorationStyle(1);
            } else if (((JFrame)container).isUndecorated() && LookAndFeelFactory.isCurrentLnfDecorated()) {
                ((JFrame)container).dispose();
                ((JFrame)container).setUndecorated(false);
                ((JFrame)container).getRootPane().setWindowDecorationStyle(0);
            }
            if (container instanceof DefaultDockableHolder) {
                ((DefaultDockableHolder)container).setAutoDispose(true);
            }
        }
        JideSwingUtilities.setRecursively(container, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component c) {
                return c instanceof DockableHolder || c instanceof DockableBarHolder;
            }

            @Override
            public void action(Component c) {
                if (c instanceof DockableHolder) {
                    ((DockableHolder)((Object)c)).getDockingManager().updateComponentTreeUI();
                }
                if (c instanceof DockableBarHolder) {
                    ((DockableBarHolder)((Object)c)).getDockableBarManager().updateComponentTreeUI();
                    List<String> keys = ((DockableBarHolder)((Object)c)).getDockableBarManager().getAllDockableBarNames();
                    boolean decorated = LookAndFeelFactory.isCurrentLnfDecorated();
                    for (String key : keys) {
                        DockableBar bar = ((DockableBarHolder)((Object)c)).getDockableBarManager().getDockableBar(key);
                        if (decorated) {
                            if (!bar.isMenuBar()) {
                                bar.setOpaque(false);
                                bar.setStretch(false);
                                bar.setPaintBackground(true);
                                continue;
                            }
                            bar.setOpaque(false);
                            bar.setPaintBackground(false);
                            bar.setRearrangable(true);
                            continue;
                        }
                        if (!bar.isMenuBar()) {
                            bar.setOpaque(true);
                            bar.setStretch(true);
                            bar.setPaintBackground(true);
                            continue;
                        }
                        bar.setOpaque(false);
                        bar.setPaintBackground(true);
                        bar.setRearrangable(bar.isRearrangable());
                    }
                }
            }

            @Override
            public void postAction(Component c) {
            }
        });
        SwingUtilities.updateComponentTreeUI(container);
        if (container instanceof JFrame) {
            container.setVisible(true);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (floatingFrames.size() > 0 && container instanceof DockableHolder) {
                    DockingManager dockingManager = ((DockableHolder)((Object)container)).getDockingManager();
                    for (String key : floatingFrames) {
                        dockingManager.showFrame(key);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private static JMenu createLAFMenu(String menuName, Container container, String[] lafs) {
        String lafName = UIManager.getLookAndFeel().getClass().getName();
        JMenu menu = new JMenu(menuName);
        ButtonGroup group = new ButtonGroup();
        for (String laf : lafs) {
            try {
                Class.forName(laf);
                JRadioButtonMenuItem rb = new JRadioButtonMenuItem(new LAFChangeAction(container, laf));
                menu.add(rb);
                group.add(rb);
                if (!laf.equals(lafName)) continue;
                rb.setSelected(true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return menu;
    }

    public static JMenu createLookAndFeelMenu(final Container container) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        JideMenu menu = new JideMenu(resourceBundle.getString("Menu.lookAndFeel"));
        menu.setMnemonic(resourceBundle.getString("Menu.lookAndFeel.mnemonic").charAt(0));
        JMenuItem item = new JMenuItem(resourceBundle.getString("Menu.windowsVsnet"));
        item.setMnemonic(resourceBundle.getString("Menu.windowsVsnet.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 7329857403026223556L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)2);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)3);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        menu.add(item);
        item = new JMenuItem(resourceBundle.getString("Menu.windowsVsnetGradient"));
        item.setMnemonic(resourceBundle.getString("Menu.windowsVsnetGradient.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1317964936229802115L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "true");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)4);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        menu.add(item);
        item = new JMenuItem(resourceBundle.getString("Menu.windowsVsnetClassic"));
        item.setMnemonic(resourceBundle.getString("Menu.windowsVsnetClassic.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -7357162252817623330L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        menu.add(item);
        item = new JMenuItem(resourceBundle.getString("Menu.windowsOffice2003"));
        item.setMnemonic(resourceBundle.getString("Menu.windowsOffice2003.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -7357162252817623330L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(3);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        item.setEnabled(SystemInfo.isWindows());
        menu.add(item);
        JideMenu themeMenu = new JideMenu(resourceBundle.getString("Menu.office2003Themes"));
        item.setMnemonic(resourceBundle.getString("Menu.office2003Themes.mnemonic").charAt(0));
        Collection<Office2003Theme> themes = ((Office2003Painter)Office2003Painter.getInstance()).getAvailableThemes();
        for (Office2003Theme theme : themes) {
            item = new JMenuItem(theme.getThemeName());
            item.addActionListener(new AbstractAction(theme.getThemeName()){
                private static final long serialVersionUID = -5040987591603805273L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Office2003Painter)Office2003Painter.getInstance()).setColorName((String)this.getValue("Name"));
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            themeMenu.add(item);
        }
        themeMenu.setEnabled(SystemInfo.isWindows());
        menu.add(themeMenu);
        item = new JMenuItem(resourceBundle.getString("Menu.windowsOffice2007"));
        item.setMnemonic(resourceBundle.getString("Menu.windowsOffice2007.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 9196873570605698569L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(7);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        item.setEnabled(SystemInfo.isWindowsVistaAbove());
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(resourceBundle.getString("Menu.windowsEclipse"));
        item.setMnemonic(resourceBundle.getString("Menu.windowsEclipse.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -439933116198670257L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(2);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        menu.add(item);
        item = new JMenuItem(resourceBundle.getString("Menu.windowsEclipse3x"));
        item.setMnemonic(resourceBundle.getString("Menu.windowsEclipse3x.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 5752902379748846824L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(5);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(resourceBundle.getString("Menu.xerto"));
        item.setMnemonic(resourceBundle.getString("Menu.xerto.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 8106961103954712663L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!SystemInfo.isWindows()) {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    } else {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(4);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        menu.add(item);
        item = new JMenuItem(resourceBundle.getString("Menu.metalVsnet"));
        item.setMnemonic(resourceBundle.getString("Menu.metalVsnet.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -8280662735260996990L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        menu.add(item);
        item = new JMenuItem(resourceBundle.getString("Menu.aqua"));
        item.setMnemonic(resourceBundle.getString("Menu.aqua.mnemonic").charAt(0));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2607089212872234201L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("apple.laf.AquaLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        item.setEnabled(SystemInfo.isMacOSX());
        menu.add(item);
        if (LookAndFeelFactory.isPlastic3DLnfInstalled() || LookAndFeelFactory.isPlasticXPLnfInstalled() || LookAndFeelFactory.isAlloyLnfInstalled() || LookAndFeelFactory.isA03LnfInstalled() || LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            menu.addSeparator();
        }
        if (LookAndFeelFactory.isPlastic3DLnfInstalled()) {
            item = new JMenuItem(resourceBundle.getString("Menu.plastic3DVsnet"));
            item.setMnemonic(resourceBundle.getString("Menu.plastic3DVsnet.mnemonic").charAt(0));
            item.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -9166134683152348076L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            menu.add(item);
        }
        if (LookAndFeelFactory.isPlasticXPLnfInstalled()) {
            item = new JMenuItem(resourceBundle.getString("Menu.plasticXPVsnet"));
            item.setMnemonic(resourceBundle.getString("Menu.plasticXPVsnet.mnemonic").charAt(0));
            item.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 7907842697885724816L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            menu.add(item);
        }
        if (LookAndFeelFactory.isBizlafLnfInstalled()) {
            item = new JMenuItem(resourceBundle.getString("Menu.bizlaf"));
            item.setMnemonic(resourceBundle.getString("Menu.bizlaf.mnemonic").charAt(0));
            item.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6326560496018798344L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("de.centigrade.bizlaf.BizLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension();
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            menu.add(item);
        }
        if (LookAndFeelFactory.isAlloyLnfInstalled()) {
            item = new JMenuItem(resourceBundle.getString("Menu.alloyVsnet"));
            item.setMnemonic(resourceBundle.getString("Menu.alloyVsnet.mnemonic").charAt(0));
            item.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -2585526602120461611L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.incors.plaf.alloy.AlloyLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            menu.add(item);
        }
        if (LookAndFeelFactory.isA03LnfInstalled()) {
            item = new JMenuItem(resourceBundle.getString("Menu.a03Xerto"));
            item.setMnemonic(resourceBundle.getString("Menu.a03Xerto.mnemonic").charAt(0));
            item.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6326560496018798344L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("a03.swing.plaf.A03LookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(4);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            menu.add(item);
        }
        if (LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            menu.add(CommandBarFactory.createLAFMenu(resourceBundle.getString("Menu.synthetica"), container, SYNTHETICA_LAFS));
        }
        if (LookAndFeelFactory.isPlastic3DLnfInstalled() || LookAndFeelFactory.isPlasticXPLnfInstalled() || LookAndFeelFactory.isAlloyLnfInstalled() || LookAndFeelFactory.isA03LnfInstalled() || LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            menu.addSeparator();
        }
        item = new JMenuItem(resourceBundle.getString("Menu.systemDefault"));
        item.setMnemonic(resourceBundle.getString("Menu.systemDefault.mnemonic").charAt(0));
        item.setToolTipText(resourceBundle.getString("Menu.systemDefault.toolTip"));
        item.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 7329857403026223556L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        menu.add(item);
        return menu;
    }

    public static CommandBar createLookAndFeelCommandBar(final Container container) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        CommandBar commandBar = new CommandBar(resourceBundle.getString("Menu.lookAndFeel"));
        commandBar.setInitSide(1);
        commandBar.setInitMode(2);
        commandBar.setInitIndex(2);
        JButton button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsVsnet.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.windowsVsnet.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.windowsVsnet"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 3201541150821346747L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)2);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)3);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        button.setEnabled(SystemInfo.isWindows());
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsVsnetGradient.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.windowsVsnetGradient.abbr.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.windowsVsnetGradient"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 8646024555450082333L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "true");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)4);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        button.setEnabled(SystemInfo.isWindows());
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsVsnetClassic.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.windowsVsnetClassic.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.windowsVsnetClassic"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 3201541150821346747L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        button.setEnabled(SystemInfo.isWindows());
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsOffice2003.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.windowsOffice2003.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.windowsOffice2003"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -1327530702444587931L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(3);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        button.setEnabled(SystemInfo.isWindows());
        JideSplitButton splitButton = (JideSplitButton)commandBar.add(CommandBarFactory.createSplitButton(resourceBundle.getString("Menu.office2003Themes.abbr")));
        splitButton.setMnemonic(resourceBundle.getString("Menu.office2003Themes.mnemonic").charAt(0));
        splitButton.setToolTipText(resourceBundle.getString("Menu.office2003Themes"));
        splitButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -8255668487163004250L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String colorName = ((Office2003Painter)Office2003Painter.getInstance()).getColorName();
                if (colorName == null || colorName.trim().length() == 0) {
                    colorName = "Default";
                }
                Collection<Office2003Theme> themes = ((Office2003Painter)Office2003Painter.getInstance()).getAvailableThemes();
                String firstName = null;
                Iterator<Office2003Theme> iterator = themes.iterator();
                while (iterator.hasNext()) {
                    Office2003Theme theme = iterator.next();
                    if (firstName == null) {
                        firstName = theme.getThemeName();
                    }
                    if (!theme.getThemeName().equals(colorName)) continue;
                    if (iterator.hasNext()) {
                        Office2003Theme nextTheme = iterator.next();
                        ((Office2003Painter)Office2003Painter.getInstance()).setColorName(nextTheme.getThemeName());
                        CommandBarFactory.updateComponentTreeUI(container);
                        continue;
                    }
                    ((Office2003Painter)Office2003Painter.getInstance()).setColorName(firstName);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            }
        });
        Collection<Office2003Theme> themes = ((Office2003Painter)Office2003Painter.getInstance()).getAvailableThemes();
        for (Office2003Theme theme : themes) {
            JMenuItem item = new JMenuItem(theme.getThemeName());
            item.addActionListener(new AbstractAction(theme.getThemeName()){
                private static final long serialVersionUID = -3081613616829830963L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Office2003Painter)Office2003Painter.getInstance()).setColorName((String)this.getValue("Name"));
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            splitButton.add(item);
        }
        splitButton.setEnabled(SystemInfo.isWindows());
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsOffice2007.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.windowsOffice2007.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.windowsOffice2007"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 2947691667876664962L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(7);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        button.setEnabled(SystemInfo.isWindowsVistaAbove());
        commandBar.addSeparator();
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsEclipse.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.windowsEclipse.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.windowsEclipse"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2312049199057067200L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(2);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        button.setEnabled(SystemInfo.isWindows());
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsEclipse3x.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.windowsEclipse3x.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.windowsEclipse3x"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1934151950524403252L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(5);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        button.setEnabled(SystemInfo.isWindows());
        commandBar.addSeparator();
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.xerto.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.xerto.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.xerto"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 8377070200610409569L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!SystemInfo.isWindows()) {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    } else {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(4);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        commandBar.addSeparator();
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.metalVsnet.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.metalVsnet.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.metalVsnet"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 135917786379131644L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        commandBar.addSeparator();
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.aqua.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.aqua.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.aqua"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -3414435917876447440L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UIManager.setLookAndFeel("apple.laf.AquaLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        button.setEnabled(SystemInfo.isMacOSX());
        if (LookAndFeelFactory.isPlastic3DLnfInstalled() || LookAndFeelFactory.isPlasticXPLnfInstalled() || LookAndFeelFactory.isAlloyLnfInstalled() || LookAndFeelFactory.isA03LnfInstalled() || LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            commandBar.addSeparator();
        }
        if (LookAndFeelFactory.isPlastic3DLnfInstalled()) {
            button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.plastic3DVsnet.abbr")));
            button.setMnemonic(resourceBundle.getString("Menu.plastic3DVsnet.mnemonic").charAt(0));
            button.setToolTipText(resourceBundle.getString("Menu.plastic3DVsnet"));
            button.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -8944151945641690341L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isPlasticXPLnfInstalled()) {
            button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.plasticXPVsnet.abbr")));
            button.setMnemonic(resourceBundle.getString("Menu.plasticXPVsnet.mnemonic").charAt(0));
            button.setToolTipText(resourceBundle.getString("Menu.plasticXPVsnet"));
            button.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -5532844695635634405L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isBizlafLnfInstalled()) {
            button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.bizlaf.abbr")));
            button.setMnemonic(resourceBundle.getString("Menu.bizlaf.mnemonic").charAt(0));
            button.setToolTipText(resourceBundle.getString("Menu.bizlaf"));
            button.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -8161576554724617386L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("de.centigrade.bizlaf.BizLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension();
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isAlloyLnfInstalled()) {
            button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.alloyVsnet.abbr")));
            button.setMnemonic(resourceBundle.getString("Menu.alloyVsnet.mnemonic").charAt(0));
            button.setToolTipText(resourceBundle.getString("Menu.alloyVsnet"));
            button.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 5740971958571563440L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.incors.plaf.alloy.AlloyLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isA03LnfInstalled()) {
            button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.a03Xerto.abbr")));
            button.setMnemonic(resourceBundle.getString("Menu.a03Xerto.mnemonic").charAt(0));
            button.setToolTipText(resourceBundle.getString("Menu.a03Xerto"));
            button.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 4255442222043846798L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        UIManager.setLookAndFeel("a03.swing.plaf.A03LookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(4);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            Component[] menus;
            splitButton = (JideSplitButton)commandBar.add(CommandBarFactory.createSplitButton(resourceBundle.getString("Menu.synthetica.abbr")));
            splitButton.setToolTipText(resourceBundle.getString("Menu.synthetica"));
            splitButton.setAlwaysDropdown(true);
            JMenu menu = CommandBarFactory.createLAFMenu(resourceBundle.getString("Menu.synthetica.abbr"), container, SYNTHETICA_LAFS);
            for (Component m : menus = menu.getPopupMenu().getComponents()) {
                splitButton.add(m);
            }
        }
        if (LookAndFeelFactory.isPlastic3DLnfInstalled() || LookAndFeelFactory.isPlasticXPLnfInstalled() || LookAndFeelFactory.isAlloyLnfInstalled() || LookAndFeelFactory.isA03LnfInstalled() || LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            commandBar.addSeparator();
        }
        button = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.systemDefault.abbr")));
        button.setMnemonic(resourceBundle.getString("Menu.systemDefault.mnemonic").charAt(0));
        button.setToolTipText(resourceBundle.getString("Menu.systemDefault.toolTip"));
        button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -8161576554724617386L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        return commandBar;
    }

    static class LAFChangeAction
    extends AbstractAction {
        private String className;
        private Container container;
        private static final long serialVersionUID = -6659135494779426406L;

        public LAFChangeAction(Container container, String lafClassName) {
            this.container = container;
            this.className = lafClassName;
            this.putValue("Name", this.toString());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                SynthStyleFactory synthStyleFactory;
                if (!this.className.contains("Synthetica") && (synthStyleFactory = SynthLookAndFeel.getStyleFactory()) != null) {
                    Method method = synthStyleFactory.getClass().getMethod("prepareMetalLAFSwitch", new Class[0]);
                    method.invoke((Object)synthStyleFactory, new Object[0]);
                }
                UIManager.setLookAndFeel(this.className);
                CommandBarFactory.updateComponentTreeUI(this.container);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.className.substring(this.className.lastIndexOf(46) + 1);
        }
    }
}

