/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml.transformer.xproc.calabash;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritableDocument;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.URIUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;
import ro.sync.exml.editor.results.iterator.ResultItem;
import ro.sync.xml.transformer.xproc.api.XProcInputPort;
import ro.sync.xml.transformer.xproc.api.XProcOption;
import ro.sync.xml.transformer.xproc.api.XProcOutputPort;
import ro.sync.xml.transformer.xproc.api.XProcParameter;
import ro.sync.xml.transformer.xproc.api.XProcParametersPort;

final class XProcPipelineUtil {
    private XProcPipelineUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static void setPortParametersToPipeline(XProcParametersPort[] portParameters, XPipeline pipeline) {
        if (portParameters == null || portParameters.length == 0) {
            return;
        }
        for (XProcParametersPort portParams : portParameters) {
            XProcParameter[] parameters = portParams.getParameters();
            if (parameters == null || parameters.length <= 0) continue;
            String port = portParams.getPortName();
            if ("*".equals(port)) {
                port = null;
            }
            for (XProcParameter param : parameters) {
                XProcPipelineUtil.setParameterToPipeline(param, port, pipeline);
            }
        }
    }

    private static void setParameterToPipeline(XProcParameter param, String port, XPipeline pipeline) {
        String value = param.getValue();
        if (value == null) {
            return;
        }
        QName name = new QName("", param.getNamespaceURI(), param.getLocalName());
        if (port == null) {
            pipeline.setParameter(name, new RuntimeValue(value));
        } else {
            pipeline.setParameter(port, name, new RuntimeValue(value));
        }
    }

    static void setOptionsToPipeline(XProcOption[] options, XPipeline pipeline) {
        if (options == null || options.length == 0) {
            return;
        }
        for (XProcOption option : options) {
            if (option.getValue() == null) continue;
            pipeline.passOption(new QName("", option.getNamespaceURI(), option.getLocalName()), new RuntimeValue(option.getValue()));
        }
    }

    static void setInputPortsMappingToPipeline(XProcInputPort[] inputPortsMapping, XPipeline pipeline, Set<String> initialInputPorts, XProcRuntime runtime) throws SaxonApiException {
        if (inputPortsMapping == null || inputPortsMapping.length == 0 || initialInputPorts == null || initialInputPorts.isEmpty()) {
            return;
        }
        for (XProcInputPort inputPort : inputPortsMapping) {
            if (!initialInputPorts.contains(inputPort.getPortName()) || !XProcPipelineUtil.portHasInputs(inputPort)) continue;
            XProcPipelineUtil.setInputsToPipeline(inputPort, pipeline, runtime);
        }
    }

    private static boolean portHasInputs(XProcInputPort inputPort) {
        String[] urls = inputPort.getUrls();
        return urls != null && urls.length > 0;
    }

    private static void setInputsToPipeline(XProcInputPort inputPort, XPipeline pipeline, XProcRuntime runtime) throws SaxonApiException {
        pipeline.clearInputs(inputPort.getPortName());
        XdmNode doc = null;
        for (String uri : inputPort.getUrls()) {
            if ("-".equals(uri = uri.trim())) {
                SAXSource source = new SAXSource(new InputSource(System.in));
                DocumentBuilder builder = runtime.getProcessor().newDocumentBuilder();
                doc = builder.build((Source)source);
            } else if (uri.length() > 0) {
                doc = runtime.parse(uri, URIUtils.cwdAsURI().toASCIIString());
            }
            pipeline.writeTo(inputPort.getPortName(), doc);
        }
    }

    static Set<String> setOutputPortsMappingToPipeline(XProcOutputPort[] outputPortsMapping, XPipeline pipeline, XProcRuntime runtime, Map<String, List<ResultItem>> portsAndResults) throws SaxonApiException, UnsupportedEncodingException {
        Set outputPorts = pipeline.getOutputs();
        if (outputPortsMapping == null || outputPortsMapping.length == 0 || outputPorts.isEmpty()) {
            return outputPorts;
        }
        for (XProcOutputPort outputPort : outputPortsMapping) {
            String port = outputPort.getPortName();
            if (!outputPorts.remove(port)) continue;
            XProcPipelineUtil.processOutputPort(outputPort, pipeline, runtime, portsAndResults);
        }
        return outputPorts;
    }

    private static void processOutputPort(XProcOutputPort outputPort, XPipeline pipeline, XProcRuntime runtime, Map<String, List<ResultItem>> portsAndResults) throws SaxonApiException, UnsupportedEncodingException {
        String port = outputPort.getPortName();
        Serialization serial = pipeline.getSerialization(port);
        String output = outputPort.getUrl();
        if (output != null && !(output = output.trim()).isEmpty()) {
            WritableDocument wdoc = new WritableDocument(runtime, output, serial);
            XProcPipelineUtil.fromPipelineToDocument(pipeline, port, (WritablePipe)wdoc);
        }
        if (outputPort.showInSequenceView()) {
            ReadablePipe rpipe = pipeline.readFrom(port);
            rpipe.canReadSequence(true);
            ArrayList<ResultItem> result = new ArrayList<ResultItem>();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (rpipe.moreDocuments()) {
                baos.reset();
                WritableDocument wdoc = new WritableDocument(runtime, null, serial, (OutputStream)baos);
                wdoc.write(rpipe.read());
                if (baos.size() <= 0) continue;
                result.add(XProcPipelineUtil.newResultItem(baos.toByteArray(), serial));
            }
            portsAndResults.put(port, result);
        }
    }

    private static void fromPipelineToDocument(XPipeline pipeline, String port, WritablePipe wdoc) throws SaxonApiException {
        ReadablePipe rpipe = pipeline.readFrom(port);
        while (rpipe.moreDocuments()) {
            wdoc.write(rpipe.read());
        }
    }

    static void defaultProcessOutputPorts(Set<String> outputPorts, XPipeline pipeline, XProcRuntime runtime, Map<String, List<ResultItem>> portsAndResults) throws SaxonApiException, UnsupportedEncodingException {
        if (outputPorts == null || outputPorts.isEmpty()) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String port : outputPorts) {
            baos.reset();
            Serialization serial = pipeline.getSerialization(port);
            WritableDocument wdoc = new WritableDocument(runtime, null, serial, (OutputStream)baos);
            XProcPipelineUtil.fromPipelineToDocument(pipeline, port, (WritablePipe)wdoc);
            ArrayList<ResultItem> result = new ArrayList<ResultItem>();
            if (baos.size() > 0) {
                result.add(XProcPipelineUtil.newResultItem(baos.toByteArray(), serial));
            }
            portsAndResults.put(port, result);
        }
    }

    private static ResultItem newResultItem(byte[] data, Serialization serial) throws UnsupportedEncodingException {
        return new ResultItem(0, new String(data, XProcPipelineUtil.getEncoding(serial)));
    }

    private static String getEncoding(Serialization serial) {
        String encoding = null;
        if (serial != null) {
            encoding = serial.getEncoding();
        }
        return encoding != null ? encoding : "UTF-8";
    }
}

