/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml.transformer.xproc.calabash;

import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.core.XProcRuntime;
import java.util.Set;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.xml.transformer.xproc.calabash.XProcUtils;

public class XProcErrorListener
implements XProcMessageListener {
    private final XProcRuntime runtime;
    private final Set<DocumentPositionedInfo> dpis;
    private final String pipelineURI;

    public XProcErrorListener(Set<DocumentPositionedInfo> dpis, XProcRuntime runtime, String pipelineURI) {
        this.dpis = dpis;
        this.runtime = runtime;
        this.pipelineURI = pipelineURI;
    }

    public void error(Throwable t) {
        this.dpis.add(XProcUtils.processException(t, this.runtime, this.pipelineURI, false));
    }

    public void warning(Throwable t) {
        this.dpis.add(XProcUtils.processException(t, this.runtime, this.pipelineURI, true));
    }

    public void error(XProcRunnable step, XdmNode node, String message, QName code) {
        StringBuilder sb = new StringBuilder(message);
        if (code != null) {
            sb.insert(0, code.toString() + " : ");
            String error = XProcUtils.errorMessage(code, this.runtime);
            if (error != null) {
                sb.append(" (").append(error).append(')');
            }
        }
        DocumentPositionedInfo dpi = new DocumentPositionedInfo(2, sb.toString(), node == null ? this.pipelineURI : node.getDocumentURI().toString(), node == null ? -1 : node.getLineNumber(), -1);
        dpi.setAdditionalInfo(XProcUtils.processErrorCode(code));
        this.dpis.add(dpi);
    }

    public void warning(XProcRunnable step, XdmNode node, String message) {
        this.dpis.add(new DocumentPositionedInfo(1, message, node == null ? this.pipelineURI : node.getDocumentURI().toString(), node == null ? -1 : node.getLineNumber(), -1));
    }

    public void info(XProcRunnable step, XdmNode node, String message) {
        this.dpis.add(new DocumentPositionedInfo(0, message, node == null ? this.pipelineURI : node.getDocumentURI().toString(), node == null ? -1 : node.getLineNumber(), -1));
    }

    public void fine(XProcRunnable step, XdmNode node, String message) {
    }

    public void finer(XProcRunnable step, XdmNode node, String message) {
    }

    public void finest(XProcRunnable step, XdmNode node, String message) {
    }
}

