/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security.manager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.security.manager.IPAddressUtil;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public final class URLPermission
extends Permission {
    private static final long serialVersionUID = -2702463814894478682L;
    private transient String scheme;
    private transient String ssp;
    private transient String path;
    private transient List<String> methods;
    private transient List<String> requestHeaders;
    private transient Authority authority;
    private String actions;
    private boolean acceptAll;

    public URLPermission(String url, String actions) {
        super(url);
        this.init(actions);
    }

    private void init(String actions) {
        String headers;
        String methods;
        this.parseURI(this.getName());
        int colon = actions.indexOf(58);
        if (actions.lastIndexOf(58) != colon) {
            throw new IllegalArgumentException("invalid actions string");
        }
        if (colon == -1) {
            methods = actions;
            headers = "";
        } else {
            methods = actions.substring(0, colon);
            headers = actions.substring(colon + 1);
        }
        List<String> l = this.normalizeMethods(methods);
        Collections.sort(l);
        this.methods = Collections.unmodifiableList(l);
        l = this.normalizeHeaders(headers);
        Collections.sort(l);
        this.requestHeaders = Collections.unmodifiableList(l);
        this.actions = this.actions();
    }

    public URLPermission(String url) {
        this(url, "*:*");
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public boolean implies(Permission p) {
        if (!this.acceptAll || "java.net.URLPermissions".equals(p.getClass().getName())) {
            // empty if block
        }
        if (!(p instanceof URLPermission)) {
            return false;
        }
        URLPermission that = (URLPermission)p;
        if (!this.methods.get(0).equals("*") && Collections.indexOfSubList(this.methods, that.methods) == -1) {
            return false;
        }
        if (this.requestHeaders.isEmpty() && !that.requestHeaders.isEmpty()) {
            return false;
        }
        if (!this.requestHeaders.isEmpty() && !this.requestHeaders.get(0).equals("*") && Collections.indexOfSubList(this.requestHeaders, that.requestHeaders) == -1) {
            return false;
        }
        if (!this.scheme.equals(that.scheme)) {
            return false;
        }
        if (this.ssp.equals("*")) {
            return true;
        }
        if (!this.authority.implies(that.authority)) {
            return false;
        }
        if (this.path == null) {
            return that.path == null;
        }
        if (that.path == null) {
            return false;
        }
        if (this.path.endsWith("/-")) {
            String thisprefix = this.path.substring(0, this.path.length() - 1);
            return that.path.startsWith(thisprefix);
        }
        if (this.path.endsWith("/*")) {
            String thisprefix = this.path.substring(0, this.path.length() - 1);
            if (!that.path.startsWith(thisprefix)) {
                return false;
            }
            String thatsuffix = that.path.substring(thisprefix.length());
            if (thatsuffix.indexOf(47) != -1) {
                return false;
            }
            return !thatsuffix.equals("-");
        }
        return this.path.equals(that.path);
    }

    @Override
    public boolean equals(Object p) {
        if (!(p instanceof URLPermission)) {
            return false;
        }
        URLPermission that = (URLPermission)p;
        if (!this.scheme.equals(that.scheme)) {
            return false;
        }
        if (!this.getActions().equals(that.getActions())) {
            return false;
        }
        if (!this.authority.equals(that.authority)) {
            return false;
        }
        if (this.path != null) {
            return this.path.equals(that.path);
        }
        return that.path == null;
    }

    @Override
    public int hashCode() {
        return this.getActions().hashCode() + this.scheme.hashCode() + this.authority.hashCode() + (this.path == null ? 0 : this.path.hashCode());
    }

    private List<String> normalizeMethods(String methods) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < methods.length(); ++i) {
            char c = methods.charAt(i);
            if (c == ',') {
                String s = b.toString();
                if (s.length() > 0) {
                    l.add(s);
                }
                b = new StringBuilder();
                continue;
            }
            if (c == ' ' || c == '\t') {
                throw new IllegalArgumentException("white space not allowed");
            }
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            b.append(c);
        }
        String s = b.toString();
        if (s.length() > 0) {
            l.add(s);
        }
        return l;
    }

    private List<String> normalizeHeaders(String headers) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        boolean capitalizeNext = true;
        for (int i = 0; i < headers.length(); ++i) {
            char c = headers.charAt(i);
            if (c >= 'a' && c <= 'z') {
                if (capitalizeNext) {
                    c = (char)(c - 32);
                    capitalizeNext = false;
                }
                b.append(c);
                continue;
            }
            if (c == ' ' || c == '\t') {
                throw new IllegalArgumentException("white space not allowed");
            }
            if (c == '-') {
                capitalizeNext = true;
                b.append(c);
                continue;
            }
            if (c == ',') {
                String s = b.toString();
                if (s.length() > 0) {
                    l.add(s);
                }
                b = new StringBuilder();
                capitalizeNext = true;
                continue;
            }
            capitalizeNext = false;
            b.append(c);
        }
        String s = b.toString();
        if (s.length() > 0) {
            l.add(s);
        }
        return l;
    }

    private void parseURI(String url) {
        String auth;
        int len = url.length();
        int delim = url.indexOf(58);
        if (delim == -1 || delim + 1 == len) {
            throw new IllegalArgumentException("invalid URL string");
        }
        this.scheme = url.substring(0, delim).toLowerCase();
        this.ssp = url.substring(delim + 1);
        if (!this.ssp.startsWith("//")) {
            if (!this.ssp.equals("*")) {
                throw new IllegalArgumentException("invalid URL string");
            }
            this.authority = new Authority(this.scheme, "*");
            return;
        }
        String authpath = this.ssp.substring(2);
        delim = authpath.indexOf(47);
        if (delim == -1) {
            this.path = "";
            auth = authpath;
        } else {
            auth = authpath.substring(0, delim);
            this.path = authpath.substring(delim);
        }
        this.authority = new Authority(this.scheme, auth.toLowerCase());
    }

    private String actions() {
        StringBuilder b = new StringBuilder();
        for (String s : this.methods) {
            b.append(s);
        }
        b.append(":");
        for (String s : this.requestHeaders) {
            b.append(s);
        }
        return b.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        String actions = (String)fields.get("actions", null);
        this.init(actions);
    }

    static class Authority {
        HostPortrange p;

        Authority(String scheme, String authority) {
            int at = authority.indexOf(64);
            this.p = at == -1 ? new HostPortrange(scheme, authority) : new HostPortrange(scheme, authority.substring(at + 1));
        }

        boolean implies(Authority other) {
            return this.impliesHostrange(other) && this.impliesPortrange(other);
        }

        private boolean impliesHostrange(Authority that) {
            String thishost = this.p.hostname();
            String thathost = that.p.hostname();
            if (this.p.wildcard() && thishost.equals("")) {
                return true;
            }
            if (that.p.wildcard() && thathost.equals("")) {
                return false;
            }
            if (thishost.equals(thathost)) {
                return true;
            }
            if (this.p.wildcard()) {
                return thathost.endsWith(thishost);
            }
            return false;
        }

        private boolean impliesPortrange(Authority that) {
            int[] thisrange = this.p.portrange();
            int[] thatrange = that.p.portrange();
            if (thisrange[0] == -1) {
                return true;
            }
            return thisrange[0] <= thatrange[0] && thisrange[1] >= thatrange[1];
        }

        boolean equals(Authority that) {
            return this.p.equals(that.p);
        }

        public int hashCode() {
            return this.p.hashCode();
        }
    }

    private static class HostPortrange {
        String hostname;
        String scheme;
        int[] portrange;
        boolean wildcard;
        boolean literal;
        boolean ipv6;
        boolean ipv4;
        static final int PORT_MIN = 0;
        static final int PORT_MAX = 65535;
        static final int CASE_DIFF = -32;
        static final int[] HTTP_PORT = new int[]{80, 80};
        static final int[] HTTPS_PORT = new int[]{443, 443};
        static final int[] NO_PORT = new int[]{-1, -1};

        boolean equals(HostPortrange that) {
            return this.hostname.equals(that.hostname) && this.portrange[0] == that.portrange[0] && this.portrange[1] == that.portrange[1] && this.wildcard == that.wildcard && this.literal == that.literal;
        }

        public int hashCode() {
            return this.hostname.hashCode() + this.portrange[0] + this.portrange[1];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        HostPortrange(String scheme, String str) {
            String portstr = null;
            this.scheme = scheme;
            if (str.charAt(0) == '[') {
                byte[] ip;
                this.literal = true;
                this.ipv6 = true;
                int rb = str.indexOf(93);
                if (rb == -1) {
                    throw new IllegalArgumentException("invalid IPv6 address: " + str);
                }
                String hoststr = str.substring(1, rb);
                int sep = str.indexOf(58, rb + 1);
                if (sep != -1 && str.length() > sep) {
                    portstr = str.substring(sep + 1);
                }
                if ((ip = IPAddressUtil.textToNumericFormatV6(hoststr)) == null) {
                    throw new IllegalArgumentException("illegal IPv6 address");
                }
                StringBuilder sb = new StringBuilder();
                Formatter formatter = new Formatter(sb, Locale.US);
                formatter.format("%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x", ip[0], ip[1], ip[2], ip[3], ip[4], ip[5], ip[6], ip[7], ip[8], ip[9], ip[10], ip[11], ip[12], ip[13], ip[14], ip[15]);
                this.hostname = sb.toString();
                formatter.close();
            } else {
                String hoststr;
                int sep = str.indexOf(58);
                if (sep != -1 && str.length() > sep) {
                    hoststr = str.substring(0, sep);
                    portstr = str.substring(sep + 1);
                } else {
                    String string = hoststr = sep == -1 ? str : str.substring(0, sep);
                }
                if (hoststr.startsWith("*")) {
                    this.wildcard = true;
                    if (hoststr.equals("*")) {
                        hoststr = "";
                    } else {
                        if (!hoststr.startsWith("*.")) throw new IllegalArgumentException("invalid host wildcard specification");
                        hoststr = HostPortrange.toLowerCase(hoststr.substring(1));
                    }
                } else {
                    int lastdot = hoststr.lastIndexOf(46);
                    if (lastdot != -1 && hoststr.length() > 1) {
                        boolean ipv4 = true;
                        int len = hoststr.length();
                        for (int i = lastdot + 1; i < len; ++i) {
                            char c = hoststr.charAt(i);
                            if (c >= '0' && c <= '9') continue;
                            ipv4 = false;
                            break;
                        }
                        this.ipv4 = this.literal = ipv4;
                        if (ipv4) {
                            byte[] ip = IPAddressUtil.textToNumericFormatV4(hoststr);
                            if (ip == null) {
                                throw new IllegalArgumentException("illegal IPv4 address");
                            }
                            StringBuilder sb = new StringBuilder();
                            Formatter formatter = new Formatter(sb, Locale.US);
                            formatter.format("%d.%d.%d.%d", ip[0], ip[1], ip[2], ip[3]);
                            hoststr = sb.toString();
                            formatter.close();
                        } else {
                            hoststr = HostPortrange.toLowerCase(hoststr);
                        }
                    }
                }
                this.hostname = hoststr;
            }
            try {
                this.portrange = this.parsePort(portstr);
                return;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid port range: " + portstr);
            }
        }

        private static String toLowerCase(String s) {
            return s.toLowerCase();
        }

        public boolean literal() {
            return this.literal;
        }

        public boolean ipv4Literal() {
            return this.ipv4;
        }

        public boolean ipv6Literal() {
            return this.ipv6;
        }

        public String hostname() {
            return this.hostname;
        }

        public int[] portrange() {
            return this.portrange;
        }

        public boolean wildcard() {
            return this.wildcard;
        }

        private int[] defaultPort() {
            if (this.scheme.equals("http")) {
                return HTTP_PORT;
            }
            if (this.scheme.equals("https")) {
                return HTTPS_PORT;
            }
            return NO_PORT;
        }

        private int[] parsePort(String port) {
            if (port == null || port.equals("")) {
                return this.defaultPort();
            }
            if (port.equals("*")) {
                return new int[]{0, 65535};
            }
            try {
                int dash = port.indexOf(45);
                if (dash == -1) {
                    int p = Integer.parseInt(port);
                    return new int[]{p, p};
                }
                String low = port.substring(0, dash);
                String high = port.substring(dash + 1);
                int l = low.equals("") ? 0 : Integer.parseInt(low);
                int h = high.equals("") ? 65535 : Integer.parseInt(high);
                if (l < 0 || h < 0 || h < l) {
                    return this.defaultPort();
                }
                return new int[]{l, h};
            }
            catch (IllegalArgumentException e) {
                return this.defaultPort();
            }
        }
    }
}

