/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class MultilineCommentHighlighter
extends Highlighter {
    protected String start;
    protected String end;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.start = params.getParam("start");
        this.end = params.getParam("end");
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
        if (this.end == null || this.end.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'end' is not set.");
        }
    }

    @Override
    public boolean startsWith(CharIter in) {
        return in.startsWith(this.start);
    }

    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        in.moveNext(this.start.length());
        int endIndex = in.indexOf(this.end);
        if (endIndex == -1) {
            in.moveToEnd();
        } else {
            in.moveNext(endIndex + this.end.length());
        }
        out.add(in.markedToStyledBlock(this.styleName));
        return true;
    }

    @Override
    public String getDefaultStyle() {
        return "comment";
    }
}

