/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class AnnotationHighlighter
extends Highlighter {
    protected String start;
    protected String end;
    protected String valueStart;
    protected String valueEnd;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.start = params.getParam("start");
        this.end = params.getParam("end");
        this.valueStart = params.getParam("valueStart");
        this.valueEnd = params.getParam("valueEnd");
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
    }

    @Override
    public String getDefaultStyle() {
        return "annotation";
    }

    @Override
    public boolean startsWith(CharIter in) {
        Character next;
        if (!in.finished() && in.startsWith(this.start) && !in.finished() && (next = in.next(this.start.length())) != null) {
            return Character.isJavaIdentifierStart(next.charValue());
        }
        return false;
    }

    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        in.moveNext(this.start.length());
        int valueCnt = 0;
        boolean hadEnd = false;
        while (!in.finished()) {
            if (this.valueStart != null && in.startsWith(this.valueStart)) {
                ++valueCnt;
            } else if (this.valueEnd != null && in.startsWith(this.valueEnd)) {
                --valueCnt;
            } else if (valueCnt == 0) {
                if (this.end != null && valueCnt == 0 && in.startsWith(this.end)) {
                    in.moveNext(this.end.length());
                    hadEnd = true;
                    break;
                }
                if (this.end == null && Character.isWhitespace(in.current().charValue())) {
                    hadEnd = true;
                    break;
                }
            }
            in.moveNext();
        }
        if (!hadEnd) {
            return false;
        }
        out.add(in.markedToStyledBlock(this.styleName));
        return true;
    }
}

