/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.xslthl.Block;
import net.sf.xslthl.StyledBlock;

public class CharIter
implements Iterable<Character>,
Iterator<Character> {
    private String buffer;
    private int position = 0;
    private int length;
    private int mark = 0;
    private Matcher matcher;

    public CharIter(String input) {
        this.buffer = input;
        this.length = input.length();
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark() {
        this.mark = this.position;
    }

    public void setMark(int newMark) {
        this.mark = newMark;
    }

    public boolean isMarked() {
        return this.mark < this.position;
    }

    public String getMarked() {
        if (this.position > this.length) {
            this.position = this.length;
        }
        return this.buffer.substring(this.mark, this.position);
    }

    public Block markedToBlock() {
        Block b = new Block(this.getMarked());
        this.setMark();
        return b;
    }

    public Block markedToStyledBlock(String styleName) {
        StyledBlock b = new StyledBlock(this.getMarked(), styleName);
        this.setMark();
        return b;
    }

    public void moveNext() {
        ++this.position;
    }

    public void moveNext(int offset) {
        this.position += offset;
    }

    public void moveNextAndMark() {
        this.moveNext();
        this.setMark();
    }

    public void moveToEnd() {
        this.position = this.length;
    }

    public boolean finished() {
        return this.position >= this.length;
    }

    public Character current() {
        return Character.valueOf(this.buffer.charAt(this.position));
    }

    @Override
    public Character next() {
        if (this.position + 1 < this.length) {
            return Character.valueOf(this.buffer.charAt(this.position + 1));
        }
        return null;
    }

    public Character next(int offset) {
        if (this.position + offset < this.length) {
            return Character.valueOf(this.buffer.charAt(this.position + offset));
        }
        return null;
    }

    public Character prev() {
        if (this.position > 0) {
            return Character.valueOf(this.buffer.charAt(this.position - 1));
        }
        return null;
    }

    public Character prev(int offset) {
        if (this.position - offset >= 0) {
            return Character.valueOf(this.buffer.charAt(this.position - offset));
        }
        return null;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, false);
    }

    public boolean startsWith(String prefix, boolean ignoreCase) {
        return this.startsWith(prefix, 0, ignoreCase);
    }

    public boolean startsWith(String prefix, int diff) {
        return this.startsWith(prefix, diff, false);
    }

    public boolean startsWith(String prefix, int diff, boolean ignoreCase) {
        if (ignoreCase) {
            int end = this.position + diff + prefix.length();
            if (end >= this.length) {
                end = this.length - 1;
            }
            if (this.position + diff >= end) {
                return false;
            }
            return this.buffer.substring(this.position + diff, end).equalsIgnoreCase(prefix);
        }
        return this.buffer.startsWith(prefix, this.position + diff);
    }

    public Matcher createMatcher(Pattern pattern) {
        this.matcher = pattern.matcher(this.buffer);
        return this.matcher;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.length;
    }

    public int remaining() {
        if (this.position < this.length) {
            return this.length - this.position;
        }
        return 0;
    }

    public int indexOf(String substr) {
        int index = this.buffer.indexOf(substr, this.position);
        return index < 0 ? -1 : index - this.position;
    }

    @Override
    public Iterator<Character> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.finished();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

