/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.printers;

import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.doctype.DoctypeGetter;
import com.oxygenxml.batch.converter.core.printers.ContentPrinter;
import com.oxygenxml.batch.converter.core.printers.ContentPrinterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContentPrinterImpl
implements ContentPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SimpleContentPrinterImpl.class.getName());
    private static final Pattern ENCODING_PATTERN = Pattern.compile("^[\\s]*<\\?xml[\\s]+version[\\s]*=[\\s]*\"1\\.0\"[\\s]+encoding=[\\s]*\"[\\s]*([^\\s\"]*)[\\s]*\"[\\s]*\\?>");

    @Override
    public void print(ConversionResult conversionResult, TransformerFactoryCreator transformerCreator, String converterType, File outputFile) throws TransformerException {
        String contentToPrint = conversionResult.getConvertedContent();
        boolean shouldAddDoctype = ContentPrinterUtils.shouldAddDoctype(conversionResult, converterType);
        String encoding = "UTF-8";
        if (shouldAddDoctype) {
            String encodingLine = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            Matcher matcher = ENCODING_PATTERN.matcher(contentToPrint);
            if (matcher.find()) {
                encoding = matcher.group(1);
                encodingLine = matcher.group(0);
                contentToPrint = matcher.replaceFirst("");
                contentToPrint = contentToPrint.replaceAll("^\\s", "");
            }
            contentToPrint = SimpleContentPrinterImpl.addEncodingAndDoctype(contentToPrint, encodingLine, conversionResult, converterType);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), encoding);){
            writer.write(contentToPrint);
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    private static String addEncodingAndDoctype(String content, String encodingLine, ConversionResult conversionResult, String convertedType) {
        String doctype;
        StringBuilder sb = new StringBuilder();
        sb.append(encodingLine).append('\n');
        if (!content.contains("<!DOCTYPE") && !(doctype = DoctypeGetter.getDoctype(conversionResult, convertedType)).isEmpty()) {
            sb.append(doctype).append('\n');
        }
        sb.append(content);
        return sb.toString();
    }
}

