/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.openapi;

import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiPostProcessingUtil;
import org.json.oxygen.JSONUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class OpenApiUnescaperXmlFilter
extends XMLFilterImpl {
    private static final String TO_UNESCAPE_ID_OUTPUTCLASS = "oxy-toUnescapeId";
    private static final String TO_UNESCAPE_OUTPUTCLASS = "oxy-toUnescape";
    private String currentOutputclassValue;
    private StringBuilder textToUnescape = new StringBuilder();

    public OpenApiUnescaperXmlFilter(XMLReader xmlReader) {
        super(xmlReader);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentOutputclassValue != null && this.currentOutputclassValue.contains(TO_UNESCAPE_OUTPUTCLASS)) {
            this.textToUnescape.append(String.valueOf(ch, start, length));
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.currentOutputclassValue != null && this.currentOutputclassValue.contains(TO_UNESCAPE_OUTPUTCLASS)) {
            this.escapeElementText();
        }
        this.textToUnescape.setLength(0);
        this.currentOutputclassValue = atts.getValue("outputclass");
        if (this.currentOutputclassValue != null) {
            if (this.currentOutputclassValue.contains(TO_UNESCAPE_ID_OUTPUTCLASS)) {
                atts = OpenApiPostProcessingUtil.unescapeIdAttribute(atts);
                atts = OpenApiPostProcessingUtil.removeTokenFromOutputClassAttributeValue(atts, TO_UNESCAPE_ID_OUTPUTCLASS);
            } else if (this.currentOutputclassValue.contains(TO_UNESCAPE_OUTPUTCLASS)) {
                atts = OpenApiPostProcessingUtil.removeTokenFromOutputClassAttributeValue(atts, TO_UNESCAPE_OUTPUTCLASS);
            }
        }
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentOutputclassValue != null && this.currentOutputclassValue.contains(TO_UNESCAPE_OUTPUTCLASS)) {
            this.escapeElementText();
        }
        this.currentOutputclassValue = null;
        this.textToUnescape.setLength(0);
        super.endElement(uri, localName, qName);
    }

    private void escapeElementText() throws SAXException {
        String text = this.textToUnescape.toString();
        if (!text.isEmpty()) {
            text = JSONUtil.unescapeXMLTagName((String)text);
            super.characters(text.toCharArray(), 0, text.length());
        }
    }
}

